/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.useractions.ui.uda.actions;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDAResources;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDActionSubsystem;
import org.eclipse.rse.internal.useractions.ui.uda.SystemWorkWithUDTypeDialog;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.actions.SystemBaseDialogAction;
import org.eclipse.swt.widgets.Shell;

public class SystemWorkWithFileTypesAction
extends SystemBaseDialogAction {
    private ISubSystem subsystem = null;
    private ISubSystemConfiguration subsystemFactory = null;
    private SystemUDActionSubsystem udaActionSubsystem;
    private ISystemProfile profile;
    private SystemWorkWithUDTypeDialog ourDlg = null;
    private String typeToPreSelect = null;
    private int preSelectTypeDomain;
    private String outputSelectedType;
    private int outputSelectedDomain = -1;

    public SystemWorkWithFileTypesAction(Shell parent, SystemUDActionSubsystem udaActionSubsystem) {
        this(parent);
        this.udaActionSubsystem = udaActionSubsystem;
        this.subsystem = udaActionSubsystem.getSubsystem();
        if (this.subsystem != null) {
            this.subsystemFactory = this.subsystem.getSubSystemConfiguration();
            this.profile = this.subsystem.getSystemProfile();
        }
        this.setAvailableOffline(true);
    }

    public SystemWorkWithFileTypesAction(Shell parent, ISubSystemConfiguration subSystemFactory, ISystemProfile profile) {
        this(parent);
        this.subsystemFactory = subSystemFactory;
        this.profile = profile;
    }

    public SystemWorkWithFileTypesAction(Shell parent) {
        super(SystemUDAResources.ACTION_WORKWITH_NAMEDTYPES_LABEL, SystemUDAResources.ACTION_WORKWITH_NAMEDTYPES_TOOLTIP, RSEUIPlugin.getDefault().getImageDescriptor("WORK_WITH_NAMED_TYPES_1"), parent);
        this.allowOnMultipleSelection(false);
        this.setContextMenuGroup("group.workwith");
        this.setHelp("org.eclipse.rse.ui.actn0046");
    }

    public void preSelectType(int domain, String type) {
        this.typeToPreSelect = type;
        this.preSelectTypeDomain = domain;
    }

    public boolean checkObjectType(Object selectedObject) {
        return true;
    }

    protected Dialog createDialog(Shell parent) {
        if (this.subsystem == null && this.getFirstSelection() instanceof ISubSystem) {
            this.subsystem = (ISubSystem)this.getFirstSelection();
        }
        this.ourDlg = this.subsystem != null ? new SystemWorkWithUDTypeDialog(parent, this.subsystem, this.udaActionSubsystem) : new SystemWorkWithUDTypeDialog(parent, this.subsystemFactory, this.profile);
        if (this.typeToPreSelect != null) {
            this.ourDlg.preSelectType(this.preSelectTypeDomain, this.typeToPreSelect);
        }
        return this.ourDlg;
    }

    protected Object getDialogValue(Dialog dlg) {
        this.outputSelectedType = ((SystemWorkWithUDTypeDialog)dlg).getSelectedTypeName();
        if (this.outputSelectedType != null && this.outputSelectedType.length() == 0) {
            this.outputSelectedType = null;
        }
        return this.outputSelectedType;
    }

    public String getSelectedTypeName() {
        this.outputSelectedType = this.ourDlg.getSelectedTypeName();
        if (this.outputSelectedType != null && this.outputSelectedType.length() == 0) {
            this.outputSelectedType = null;
        }
        return this.outputSelectedType;
    }

    public int getSelectedTypeDomain() {
        this.outputSelectedDomain = this.ourDlg.getSelectedTypeDomain();
        return this.outputSelectedDomain;
    }
}

