/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dstore.core.server;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.eclipse.dstore.core.java.RemoteClassLoader;
import org.eclipse.dstore.core.miners.miner.Miner;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.dstore.core.model.ISchemaExtender;
import org.eclipse.dstore.core.model.ISchemaRegistry;
import org.eclipse.dstore.core.util.ExternalLoader;

public class MinerLoader
implements ISchemaRegistry {
    private DataStore _dataStore;
    private ArrayList _miners;
    private ArrayList _minerList;
    private ArrayList _minerFileList;
    private ArrayList _connectedList;
    private ArrayList _loaders;
    private RemoteClassLoader _remoteLoader;
    private ExternalLoader _externalRemoteLoader;

    public MinerLoader(DataStore dataStore, ArrayList loaders) {
        this._dataStore = dataStore;
        this._loaders = loaders;
        this._miners = new ArrayList();
        this._minerList = new ArrayList();
        this._minerFileList = new ArrayList();
        this._connectedList = new ArrayList();
    }

    public void loadMiners() {
        String pluginDir = this._dataStore.getAttribute(0);
        String defaultMinerFile = String.valueOf(pluginDir) + File.separator + "minerFile.dat";
        File defaultMF = new File(defaultMinerFile);
        if (defaultMF.exists()) {
            try {
                this.loadMiners(defaultMinerFile, "UTF-8");
            }
            catch (Exception exception) {
                this._dataStore.trace("failed to load minerFile.data with UTF-8.  Trying with native encoding");
                try {
                    this.loadMiners(defaultMinerFile, null);
                }
                catch (Exception ex) {
                    this._dataStore.trace(ex);
                }
            }
            this._minerFileList.add(defaultMinerFile);
        }
        ArrayList minerLocations = this._dataStore.getMinersLocation();
        int i = 0;
        while (i < minerLocations.size()) {
            String minersDir = (String)minerLocations.get(i);
            String minerFile = null;
            minerFile = minersDir.endsWith(".dat") ? String.valueOf(pluginDir) + File.separator + minersDir : String.valueOf(pluginDir) + File.separator + minersDir + File.separator + "minerFile.dat";
            if (!this._minerFileList.contains(minerFile)) {
                try {
                    this.loadMiners(minerFile, "UTF-8");
                }
                catch (Exception exception) {
                    this._dataStore.trace("failed to load minerFile.data with UTF-8.  Trying with native encoding");
                    try {
                        this.loadMiners(minerFile, null);
                    }
                    catch (Exception ex) {
                        this._dataStore.trace(ex);
                    }
                }
                this._minerFileList.add(minerFile);
            }
            ++i;
        }
    }

    public ArrayList loadMiners(String minerFile, String encoding) throws Exception {
        ArrayList<Miner> unconnectedMiners = new ArrayList<Miner>();
        File file = new File(minerFile);
        FileInputStream inFile = new FileInputStream(file);
        BufferedReader in = null;
        in = encoding == null ? new BufferedReader(new InputStreamReader(inFile)) : new BufferedReader(new InputStreamReader((InputStream)inFile, encoding));
        String name = null;
        while ((name = in.readLine()) != null) {
            Miner miner;
            if ((name = name.trim()).startsWith("#") || name.length() <= 5 || (miner = this.loadMiner(name)) == null) continue;
            unconnectedMiners.add(miner);
        }
        this.connectMiners(unconnectedMiners);
        return this._miners;
    }

    public Miner loadMiner(String name) {
        Miner miner = null;
        if (!this._minerList.contains(name)) {
            try {
                Class theClass;
                ExternalLoader loader = this.getLoaderFor(name);
                if (loader != null && (miner = (Miner)(theClass = loader.loadClass(name)).newInstance()) != null) {
                    miner.setExternalLoader(loader);
                    this._minerList.add(name);
                }
            }
            catch (NoClassDefFoundError e) {
                e.printStackTrace();
                this.handleNoClassFound(e.getMessage().replace('/', '.'));
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                this.handleNoClassFound(name);
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return miner;
    }

    private void handleNoClassFound(String name) {
        this._remoteLoader.loadClassInThread(name);
    }

    private void connectMiners(ArrayList unconnectedMiners) {
        int i = 0;
        while (i < this._miners.size()) {
            this._connectedList.add(((Miner)this._miners.get(i)).getMinerName());
            ++i;
        }
        while (unconnectedMiners.size() > 0) {
            Miner miner = (Miner)unconnectedMiners.get(0);
            unconnectedMiners.remove(miner);
            if (this.connectMiner(miner)) {
                this._dataStore.trace("connected " + miner.getMinerName());
                continue;
            }
            unconnectedMiners.add(miner);
        }
    }

    public boolean connectMiner(Miner miner) {
        boolean canConnect = true;
        ArrayList dependencies = miner.getMinerDependencies();
        int i = 0;
        while (i < dependencies.size()) {
            String dependency = (String)dependencies.get(i);
            if (!this._connectedList.contains(dependency)) {
                canConnect = false;
            }
            ++i;
        }
        if (canConnect) {
            miner.setDataStore(this._dataStore);
            miner.extendSchema(this._dataStore.getDescriptorRoot());
            this._dataStore.refresh(this._dataStore.getDescriptorRoot());
            this._miners.add(miner);
            this._connectedList.add(miner.getMinerName());
            miner.start();
        }
        return canConnect;
    }

    public void registerSchemaExtender(ISchemaExtender extender) {
    }

    public void extendSchema(DataStore dataStore) {
        DataElement schemaRoot = dataStore.getDescriptorRoot();
        int i = 0;
        while (i < this._miners.size()) {
            Miner miner = (Miner)this._miners.get(i);
            miner.extendSchema(schemaRoot);
            ++i;
        }
    }

    public ExternalLoader getExternalRemoteLoader() {
        if (this._externalRemoteLoader == null) {
            this._externalRemoteLoader = new ExternalLoader((ClassLoader)this.getRemoteLoader(), "*");
        }
        return this._externalRemoteLoader;
    }

    public RemoteClassLoader getRemoteLoader() {
        return this._dataStore.getRemoteClassLoader();
    }

    public ExternalLoader getLoaderFor(String source) {
        ExternalLoader remoteLoader = this.getExternalRemoteLoader();
        return remoteLoader;
    }

    public ArrayList getMiners() {
        return this._miners;
    }

    public Miner getMiner(String name) {
        int i = 0;
        while (i < this._miners.size()) {
            Miner miner = (Miner)this._miners.get(i);
            if (miner.getClass().getName().equals(name)) {
                return miner;
            }
            ++i;
        }
        return null;
    }

    public void finishMiner(String name) {
        Miner miner = this.getMiner(name);
        miner.finish();
        this._miners.remove(miner);
    }

    public void finishMiners() {
        int i = 0;
        while (i < this._miners.size()) {
            Miner miner = (Miner)this._miners.get(i);
            miner.finish();
            ++i;
        }
    }
}

