/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dstore.core.server;

import java.net.Socket;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.server.ConnectionEstablisher;
import org.eclipse.dstore.core.util.Receiver;

public class ServerReceiver
extends Receiver {
    private ConnectionEstablisher _connection;

    public ServerReceiver(Socket socket, ConnectionEstablisher connection) {
        super(socket, connection.getDataStore());
        this._connection = connection;
    }

    public void handleDocument(DataElement documentObject) {
        int a = 0;
        while (a < documentObject.getNestedSize()) {
            DataElement rootOutput = documentObject.get(a);
            DataElement log = this._dataStore.getLogRoot();
            log.addNestedData(rootOutput, false);
            if (rootOutput.getName().equals("C_EXIT")) {
                this.finish();
            } else {
                this._dataStore.command(rootOutput);
            }
            ++a;
        }
    }

    public void finish() {
        super.finish();
        this._connection.finished(this);
    }

    public void handleError(Throwable e) {
        System.out.println("RECEIVER ERROR");
        System.out.println(e);
        this._connection.finished(this);
    }
}

