/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dstore.core.util;

import java.util.LinkedList;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.dstore.core.model.Handler;

public class DataElementRemover
extends Handler {
    private LinkedList _queue;
    private static int numRemoved = 0;
    private static int numDisconnected = 0;
    private static int numCreated = 0;
    private static int numGCed = 0;
    public static final int DEFAULT_EXPIRY_TIME = 600;
    public static final int DEFAULT_INTERVAL_TIME = 60;
    private int _intervalTime = 60000;
    private int _expiryTime = 600000;
    public static final String EXPIRY_TIME_PROPERTY_NAME = "SPIRIT_EXPIRY_TIME";
    public static final String INTERVAL_TIME_PROPERTY_NAME = "SPIRIT_INTERVAL_TIME";

    public DataElementRemover(DataStore dataStore) {
        this._dataStore = dataStore;
        this._queue = new LinkedList();
        this.getTimes();
        this.setWaitTime(this._intervalTime);
        DataElement spiritnode = this._dataStore.createObjectDescriptor(this._dataStore.getDescriptorRoot(), "datastore.spirit");
        this._dataStore.createCommandDescriptor(spiritnode, "StartSpirit", "DataElementRemover", "C_START_SPIRIT");
        this._dataStore.refresh(this._dataStore.getDescriptorRoot());
    }

    protected void getTimes() {
        try {
            String expiryTime = System.getProperty(EXPIRY_TIME_PROPERTY_NAME);
            if (expiryTime != null && !expiryTime.equals("")) {
                this._expiryTime = Integer.parseInt(expiryTime) * 1000;
            }
        }
        catch (Exception exception) {
            System.out.println("Invalid spirit expiry time property, using default.");
            this._expiryTime = 600;
        }
        try {
            String intervalTime = System.getProperty(INTERVAL_TIME_PROPERTY_NAME);
            if (intervalTime != null && !intervalTime.equals("")) {
                this._intervalTime = Integer.parseInt(intervalTime) * 1000;
            }
        }
        catch (Exception exception) {
            System.out.println("Invalid spirit interval time property, using default.");
            this._intervalTime = 60;
        }
    }

    public static void addToRemovedCount() {
        ++numRemoved;
    }

    public static void addToCreatedCount() {
        ++numCreated;
    }

    public static void addToGCedCount() {
        ++numGCed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addToQueueForRemoval(DataElement element) {
        LinkedList linkedList = this._queue;
        synchronized (linkedList) {
            if (this._dataStore.isDoSpirit() && this._dataStore == element.getDataStore()) {
                QueueItem item = new QueueItem(element, System.currentTimeMillis());
                this._queue.add(item);
            }
        }
    }

    public void handle() {
        this.clearQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clearQueue() {
        LinkedList linkedList = this._queue;
        synchronized (linkedList) {
            this._dataStore.memLog("           ");
            int disconnected = 0;
            if (!this._dataStore.isDoSpirit()) {
                if (this._queue.size() > 0) {
                    this._dataStore.memLog("Clearing queue of size " + this._queue.size() + ". DSTORE_SPIRIT_ON not set or set to false.");
                    this._queue.clear();
                }
                this._dataStore.memLog("Total heap size: " + Runtime.getRuntime().totalMemory());
                this._dataStore.memLog("Elements created so far: " + numCreated);
                this._dataStore.memLog("Elements disconnected so far: " + numDisconnected);
                this._dataStore.memLog("Spirit elements cleaned so far: " + numRemoved);
                this._dataStore.memLog("DataElements GCed so far: " + numGCed);
                return;
            }
            this._dataStore.memLog("Total heap size before disconnection: " + Runtime.getRuntime().totalMemory());
            this._dataStore.memLog("Size of queue: " + this._queue.size());
            while (this._queue.size() > 0 && System.currentTimeMillis() - ((QueueItem)this._queue.getFirst()).timeStamp > (long)this._expiryTime) {
                DataElement toBeDisconnected = ((QueueItem)this._queue.removeFirst()).dataElement;
                if (!toBeDisconnected.isSpirit()) {
                    toBeDisconnected.setSpirit(true);
                    this._dataStore.refresh(toBeDisconnected);
                    ++disconnected;
                    ++numDisconnected;
                }
                this._dataStore.getHashMap().remove(toBeDisconnected.getId());
            }
            this._dataStore.memLog("Disconnected " + disconnected + " DataElements.");
            this._dataStore.memLog("Elements created so far: " + numCreated);
            this._dataStore.memLog("Elements disconnected so far: " + numDisconnected);
            this._dataStore.memLog("Spirit elements cleaned so far: " + numRemoved);
            this._dataStore.memLog("DataElements GCed so far: " + numGCed);
        }
    }

    public void run() {
        while (this._keepRunning) {
            try {
                Thread.sleep(this._waitIncrement);
                Thread.yield();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                this.finish();
                return;
            }
            this.handle();
        }
    }

    protected class QueueItem {
        public DataElement dataElement;
        public long timeStamp;

        public QueueItem(DataElement element, long stamp) {
            this.dataElement = element;
            this.timeStamp = stamp;
        }
    }
}

