/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.connectorservice.ssh;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.rse.connectorservice.ssh";
    private static Activator plugin;
    private static Boolean fTracingOn;

    static {
        fTracingOn = null;
    }

    public Activator() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static boolean isTracingOn() {
        if (fTracingOn == null) {
            String id = plugin.getBundle().getSymbolicName();
            String val = Platform.getDebugOption((String)(String.valueOf(id) + "/debug"));
            fTracingOn = "true".equals(val) ? Boolean.TRUE : Boolean.FALSE;
        }
        return fTracingOn;
    }

    public static String getTimestamp() {
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            return formatter.format(new Date());
        }
        catch (Exception exception) {
            return Long.toString(System.currentTimeMillis());
        }
    }

    public static void trace(String msg) {
        if (Activator.isTracingOn()) {
            String fullMsg = String.valueOf(Activator.getTimestamp()) + " | " + Thread.currentThread().getName() + " | " + msg;
            System.out.println(fullMsg);
            System.out.flush();
        }
    }
}

