/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.core.model;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.rse.core.model.IProperty;
import org.eclipse.rse.core.model.IPropertySet;
import org.eclipse.rse.core.model.IPropertyType;
import org.eclipse.rse.core.model.Property;
import org.eclipse.rse.core.model.PropertyType;

public class PropertySet
implements IPropertySet {
    private String _name;
    private Map _properties;
    protected static IPropertyType _defaultType = PropertyType.getStringPropertyType();

    public PropertySet(IPropertySet propertySet) {
        this._name = propertySet.getName();
        this._properties = new HashMap();
        String[] keys = propertySet.getPropertyKeys();
        int i = 0;
        while (i < keys.length) {
            String key = keys[i];
            IProperty property = propertySet.getProperty(key);
            this.addProperty(key, new Property(property));
            ++i;
        }
    }

    public PropertySet(String name) {
        this._name = name;
        this._properties = new HashMap();
    }

    public String getName() {
        return this._name;
    }

    public String getDescription() {
        return this.getPropertyValue("description");
    }

    public String[] getPropertyKeys() {
        Set set = this._properties.keySet();
        return set.toArray(new String[set.size()]);
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setProperties(Map map) {
        this._properties = map;
    }

    public IProperty addProperty(String key, IProperty property) {
        this._properties.put(key, property);
        return property;
    }

    public IProperty addProperty(String key, String value) {
        IProperty property = this.getProperty(key);
        if (property != null) {
            property.setValue(value);
            return property;
        }
        return this.addProperty(key, value, _defaultType);
    }

    public IProperty addProperty(String key, String value, IPropertyType type) {
        Property property = new Property(key, value, type, true);
        return this.addProperty(key, property);
    }

    public boolean removeProperty(String key) {
        return this._properties.remove(key) != null;
    }

    public IProperty getProperty(String key) {
        return (IProperty)this._properties.get(key);
    }

    public String getPropertyValue(String key) {
        IProperty property = this.getProperty(key);
        if (property != null) {
            return property.getValue();
        }
        return null;
    }

    public IPropertyType getPropertyType(String key) {
        IProperty property = this.getProperty(key);
        if (property != null) {
            return property.getType();
        }
        return null;
    }
}

