/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.persistence;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.rse.internal.persistence.RSEPersistenceManager;
import org.eclipse.rse.persistence.IRSEPersistenceProvider;
import org.eclipse.rse.persistence.dom.RSEDOM;
import org.eclipse.rse.persistence.dom.RSEDOMNode;
import org.eclipse.rse.persistence.dom.RSEDOMNodeAttribute;

public class PropertyFileProvider
implements IRSEPersistenceProvider {
    private static final String NULL_VALUE_STRING = "null";
    private static final String PROPERTIES_FILE_NAME = "node.properties";
    private static final String[] MT_ATTRIBUTE_TYPE = new String[]{"04-attr-type", "attr-type"};
    private static final String[] MT_ATTRIBUTE = new String[]{"03-attr", "attr"};
    private static final String[] MT_CHILD = new String[]{"06-child", "child"};
    private static final String[] MT_NODE_TYPE = new String[]{"01-type", "01-node-type", "n-type"};
    private static final String[] MT_NODE_NAME = new String[]{"00-name", "00-node-name", "n-name"};
    private static final String[] MT_REFERENCE = new String[]{"05-ref", "ref"};
    private static final String AB_SUBSYSTEM = "SS";
    private static final String AB_SERVICE_LAUNCHER = "SL";
    private static final String AB_PROPERTY_SET = "PS";
    private static final String AB_PROPERTY = "P";
    private static final String AB_HOST = "H";
    private static final String AB_FILTER_STRING = "FS";
    private static final String AB_FILTER_POOL_REFERENCE = "FPR";
    private static final String AB_FILTER_POOL = "FP";
    private static final String AB_FILTER = "F";
    private static final String AB_CONNECTOR_SERVICE = "CS";
    private static final String AB_PROFILE = "PRF";
    private Pattern period = Pattern.compile("\\.");
    private Map typeQualifiers = this.getTypeQualifiers();
    private static final String VALID = "abcdefghijklmnopqrstuvwxyz0123456789-._";
    private static final String UPPER = "ABCDEFGHIJKLMNOPQRTSUVWXYZ";

    public String[] getSavedProfileNames() {
        Vector<String> names = new Vector<String>(10);
        IFolder providerFolder = this.getProviderFolder();
        try {
            IResource[] profileCandidates = providerFolder.members();
            int i = 0;
            while (i < profileCandidates.length) {
                String candidateName;
                String[] parts;
                IResource profileCandidate = profileCandidates[i];
                if (profileCandidate.getType() == 2 && (parts = this.split(candidateName = profileCandidate.getName(), 2))[0].equals(AB_PROFILE)) {
                    String name = this.thaw(parts[1]);
                    names.add(name);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        String[] result = new String[names.size()];
        names.toArray(result);
        return result;
    }

    public boolean saveRSEDOM(RSEDOM dom, IProgressMonitor monitor) {
        IFolder providerFolder = this.getProviderFolder();
        try {
            int n = this.countNodes(dom);
            if (monitor != null) {
                monitor.beginTask("Saving DOM", n);
            }
            this.saveNode(dom, providerFolder, monitor);
            if (monitor != null) {
                monitor.done();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public IStatus deleteProfile(String profileName, IProgressMonitor monitor) {
        IStatus result = Status.OK_STATUS;
        IFolder profileFolder = this.getProfileFolder(profileName);
        if (profileFolder.exists()) {
            try {
                profileFolder.delete(1, monitor);
            }
            catch (CoreException e) {
                result = new Status(4, null, 0, "Unexpected Exception", (Throwable)e);
            }
        }
        return result;
    }

    private String saveNode(RSEDOMNode node, IFolder parentFolder, IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            return null;
        }
        String nodeFolderName = this.getSaveFolderName(node);
        IFolder nodeFolder = this.getFolder((IContainer)parentFolder, nodeFolderName);
        Properties properties = this.getProperties(node, false, monitor);
        RSEDOMNode[] children = node.getChildren();
        HashSet<String> childFolderNames = new HashSet<String>();
        int i = 0;
        while (i < children.length) {
            RSEDOMNode child = children[i];
            String index = this.getIndexString(i);
            if (!this.isNodeEmbedded(child)) {
                String key = this.combine(MT_REFERENCE[0], index);
                String childFolderName = this.saveNode(child, nodeFolder, monitor);
                if (childFolderName != null) {
                    properties.put(key, childFolderName);
                }
                childFolderNames.add(childFolderName);
            }
            ++i;
        }
        this.removeFolders(nodeFolder, childFolderNames);
        String propertiesFileName = PROPERTIES_FILE_NAME;
        IFile propertiesFile = nodeFolder.getFile(propertiesFileName);
        this.writeProperties(properties, "RSE DOM Node", propertiesFile);
        return nodeFolderName;
    }

    private void removeFolders(IFolder parentFolder, Set keepSet) {
        try {
            IResource[] children = parentFolder.members();
            int i = 0;
            while (i < children.length) {
                String childFolderName;
                IResource child = children[i];
                if (child.getType() == 2 && !keepSet.contains(childFolderName = child.getName())) {
                    child.delete(true, null);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private String getSaveFolderName(RSEDOMNode node) {
        String type = node.getType();
        type = (String)this.typeQualifiers.get(type);
        String name = node.getName();
        name = this.freeze(name);
        String result = this.combine(type, name);
        return result;
    }

    private String freeze(String name) {
        int p = name.indexOf(58);
        if (p >= 0) {
            name = name.substring(p + 1);
        }
        StringBuffer buf = new StringBuffer(name.length());
        char[] chars = name.toCharArray();
        long suffix = 0L;
        int i = 0;
        while (i < chars.length) {
            char c = chars[i];
            suffix *= 2L;
            if (VALID.indexOf(c) >= 0) {
                buf.append(c);
            } else if (UPPER.indexOf(c) >= 0) {
                buf.append(Character.toLowerCase(c));
                ++suffix;
            } else if (c == ' ') {
                buf.append('_');
                ++suffix;
            } else {
                buf.append('#');
                buf.append(Integer.toHexString(c));
                buf.append('#');
            }
            ++i;
        }
        name = String.valueOf(buf.toString()) + "_" + Long.toString(suffix);
        return name;
    }

    private String thaw(String name) {
        String result = name;
        Pattern suffixPattern = Pattern.compile("_(\\d+)$");
        Matcher m = suffixPattern.matcher(name);
        if (m.find()) {
            String root = name.substring(0, m.start());
            String suffix = m.group(1);
            long caseCode = Long.parseLong(suffix);
            root = this.thawUnicode(root);
            result = root = this.thawCase(root, caseCode);
        }
        return result;
    }

    private String thawUnicode(String name) {
        Pattern unicodePattern = Pattern.compile("#(\\p{XDigit}+)#");
        Matcher m = unicodePattern.matcher(name);
        StringBuffer b = new StringBuffer();
        int p0 = 0;
        while (m.find()) {
            int p1 = m.start();
            String chunk0 = name.substring(p0, p1);
            String digits = m.group(1);
            int codePoint = Integer.valueOf(digits, 16);
            char ch = (char)codePoint;
            String chunk1 = Character.toString(ch);
            b.append(chunk0);
            b.append(chunk1);
            p0 = m.end();
        }
        b.append(name.substring(p0));
        String result = b.toString();
        return result;
    }

    private String thawCase(String name, long caseCode) {
        StringBuffer b = new StringBuffer();
        char[] chars = name.toCharArray();
        int i = chars.length - 1;
        while (i >= 0) {
            boolean shift;
            int ch = chars[i];
            boolean bl = shift = (caseCode & 1L) == 1L;
            if (shift) {
                ch = ch == 95 ? 32 : (int)Character.toUpperCase((char)ch);
            }
            b.append((char)ch);
            caseCode >>= 1;
            --i;
        }
        String result = b.reverse().toString();
        return result;
    }

    private Map getTypeQualifiers() {
        HashMap<String, String> typeQualifiers = new HashMap<String, String>();
        typeQualifiers.put("ConnectorService", AB_CONNECTOR_SERVICE);
        typeQualifiers.put("Filter", AB_FILTER);
        typeQualifiers.put("FilterPool", AB_FILTER_POOL);
        typeQualifiers.put("FilterPoolReference", AB_FILTER_POOL_REFERENCE);
        typeQualifiers.put("FilterString", AB_FILTER_STRING);
        typeQualifiers.put("Host", AB_HOST);
        typeQualifiers.put("Profile", AB_PROFILE);
        typeQualifiers.put("Property", AB_PROPERTY);
        typeQualifiers.put("PropertySet", AB_PROPERTY_SET);
        typeQualifiers.put("ServerLauncher", AB_SERVICE_LAUNCHER);
        typeQualifiers.put("SubSystem", AB_SUBSYSTEM);
        return typeQualifiers;
    }

    private void writeProperties(Properties properties, String header, IFile file) {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream(500);
        PrintWriter out = new PrintWriter(outStream);
        out.println("# " + header);
        TreeMap<Object, Object> map = new TreeMap<Object, Object>(properties);
        Set keys = map.keySet();
        Iterator z = keys.iterator();
        while (z.hasNext()) {
            String key = (String)z.next();
            String value = (String)map.get(key);
            String keyvalue = String.valueOf(key) + "=" + this.escapeValue(value);
            out.println(keyvalue);
        }
        out.close();
        ByteArrayInputStream inStream = new ByteArrayInputStream(outStream.toByteArray());
        try {
            if (!file.exists()) {
                file.create((InputStream)inStream, true, null);
            } else {
                file.setContents((InputStream)inStream, true, true, null);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private boolean isNodeEmbedded(RSEDOMNode node) {
        HashSet<String> embeddedTypes = new HashSet<String>();
        embeddedTypes.add("Filter");
        embeddedTypes.add("ConnectorService");
        boolean result = embeddedTypes.contains(node.getType());
        return result;
    }

    private String getIndexString(int i) {
        if (i < 0 || i > 99999) {
            throw new IllegalArgumentException("Argument must be between 0 and 99999");
        }
        String index = "00000" + Integer.toString(i);
        index = index.substring(index.length() - 5);
        return index;
    }

    private String fixValue(String value) {
        if (value == null) {
            return NULL_VALUE_STRING;
        }
        return value;
    }

    private String escapeValue(String value) {
        StringBuffer buffer = new StringBuffer(value.length() + 20);
        char[] characters = value.toCharArray();
        int i = 0;
        while (i < characters.length) {
            char c = characters[i];
            if (c == '\\') {
                buffer.append("\\\\");
            } else if (c == '\t') {
                buffer.append("\\t");
            } else if (c == '\f') {
                buffer.append("\\f");
            } else if (c == '\n') {
                buffer.append("\\n");
            } else if (c == '\r') {
                buffer.append("\\r");
            } else if (c < ' ' && c > '~') {
                String cString = "0000" + Integer.toHexString(c);
                cString = cString.substring(cString.length() - 4);
                cString = "\\u" + cString;
                buffer.append(cString);
            } else if ("=!#:".indexOf(c) >= 0) {
                buffer.append('\\');
                buffer.append(c);
            } else {
                buffer.append(c);
            }
            ++i;
        }
        return buffer.toString();
    }

    private Properties getProperties(RSEDOMNode node, boolean force, IProgressMonitor monitor) {
        Properties properties = new Properties();
        properties.put(MT_NODE_NAME[0], node.getName());
        properties.put(MT_NODE_TYPE[0], node.getType());
        properties.putAll((Map<?, ?>)this.getAttributes(node));
        RSEDOMNode[] children = node.getChildren();
        int i = 0;
        while (i < children.length) {
            RSEDOMNode child = children[i];
            String index = this.getIndexString(i);
            if (force || this.isNodeEmbedded(child)) {
                String prefix = this.combine(MT_CHILD[0], index);
                Properties childProperties = this.getProperties(child, true, monitor);
                Enumeration<Object> e = childProperties.keys();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    String value = childProperties.getProperty(key);
                    String newKey = this.combine(prefix, key);
                    properties.put(newKey, value);
                }
            }
            ++i;
        }
        if (monitor != null) {
            monitor.worked(1);
        }
        return properties;
    }

    private Properties getAttributes(RSEDOMNode node) {
        Properties properties = new Properties();
        RSEDOMNodeAttribute[] attributes = node.getAttributes();
        int i = 0;
        while (i < attributes.length) {
            RSEDOMNodeAttribute attribute = attributes[i];
            String attributeName = attribute.getKey();
            String propertyKey = this.combine(MT_ATTRIBUTE[0], attributeName);
            properties.put(propertyKey, this.fixValue(attribute.getValue()));
            String attributeType = attribute.getType();
            if (attributeType != null) {
                propertyKey = this.combine(MT_ATTRIBUTE_TYPE[0], attributeName);
                properties.put(propertyKey, attributeType);
            }
            ++i;
        }
        return properties;
    }

    private int countNodes(RSEDOMNode node) {
        RSEDOMNode[] children = node.getChildren();
        int result = 1;
        int i = 0;
        while (i < children.length) {
            RSEDOMNode child = children[i];
            result += this.countNodes(child);
            ++i;
        }
        return result;
    }

    public RSEDOM loadRSEDOM(String profileName, IProgressMonitor monitor) {
        RSEDOM dom = null;
        IFolder profileFolder = this.getProfileFolder(profileName);
        if (profileFolder.exists()) {
            int n = this.countPropertiesFiles(profileFolder);
            if (monitor != null) {
                monitor.beginTask("Loading DOM", n);
            }
            dom = (RSEDOM)this.loadNode(null, profileFolder, monitor);
            if (monitor != null) {
                monitor.done();
            }
        }
        return dom;
    }

    private int countPropertiesFiles(IFolder folder) {
        int result = 0;
        IFile propertiesFile = folder.getFile(PROPERTIES_FILE_NAME);
        if (propertiesFile.exists()) {
            ++result;
            try {
                IResource[] members = folder.members();
                int i = 0;
                while (i < members.length) {
                    IResource member = members[i];
                    if (member.getType() == 2) {
                        IFolder childFolder = (IFolder)member;
                        result += this.countPropertiesFiles(childFolder);
                    }
                    ++i;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private RSEDOMNode loadNode(RSEDOMNode parent, IFolder nodeFolder, IProgressMonitor monitor) {
        RSEDOMNode node = null;
        if (monitor == null || !monitor.isCanceled()) {
            Properties properties = this.loadProperties(nodeFolder);
            if (properties != null) {
                node = this.makeNode(parent, nodeFolder, properties, monitor);
            }
            if (monitor != null) {
                monitor.worked(1);
            }
        }
        return node;
    }

    private Properties loadProperties(IFolder folder) {
        Properties properties = null;
        IFile attributeFile = folder.getFile(PROPERTIES_FILE_NAME);
        if (attributeFile.exists()) {
            properties = new Properties();
            try {
                InputStream inStream = attributeFile.getContents();
                try {
                    properties.load(inStream);
                    inStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return properties;
    }

    private RSEDOMNode makeNode(RSEDOMNode parent, IFolder nodeFolder, Properties properties, IProgressMonitor monitor) {
        String nodeType = this.getProperty(properties, MT_NODE_TYPE);
        String nodeName = this.getProperty(properties, MT_NODE_NAME);
        RSEDOMNode node = parent == null ? new RSEDOM(nodeName) : new RSEDOMNode(parent, nodeType, nodeName);
        node.setRestoring(true);
        Set<Object> keys = properties.keySet();
        HashMap<String, String> attributes = new HashMap<String, String>();
        HashMap<String, String> attributeTypes = new HashMap<String, String>();
        HashMap childPropertiesMap = new HashMap();
        TreeSet<String> childNames = new TreeSet<String>();
        TreeSet<String> referenceKeys = new TreeSet<String>();
        Iterator<Object> z = keys.iterator();
        while (z.hasNext()) {
            String value;
            String key = (String)z.next();
            String[] words = this.split(key, 2);
            String metatype = words[0];
            if (this.find(metatype, MT_ATTRIBUTE)) {
                value = properties.getProperty(key);
                attributes.put(words[1], value);
                continue;
            }
            if (this.find(metatype, MT_ATTRIBUTE_TYPE)) {
                String type = properties.getProperty(key);
                attributeTypes.put(words[1], type);
                continue;
            }
            if (this.find(metatype, MT_REFERENCE)) {
                referenceKeys.add(key);
                continue;
            }
            if (!this.find(metatype, MT_CHILD)) continue;
            value = properties.getProperty(key);
            words = this.split(words[1], 2);
            String childName = words[0];
            childNames.add(childName);
            String newKey = words[1];
            Properties p = this.getProperties(childPropertiesMap, childName);
            p.put(newKey, value);
        }
        Set attributeNames = attributes.keySet();
        Iterator<Object> z2 = attributeNames.iterator();
        while (z2.hasNext()) {
            String attributeName = (String)z2.next();
            String attributeValue = (String)attributes.get(attributeName);
            if (attributeValue.equals(NULL_VALUE_STRING)) {
                attributeValue = null;
            }
            String attributeType = (String)attributeTypes.get(attributeName);
            node.addAttribute(attributeName, attributeValue, attributeType);
        }
        z2 = childNames.iterator();
        while (z2.hasNext()) {
            String childName = (String)z2.next();
            Properties p = this.getProperties(childPropertiesMap, childName);
            this.makeNode(node, nodeFolder, p, monitor);
        }
        z2 = referenceKeys.iterator();
        while (z2.hasNext()) {
            String key = (String)z2.next();
            String childFolderName = properties.getProperty(key);
            IFolder childFolder = this.getFolder((IContainer)nodeFolder, childFolderName);
            this.loadNode(node, childFolder, monitor);
        }
        node.setRestoring(false);
        return node;
    }

    private String getProperty(Properties properties, String[] keys) {
        String result = null;
        int i = 0;
        while (i < keys.length && result == null) {
            String key = keys[i];
            result = properties.getProperty(key);
            ++i;
        }
        return result;
    }

    private boolean find(String needle, String[] haystack) {
        int i = 0;
        while (i < haystack.length) {
            String value = haystack[i];
            if (value.equals(needle)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private Properties getProperties(Map propertiesMap, String selector) {
        Properties p = (Properties)propertiesMap.get(selector);
        if (p == null) {
            p = new Properties();
            propertiesMap.put(selector, p);
        }
        return p;
    }

    private IFolder getProviderFolder() {
        IProject project = RSEPersistenceManager.getRemoteSystemsProject();
        try {
            project.refreshLocal(2, null);
        }
        catch (Exception exception) {}
        IFolder providerFolder = this.getFolder((IContainer)project, "dom.properties");
        return providerFolder;
    }

    private IFolder getProfileFolder(String profileName) {
        String profileFolderName = this.combine(AB_PROFILE, this.freeze(profileName));
        IFolder providerFolder = this.getProviderFolder();
        IFolder profileFolder = this.getFolder((IContainer)providerFolder, profileFolderName);
        return profileFolder;
    }

    private IFolder getFolder(IContainer parent, String name) {
        Path path = new Path(name);
        IFolder folder = parent.getFolder((IPath)path);
        if (!folder.exists()) {
            try {
                folder.create(0, true, null);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return folder;
    }

    private String combine(String typeName, String nodeName) {
        return this.combine(new String[]{typeName, nodeName});
    }

    private String combine(String[] names) {
        StringBuffer buf = new StringBuffer(100);
        int i = 0;
        while (i < names.length) {
            String name = names[i];
            if (i > 0) {
                buf.append('.');
            }
            buf.append(name);
            ++i;
        }
        return buf.toString();
    }

    private String[] split(String longName, int limit) {
        return this.period.split(longName, limit);
    }
}

