/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.persistence;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.filters.ISystemFilter;
import org.eclipse.rse.core.filters.ISystemFilterPool;
import org.eclipse.rse.core.filters.ISystemFilterPoolManager;
import org.eclipse.rse.core.filters.ISystemFilterPoolManagerProvider;
import org.eclipse.rse.core.filters.SystemFilterPoolManager;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemHostPool;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.core.model.ISystemProfileManager;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.internal.persistence.SaveRSEDOMJob;
import org.eclipse.rse.internal.persistence.dom.RSEDOMExporter;
import org.eclipse.rse.internal.persistence.dom.RSEDOMImporter;
import org.eclipse.rse.logging.Logger;
import org.eclipse.rse.persistence.IRSEPersistenceManager;
import org.eclipse.rse.persistence.IRSEPersistenceProvider;
import org.eclipse.rse.persistence.dom.RSEDOM;

public class RSEPersistenceManager
implements IRSEPersistenceManager {
    private static final int STATE_NONE = 0;
    private static final int STATE_IMPORTING = 1;
    private static final int STATE_EXPORTING = 2;
    private Map loadedProviders = new HashMap(10);
    private int _currentState = 0;
    private RSEDOMExporter _exporter;
    private RSEDOMImporter _importer;
    private static IProject remoteSystemsProject = null;
    public static final String RESOURCE_PROJECT_NAME = "RemoteSystemsConnections";
    private ISystemRegistry _registry;
    private ISystemProfileManager _profileManager;

    public RSEPersistenceManager(ISystemRegistry registry) {
        this._registry = registry;
        this._profileManager = registry.getSystemProfileManager();
        this._exporter = RSEDOMExporter.getInstance();
        this._exporter.setSystemRegistry(registry);
        this._importer = RSEDOMImporter.getInstance();
        this._importer.setSystemRegistry(registry);
    }

    public static IProject getRemoteSystemsProject() {
        if (remoteSystemsProject == null) {
            remoteSystemsProject = ResourcesPlugin.getWorkspace().getRoot().getProject(RESOURCE_PROJECT_NAME);
        }
        return remoteSystemsProject;
    }

    public void registerRSEPersistenceProvider(String id, IRSEPersistenceProvider provider) {
        this.loadedProviders.put(id, provider);
    }

    public IRSEPersistenceProvider getRSEPersistenceProvider(String id) {
        Logger logger = RSECorePlugin.getDefault().getLogger();
        IRSEPersistenceProvider provider = (IRSEPersistenceProvider)this.loadedProviders.get(id);
        if (provider == null) {
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IConfigurationElement[] providerCandidates = registry.getConfigurationElementsFor("org.eclipse.rse.core", "persistenceProviders");
            int j = 0;
            while (j < providerCandidates.length) {
                IConfigurationElement providerCandidate = providerCandidates[j];
                if (providerCandidate.getName().equals("persistenceProvider")) {
                    String candidateId = providerCandidate.getAttribute("id");
                    if (candidateId != null) {
                        if (candidateId.equals(id)) {
                            try {
                                provider = (IRSEPersistenceProvider)providerCandidate.createExecutableExtension("class");
                            }
                            catch (CoreException e) {
                                logger.logError("Exception loading persistence provider", (Throwable)e);
                            }
                        }
                    } else {
                        logger.logError("Missing id attribute in persistenceProvider element", null);
                    }
                } else {
                    logger.logError("Invalid element in persistenceProviders extension point", null);
                }
                ++j;
            }
            if (provider == null) {
                logger.logError("Persistence provider not found.", null);
            }
            this.loadedProviders.put(id, provider);
        }
        return provider;
    }

    public IRSEPersistenceProvider getRSEPersistenceProvider() {
        IRSEPersistenceProvider provider = this.getRSEPersistenceProvider("org.eclipse.rse.persistence.PropertyFileProvider");
        return provider;
    }

    public boolean restore(ISystemProfileManager profileManager) {
        return this.load(profileManager);
    }

    protected ISystemProfile restoreProfile(ISystemProfileManager mgr, String name) throws Exception {
        return null;
    }

    public boolean commit(ISystemProfileManager profileManager) {
        ISystemProfile[] profiles = profileManager.getSystemProfiles();
        int idx = 0;
        while (idx < profiles.length) {
            try {
                this.commit(profiles[idx]);
            }
            catch (Exception exc) {
                exc.printStackTrace();
                System.out.println("Error saving profile " + profiles[idx] + ": " + exc.getClass().getName() + " " + exc.getMessage());
                return false;
            }
            ++idx;
        }
        return true;
    }

    public boolean restore(ISystemHostPool connectionPool) {
        return false;
    }

    protected IHost restoreHost(ISystemHostPool hostPool, String connectionName) throws Exception {
        return null;
    }

    public boolean commit(ISystemHostPool connectionPool) {
        if (connectionPool.isDirty()) {
            this.commit(connectionPool.getSystemProfile());
            connectionPool.setDirty(false);
        }
        return false;
    }

    public boolean commit(ISystemFilterPoolManager filterPoolManager) {
        if (filterPoolManager.isDirty()) {
            this.commit(filterPoolManager.getSystemProfile());
            filterPoolManager.setDirty(false);
        }
        return false;
    }

    public boolean commit(ISystemFilterPool filterPool) {
        if (filterPool.isDirty()) {
            this.commit(filterPool.getSystemFilterPoolManager().getSystemProfile());
            filterPool.setDirty(false);
        }
        return false;
    }

    public boolean restore(ISystemFilterPool filterPool) {
        return false;
    }

    public boolean commit(ISystemFilter filter) {
        return false;
    }

    public ISystemFilterPool restoreFilterPool(String name) {
        return null;
    }

    public boolean commit(ISubSystem subSystem) {
        if (subSystem.isDirty()) {
            try {
                this.commit(this._profileManager);
                subSystem.setDirty(false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return true;
        }
        return false;
    }

    public ISystemFilterPoolManager restoreFilterPoolManager(ISystemProfile profile, Logger logger, ISystemFilterPoolManagerProvider caller, String name) {
        SystemFilterPoolManager mgr = SystemFilterPoolManager.createManager(profile);
        mgr.initialize(logger, caller, name);
        mgr.setWasRestored(false);
        return mgr;
    }

    public boolean commit(ISystemProfile profile) {
        if (profile != null) {
            return this.save(profile, false);
        }
        return false;
    }

    public boolean commit(IHost host) {
        return this.commit(host.getSystemProfile());
    }

    private boolean load(ISystemProfileManager profileManager) {
        boolean successful = true;
        if (this.isExporting() || this.isImporting()) {
            successful = false;
        } else {
            this._currentState = 1;
            IProject project = RSEPersistenceManager.getRemoteSystemsProject();
            try {
                if (!project.isSynchronized(1)) {
                    project.refreshLocal(1, null);
                }
                IRSEPersistenceProvider persistenceProvider = this.getRSEPersistenceProvider();
                String[] profileNames = persistenceProvider.getSavedProfileNames();
                int i = 0;
                while (i < profileNames.length) {
                    String profileName = profileNames[i];
                    RSEDOM dom = this.importRSEDOM(profileName);
                    if (dom != null) {
                        ISystemProfile restoredProfile = this._importer.restoreProfile(profileManager, dom);
                        if (restoredProfile == null) {
                            successful = false;
                        }
                    } else {
                        successful = false;
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this._currentState = 0;
        }
        return successful;
    }

    private boolean save(ISystemProfile profile, boolean force) {
        boolean result = false;
        if (!this.isImporting()) {
            this._currentState = 2;
            RSEDOM dom = this.exportRSEDOM(profile, true);
            this._currentState = 0;
            result = true;
            if (dom.needsSave()) {
                Object job = dom.getSaveJob();
                if (job == null) {
                    job = new SaveRSEDOMJob(dom, this.getRSEPersistenceProvider());
                    dom.setSaveJob((Job)job);
                }
                job.schedule(3000L);
            }
        }
        return result;
    }

    public void deleteProfile(final String profileName) {
        Job job = new Job("delete profile"){

            protected IStatus run(IProgressMonitor monitor) {
                IRSEPersistenceProvider provider = RSEPersistenceManager.this.getRSEPersistenceProvider();
                IStatus result = provider.deleteProfile(profileName, monitor);
                return result;
            }
        };
        job.schedule();
    }

    public boolean isExporting() {
        return this._currentState == 2;
    }

    public boolean isImporting() {
        return this._currentState == 1;
    }

    private RSEDOM exportRSEDOM(ISystemProfile profile, boolean force) {
        RSEDOM dom = this._exporter.createRSEDOM(profile, force);
        return dom;
    }

    private RSEDOM importRSEDOM(String domName) {
        RSEDOM dom = null;
        IRSEPersistenceProvider provider = this.getRSEPersistenceProvider();
        if (provider != null) {
            dom = provider.loadRSEDOM(domName, null);
        } else {
            Logger logger = RSECorePlugin.getDefault().getLogger();
            logger.logError("Persistence provider is not available.", null);
        }
        return dom;
    }
}

