/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.dstore.security.wizards;

import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.List;
import org.eclipse.dstore.core.util.ssl.DStoreKeyStore;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.rse.dstore.security.UniversalSecurityPlugin;
import org.eclipse.rse.dstore.security.UniversalSecurityProperties;
import org.eclipse.rse.dstore.security.preference.X509CertificateElement;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.messages.ISystemMessageLine;
import org.eclipse.rse.ui.validators.ISystemValidator;
import org.eclipse.rse.ui.wizards.AbstractSystemWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SystemImportCertWizardAliasPage
extends AbstractSystemWizardPage {
    protected SystemMessage errorMessage;
    protected ISystemValidator nameValidator;
    protected ISystemMessageLine msgLine;
    private String _systemName;
    private Text _alias;

    public SystemImportCertWizardAliasPage(Wizard wizard, List certs, String systemName) {
        super((IWizard)wizard, "SpecifyAlias", UniversalSecurityProperties.RESID_SECURITY_TRUST_WIZ_ALIAS_TITLE, UniversalSecurityProperties.RESID_SECURITY_TRUST_WIZ_ALIAS_DESC);
        this._systemName = systemName;
    }

    public Control createContents(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        GridData data = new GridData(1808);
        layout.numColumns = 3;
        content.setLayout((Layout)layout);
        content.setLayoutData((Object)data);
        SystemWidgetHelpers.createLabel((Composite)content, (String)UniversalSecurityProperties.RESID_SECURITY_CERTIFICATE_ALIAS);
        this._alias = SystemWidgetHelpers.createTextField((Composite)content, null);
        this._alias.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SystemImportCertWizardAliasPage.this.validateNameInput();
            }
        });
        this.initializeInput();
        return this._alias;
    }

    public X509CertificateElement getElement(Object cert) {
        if (cert instanceof X509Certificate) {
            return new X509CertificateElement(null, UniversalSecurityProperties.RESID_SECURITY_TRUSTED_CERTIFICATE, (X509Certificate)cert);
        }
        return null;
    }

    protected Control getInitialFocusControl() {
        return this._alias;
    }

    protected void initializeInput() {
        this._alias.setText(this.getAlias());
    }

    protected SystemMessage validateNameInput() {
        this.errorMessage = null;
        this.clearErrorMessage();
        if (this.nameValidator != null) {
            this.errorMessage = this.nameValidator.validate(this._alias.getText());
        }
        if (this.errorMessage != null) {
            this.setErrorMessage(this.errorMessage);
        }
        this.setPageComplete(this.errorMessage == null);
        return this.errorMessage;
    }

    public boolean performFinish() {
        return true;
    }

    public String getAlias() {
        String alias = this._alias.getText().trim();
        if (alias.equals("")) {
            try {
                int count = 0;
                String storePath = UniversalSecurityPlugin.getKeyStoreLocation();
                String passw = UniversalSecurityPlugin.getKeyStorePassword();
                KeyStore keyStore = DStoreKeyStore.getKeyStore((String)storePath, (String)passw);
                Enumeration<String> aliases = keyStore.aliases();
                while (aliases.hasMoreElements()) {
                    String existingalias = aliases.nextElement();
                    if (!existingalias.toLowerCase().startsWith(this._systemName.toLowerCase())) continue;
                    ++count;
                }
                alias = String.valueOf(this._systemName) + ++count;
            }
            catch (Exception exception) {
                alias = this._systemName;
            }
        }
        return alias;
    }

    public boolean isPageComplete() {
        return this.errorMessage == null;
    }
}

