/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.eclipse.filesystem.ui.actions;

import java.net.URI;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.rse.core.SystemBasePlugin;
import org.eclipse.rse.eclipse.filesystem.RSEFileSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class CreateRemoteProjectActionDelegate
implements IActionDelegate {
    protected IStructuredSelection fSelection;

    public void run(IAction action) {
        IRemoteFile directory = (IRemoteFile)this.fSelection.getFirstElement();
        this.createRemoteProject(directory, (IProgressMonitor)new NullProgressMonitor());
    }

    private IProject createRemoteProject(IRemoteFile directory, IProgressMonitor monitor) {
        IWorkspaceRoot root = SystemBasePlugin.getWorkspaceRoot();
        IProject editProject = root.getProject(directory.getName());
        if (editProject != null && editProject.exists() && editProject.isOpen()) {
            return editProject;
        }
        try {
            IProjectDescription description = root.getWorkspace().newProjectDescription(directory.getName());
            URI location = RSEFileSystem.getInstance().getURIFor(directory);
            description.setLocationURI(location);
            editProject.create(description, monitor);
            editProject.open(monitor);
            editProject.refreshLocal(2, monitor);
        }
        catch (CoreException e) {
            e.printStackTrace();
            SystemBasePlugin.logError((String)"Error creating temp project", (Throwable)e);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return editProject;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fSelection = selection instanceof IStructuredSelection ? (IStructuredSelection)selection : StructuredSelection.EMPTY;
    }

    protected IRemoteFile getRemoteFile(IStructuredSelection selection) {
        return (IRemoteFile)selection.getFirstElement();
    }

    protected IRemoteFile[] getRemoteFiles(IStructuredSelection selection) {
        IRemoteFile[] files = new IRemoteFile[selection.size()];
        Iterator iter = selection.iterator();
        int i = 0;
        while (iter.hasNext()) {
            files[i++] = (IRemoteFile)iter.next();
        }
        return files;
    }

    protected IFile getDescriptionFile(IStructuredSelection selection) {
        return (IFile)selection.getFirstElement();
    }

    protected IFile[] getDescriptionFiles(IStructuredSelection selection) {
        IFile[] files = new IFile[selection.size()];
        Iterator iter = selection.iterator();
        int i = 0;
        while (iter.hasNext()) {
            files[i++] = (IFile)iter.next();
        }
        return files;
    }

    protected IWorkbench getWorkbench() {
        return PlatformUI.getWorkbench();
    }

    protected Shell getShell() {
        return Display.getDefault().getActiveShell();
    }

    protected IStructuredSelection getSelection() {
        return this.fSelection;
    }
}

