/*
 * Decompiled with CFR 0.152.
 */
package samples.ui.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.files.ui.actions.SystemAbstractRemoteFilePopupMenuExtensionAction;
import org.eclipse.rse.internal.subsystems.shells.subsystems.RemoteError;
import org.eclipse.rse.internal.subsystems.shells.subsystems.RemoteOutput;
import org.eclipse.rse.services.shells.IHostOutput;
import org.eclipse.rse.services.shells.IHostShell;
import org.eclipse.rse.services.shells.IHostShellChangeEvent;
import org.eclipse.rse.services.shells.IHostShellOutputListener;
import org.eclipse.rse.services.shells.IShellService;
import org.eclipse.rse.shells.ui.RemoteCommandHelpers;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteCmdSubSystem;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteCommandShell;
import org.eclipse.rse.subsystems.shells.core.subsystems.servicesubsystem.IShellServiceSubSystem;
import org.eclipse.swt.widgets.Shell;

public class ShowJarContents
extends SystemAbstractRemoteFilePopupMenuExtensionAction {
    public void run() {
        IRemoteFile selectedFile = this.getFirstSelectedRemoteFile();
        String cmdToRun = "jar -tvf " + selectedFile.getAbsolutePath();
        try {
            this.runCommand(cmdToRun);
        }
        catch (Exception e) {
            String excType = e.getClass().getName();
            MessageDialog.openError((Shell)this.getShell(), (String)excType, (String)(String.valueOf(excType) + ": " + e.getLocalizedMessage()));
            e.printStackTrace();
        }
    }

    public IRemoteCmdSubSystem getRemoteCmdSubSystem() {
        IHost myHost = this.getSubSystem().getHost();
        IRemoteCmdSubSystem[] subsys = RemoteCommandHelpers.getCmdSubSystems((IHost)myHost);
        int i = 0;
        while (i < subsys.length) {
            if (subsys[i].getSubSystemConfiguration().supportsCommands()) {
                return subsys[i];
            }
            ++i;
        }
        return null;
    }

    public void runCommand(String command) throws Exception {
        IRemoteCmdSubSystem cmdss = this.getRemoteCmdSubSystem();
        if (cmdss != null && cmdss.isConnected()) {
            RemoteCommandHelpers.runUniversalCommand((Shell)this.getShell(), (String)command, (String)".", (IRemoteCmdSubSystem)cmdss);
        } else {
            MessageDialog.openError((Shell)this.getShell(), (String)"No command subsystem", (String)"Found no command subsystem");
        }
    }

    public void runCommandInvisiblyService(IRemoteCmdSubSystem cmdss, String command) throws Exception {
        if (cmdss instanceof IShellServiceSubSystem) {
            IShellService shellService = ((IShellServiceSubSystem)cmdss).getShellService();
            String[] environment = new String[]{"AAA=BBB"};
            String initialWorkingDirectory = ".";
            IHostShell hostShell = shellService.launchShell((IProgressMonitor)new NullProgressMonitor(), initialWorkingDirectory, environment);
            hostShell.addOutputListener((IHostShellOutputListener)new StdOutOutputListener());
            hostShell.writeToShell(command);
            hostShell.writeToShell("exit");
        }
    }

    public void runCommandInvisibly(IRemoteCmdSubSystem cmdss, String command) throws Exception {
        Object[] result = cmdss.runCommand(command = String.valueOf(command) + cmdss.getParentRemoteCmdSubSystemConfiguration().getCommandSeparator() + "exit", null, false);
        if (result.length > 0 && result[0] instanceof IRemoteCommandShell) {
            IRemoteCommandShell cs = (IRemoteCommandShell)result[0];
            while (cs.isActive()) {
                Thread.sleep(1000L);
            }
            Object[] output = cs.listOutput();
            int i = 0;
            while (i < output.length) {
                if (output[i] instanceof RemoteOutput) {
                    System.out.println(((RemoteOutput)output[i]).getText());
                } else if (output[i] instanceof RemoteError) {
                    System.err.println(((RemoteError)output[i]).getText());
                }
                ++i;
            }
            cmdss.removeShell((Object)cs);
        }
    }

    public static class StdOutOutputListener
    implements IHostShellOutputListener {
        public void shellOutputChanged(IHostShellChangeEvent event) {
            IHostOutput[] lines = event.getLines();
            int i = 0;
            while (i < lines.length) {
                System.out.println(lines[i]);
                ++i;
            }
        }
    }
}

