/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.files.ui;

import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.rse.core.SystemBasePlugin;
import org.eclipse.rse.files.ui.resources.SystemRemoteEditManager;
import org.eclipse.rse.files.ui.resources.SystemUniversalTempFileListener;
import org.eclipse.rse.files.ui.view.RemoteFileSubSystemConfigurationAdapterFactory;
import org.eclipse.rse.files.ui.view.SystemViewFileAdapterFactory;
import org.eclipse.rse.files.ui.view.SystemViewSearchResultAdapterFactory;
import org.eclipse.rse.files.ui.view.SystemViewSearchResultSetAdapterFactory;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    private static Activator plugin;
    private static SystemUniversalTempFileListener _tempFileListener;
    private SystemViewFileAdapterFactory svfaf;
    private SystemViewSearchResultSetAdapterFactory svsaf;
    private SystemViewSearchResultAdapterFactory svsraf;

    public Activator() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        SystemRemoteEditManager.getDefault().refreshRemoteEditProject();
        int eventMask = 1;
        IWorkspace ws = SystemBasePlugin.getWorkspace();
        IAdapterManager manager = Platform.getAdapterManager();
        this.svfaf = new SystemViewFileAdapterFactory();
        this.svfaf.registerWithManager(manager);
        this.svsaf = new SystemViewSearchResultSetAdapterFactory();
        this.svsaf.registerWithManager(manager);
        this.svsraf = new SystemViewSearchResultAdapterFactory();
        this.svsraf.registerWithManager(manager);
        RemoteFileSubSystemConfigurationAdapterFactory rfssfaf = new RemoteFileSubSystemConfigurationAdapterFactory();
        rfssfaf.registerWithManager(manager);
        _tempFileListener = SystemUniversalTempFileListener.getListener();
        ws.addResourceChangeListener((IResourceChangeListener)_tempFileListener, eventMask);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        IWorkspace ws = SystemBasePlugin.getWorkspace();
        ws.removeResourceChangeListener((IResourceChangeListener)_tempFileListener);
        _tempFileListener = null;
        plugin = null;
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.rse.files.ui", (String)path);
    }

    public SystemViewFileAdapterFactory getSystemViewFileAdapterFactory() {
        return this.svfaf;
    }

    public SystemViewSearchResultSetAdapterFactory getSystemViewSearchResultSetAdapterFactory() {
        return this.svsaf;
    }

    public SystemViewSearchResultAdapterFactory getSystemViewSearchResultAdapterFactory() {
        return this.svsraf;
    }
}

