/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.files.ui.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.containers.ProjectSourceContainer;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.rse.core.SystemBasePlugin;
import org.eclipse.rse.files.ui.actions.SystemEditFileAction;
import org.eclipse.rse.files.ui.resources.RemoteSourceLookupDirector;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteCommandShell;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteError;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteOutput;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;

public class SystemEditProjectFileLineAction
extends SystemEditFileAction {
    protected IRemoteFile _remoteFile;
    protected IRemoteOutput _output;

    public SystemEditProjectFileLineAction(String text, String tooltip, ImageDescriptor image, Shell parent, String editorId, IRemoteFile remoteFile, IRemoteOutput output) {
        super(text, tooltip, image, parent, editorId);
        this._output = output;
        this._remoteFile = remoteFile;
    }

    public void run() {
        this.process();
    }

    protected void process() {
        this.openWorkspaceFile(this._remoteFile, this._output);
    }

    protected IEditorRegistry getEditorRegistry() {
        return RSEUIPlugin.getDefault().getWorkbench().getEditorRegistry();
    }

    protected IEditorDescriptor getDefaultTextEditor() {
        IEditorRegistry registry = this.getEditorRegistry();
        return registry.findEditor("org.eclipse.ui.DefaultTextEditor");
    }

    protected boolean openWorkspaceFile(IRemoteFile remoteFile, IRemoteOutput output) {
        block15: {
            IRemoteCommandShell cmd = (IRemoteCommandShell)output.getParent();
            IProject associatedProject = cmd.getAssociatedProject();
            if (associatedProject != null) {
                ProjectSourceContainer container = new ProjectSourceContainer(associatedProject, false);
                RemoteSourceLookupDirector director = new RemoteSourceLookupDirector();
                container.init((ISourceLookupDirector)director);
                try {
                    Object[] matches = container.findSourceElements(remoteFile.getName());
                    int i = 0;
                    while (i < matches.length) {
                        ++i;
                    }
                    if (matches.length != 1) break block15;
                    IFile localMatch = (IFile)matches[0];
                    IWorkbenchPage activePage = SystemBasePlugin.getActiveWorkbenchWindow().getActivePage();
                    FileEditorInput finput = new FileEditorInput(localMatch);
                    IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(remoteFile.getName());
                    if (desc == null) {
                        desc = this.getDefaultTextEditor();
                    }
                    String editorid = desc.getId();
                    IEditorPart editor = activePage.openEditor((IEditorInput)finput, editorid);
                    int line = output.getLine();
                    int charStart = output.getCharStart();
                    int charEnd = output.getCharEnd();
                    try {
                        IMarker marker = null;
                        if (output instanceof IRemoteError) {
                            IRemoteError error = (IRemoteError)output;
                            String type = error.getType();
                            marker = localMatch.createMarker("org.eclipse.core.resources.textmarker");
                            if (type.equals("error")) {
                                marker.setAttribute("severity", 2);
                            } else if (type.equals("warning")) {
                                marker.setAttribute("severity", 1);
                            } else if (type.equals("informational")) {
                                marker.setAttribute("severity", 0);
                            }
                            marker.setAttribute("message", (Object)output.getText());
                            marker.setAttribute("lineNumber", line);
                            marker.setAttribute("charStart", charStart);
                            marker.setAttribute("charEnd", charEnd);
                        } else {
                            marker = localMatch.createMarker("org.eclipse.core.resources.textmarker");
                            marker.setAttribute("lineNumber", line);
                            marker.setAttribute("charStart", charStart);
                            marker.setAttribute("charEnd", charEnd);
                        }
                        IDE.gotoMarker((IEditorPart)editor, (IMarker)marker);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                    return true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return false;
    }
}

