/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.files.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.files.ui.FileResources;
import org.eclipse.rse.files.ui.actions.SystemExtractAction;
import org.eclipse.rse.files.ui.resources.ExtractToDialog;
import org.eclipse.rse.model.ISystemResourceChangeEvent;
import org.eclipse.rse.model.SystemRegistry;
import org.eclipse.rse.model.SystemResourceChangeEvent;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.messages.SystemMessageDialog;
import org.eclipse.rse.ui.validators.IValidatorRemoteSelection;
import org.eclipse.rse.ui.view.ISystemRemoteElementAdapter;
import org.eclipse.swt.widgets.Shell;

public class SystemExtractToAction
extends SystemExtractAction
implements IValidatorRemoteSelection {
    protected static final String[] systemTypes = new String[]{"Local", "Windows", "Linux", "Power Linux", "Unix", "AIX", "iSeries"};
    protected SystemMessage targetDescendsFromSrcMsg = null;
    protected int currentlyProcessingSelection = 0;

    public SystemExtractToAction(Shell parent) {
        super(parent, FileResources.ACTION_EXTRACT_TO_LABEL, FileResources.ACTION_EXTRACT_TO_TOOLTIP);
        this.setHelp("org.eclipse.rse.ui.actn0119");
        this.setImageDescriptor(RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.xtrctarchvto_tskIcon"));
    }

    public SystemExtractToAction(Shell parent, String label, String tooltip) {
        super(parent, label, tooltip);
        this.setHelp("org.eclipse.rse.ui.actn0119");
        this.setImageDescriptor(RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.xtrctarchvto_tskIcon"));
    }

    public void run() {
        int i = 0;
        while (i < this._selected.size()) {
            SystemMessageDialog dlg;
            SystemMessage msg;
            this.currentlyProcessingSelection = i;
            IRemoteFile selection = (IRemoteFile)this._selected.get(i);
            String title = FileResources.RESID_EXTRACTTO_TITLE;
            ExtractToDialog dialog = new ExtractToDialog(this.getShell(), title);
            if (dialog == null) {
                return;
            }
            dialog.setNeedsProgressMonitor(true);
            String message = SystemMessage.sub((String)FileResources.RESID_EXTRACTTO_PROMPT, (String)"&1", (String)selection.getAbsolutePath());
            dialog.setMessage(message);
            dialog.setShowNewConnectionPrompt(true);
            dialog.setShowPropertySheet(true, false);
            dialog.setSystemTypes(systemTypes);
            dialog.setPreSelection(selection);
            dialog.setBlockOnOpen(true);
            dialog.setSelectionValidator(this);
            dialog.open();
            boolean cancelled = false;
            if (dialog.wasCancelled()) {
                cancelled = true;
            }
            IRemoteFile destination = null;
            IRemoteFileSubSystem destSS = null;
            if (cancelled) {
                return;
            }
            destination = (IRemoteFile)dialog.getOutputObject();
            destSS = destination.getParentRemoteFileSubSystem();
            if (destination == null) {
                System.out.println("blah");
            }
            if (selection.isAncestorOf(destination)) {
                msg = RSEUIPlugin.getPluginMessage((String)"RSEG1129");
                dlg = new SystemMessageDialog(this.getShell(), msg);
                dlg.open();
                --i;
            } else if (!destination.canWrite()) {
                msg = RSEUIPlugin.getPluginMessage((String)"RSEF1313");
                dlg = new SystemMessageDialog(this.getShell(), msg);
                dlg.open();
                --i;
            } else {
                IRunnableContext runnableContext = this.getRunnableContext(this._parent);
                SystemExtractAction.ExtractRunnable runnable = new SystemExtractAction.ExtractRunnable(selection, destination);
                try {
                    runnableContext.run(false, true, (IRunnableWithProgress)runnable);
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (InterruptedException interruptedException) {}
                SystemRegistry registry = RSEUIPlugin.getTheSystemRegistry();
                registry.fireRemoteResourceChangeEvent(1, (Object)destination, (Object)destination.getParentPath(), (ISubSystem)destSS, null, null);
                registry.fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent((Object)destination, 82, (Object)destination.getParentPath()));
            }
            ++i;
        }
    }

    protected boolean destinationInSource(IRemoteFile destination) {
        boolean insource = false;
        int i = 0;
        while (i < this._selected.size()) {
            if (destination.isDescendantOf((IRemoteFile)this._selected.get(i))) {
                insource = true;
                break;
            }
            ++i;
        }
        return insource;
    }

    protected String getActionLabelForSingleSelection() {
        return this._label;
    }

    public SystemMessage isValid(IHost selectedConnection, Object[] selectedObjects, ISystemRemoteElementAdapter[] remoteAdaptersForSelectedObjects) {
        Object selectedObject = selectedObjects[0];
        IRemoteFile currentSelection = (IRemoteFile)this._selected.get(this.currentlyProcessingSelection);
        if (!(selectedObject instanceof IRemoteFile)) {
            return null;
        }
        IRemoteFile selectedFolder = (IRemoteFile)selectedObject;
        if (selectedFolder.isDescendantOf(currentSelection)) {
            if (this.targetDescendsFromSrcMsg == null) {
                this.targetDescendsFromSrcMsg = RSEUIPlugin.getPluginMessage((String)"RSEF1312");
            }
            return this.targetDescendsFromSrcMsg;
        }
        return null;
    }
}

