/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.files.ui.actions;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.core.SystemBasePlugin;
import org.eclipse.rse.files.ui.FileResources;
import org.eclipse.rse.files.ui.resources.SystemEditableRemoteFile;
import org.eclipse.rse.files.ui.resources.SystemIFileProperties;
import org.eclipse.rse.files.ui.resources.UniversalFileTransferUtility;
import org.eclipse.rse.files.ui.view.DownloadJob;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.view.ISystemEditableRemoteObject;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class SystemRemoteFileOpenWithMenu
extends ContributionItem {
    protected IWorkbenchPage page = null;
    protected IRemoteFile _remoteFile = null;
    protected IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
    private static Hashtable imageCache = new Hashtable(11);
    public static final String ID = "org.eclipse.ui.OpenWithMenu";
    private static final Comparator comparer = new Comparator(){
        private Collator collator = Collator.getInstance();

        public int compare(Object arg0, Object arg1) {
            String s1 = ((IEditorDescriptor)arg0).getLabel();
            String s2 = ((IEditorDescriptor)arg1).getLabel();
            return this.collator.compare(s1, s2);
        }
    };

    public SystemRemoteFileOpenWithMenu() {
        super(ID);
    }

    public void updateSelection(IStructuredSelection selection) {
        if (selection.size() == 1) {
            this._remoteFile = (IRemoteFile)selection.getFirstElement();
        }
    }

    protected Image getImage(IEditorDescriptor editorDesc) {
        ImageDescriptor imageDesc = this.getImageDescriptor(editorDesc);
        if (imageDesc == null) {
            return null;
        }
        Image image = (Image)imageCache.get(imageDesc);
        if (image == null) {
            image = imageDesc.createImage();
            imageCache.put(imageDesc, image);
        }
        return image;
    }

    private String getFileName() {
        return this._remoteFile.getName();
    }

    private ImageDescriptor getImageDescriptor(IEditorDescriptor editorDesc) {
        ImageDescriptor imageDesc = null;
        imageDesc = editorDesc == null ? this.registry.getImageDescriptor(this.getFileName()) : editorDesc.getImageDescriptor();
        if (imageDesc == null && editorDesc.getId().equals("org.eclipse.ui.systemExternalEditor")) {
            imageDesc = this.registry.getSystemExternalEditorImageDescriptor(this.getFileName());
        }
        return imageDesc;
    }

    protected void createMenuItem(Menu menu, final IEditorDescriptor descriptor, IEditorDescriptor preferredEditor) {
        final MenuItem menuItem = new MenuItem(menu, 16);
        boolean isPreferred = preferredEditor != null && descriptor.getId().equals(preferredEditor.getId());
        menuItem.setSelection(isPreferred);
        menuItem.setText(descriptor.getLabel());
        Image image = this.getImage(descriptor);
        if (image != null) {
            menuItem.setImage(image);
        }
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        if (!menuItem.getSelection()) break;
                        SystemRemoteFileOpenWithMenu.this.openEditor(SystemRemoteFileOpenWithMenu.this._remoteFile, descriptor);
                    }
                }
            }
        };
        menuItem.addListener(13, listener);
    }

    protected void openEditor(IRemoteFile remoteFile, IEditorDescriptor descriptor) {
        block5: {
            boolean systemEditor;
            SystemEditableRemoteFile editable = null;
            editable = descriptor == null ? new SystemEditableRemoteFile(remoteFile) : new SystemEditableRemoteFile(remoteFile, descriptor.getId());
            boolean bl = systemEditor = descriptor != null && descriptor.getId().equals("org.eclipse.ui.systemExternalEditor");
            if (this.isFileCached(editable, remoteFile)) {
                try {
                    if (systemEditor) {
                        editable.openSystemEditor();
                        break block5;
                    }
                    editable.openEditor();
                }
                catch (Exception exception) {}
            } else {
                DownloadJob oJob = new DownloadJob(editable, systemEditor);
                oJob.schedule();
            }
        }
    }

    private boolean isFileCached(ISystemEditableRemoteObject editable, IRemoteFile remoteFile) {
        boolean newFile;
        IFile file = editable.getLocalResource();
        SystemIFileProperties properties = new SystemIFileProperties((IResource)file);
        boolean bl = newFile = !file.exists();
        if (!newFile && file.exists()) {
            boolean remoteNewer;
            long storedModifiedStamp = properties.getRemoteFileTimeStamp();
            IRemoteFileSubSystem subsystem = remoteFile.getParentRemoteFileSubSystem();
            try {
                remoteFile = subsystem.getRemoteFileObject(remoteFile.getAbsolutePath());
            }
            catch (Exception exception) {}
            long remoteModifiedStamp = remoteFile.getLastModified();
            boolean dirty = properties.getDirty();
            boolean bl2 = remoteNewer = storedModifiedStamp != remoteModifiedStamp;
            return !dirty && !remoteNewer;
        }
        return false;
    }

    private IFile getLocalResource(IRemoteFile remoteFile) {
        return (IFile)UniversalFileTransferUtility.getTempFileFor(remoteFile);
    }

    protected IEditorDescriptor getPreferredEditor(IRemoteFile remoteFile) {
        IFile localFile = this.getLocalResource(remoteFile);
        if (localFile == null) {
            return this.registry.getDefaultEditor(remoteFile.getName());
        }
        return IDE.getDefaultEditor((IFile)localFile);
    }

    protected IEditorDescriptor getDefaultEditor(IRemoteFile remoteFile) {
        IFile localFile = this.getLocalResource(remoteFile);
        if (localFile == null || !localFile.exists()) {
            return this.registry.getDefaultEditor(remoteFile.getName());
        }
        IEditorDescriptor descriptor = IDE.getDefaultEditor((IFile)localFile);
        if (descriptor == null) {
            descriptor = this.getDefaultTextEditor();
        }
        return descriptor;
    }

    protected void setDefaultEditor(IRemoteFile remoteFile, String editorId) {
        IFile localFile = this.getLocalResource(remoteFile);
        if (localFile == null) {
            this.registry.setDefaultEditor(remoteFile.getName(), editorId);
        } else {
            IDE.setDefaultEditor((IFile)localFile, (String)editorId);
        }
    }

    protected IEditorRegistry getEditorRegistry() {
        return RSEUIPlugin.getDefault().getWorkbench().getEditorRegistry();
    }

    protected IEditorDescriptor getDefaultTextEditor() {
        IEditorRegistry registry = this.getEditorRegistry();
        return registry.findEditor("org.eclipse.ui.DefaultTextEditor");
    }

    public void fill(Menu menu, int index) {
        if (this._remoteFile == null) {
            return;
        }
        IEditorDescriptor defaultEditor = this.registry.findEditor("org.eclipse.ui.DefaultTextEditor");
        IEditorDescriptor preferredEditor = this.getPreferredEditor(this._remoteFile);
        IEditorDescriptor[] editors = this.registry.getEditors(this.getFileName());
        Collections.sort(Arrays.asList(editors), comparer);
        boolean defaultFound = false;
        ArrayList<IEditorDescriptor> alreadyMapped = new ArrayList<IEditorDescriptor>();
        int i = 0;
        while (i < editors.length) {
            IEditorDescriptor editor = editors[i];
            if (!alreadyMapped.contains(editor)) {
                this.createMenuItem(menu, editor, preferredEditor);
                if (defaultEditor != null && editor.getId().equals(defaultEditor.getId())) {
                    defaultFound = true;
                }
                alreadyMapped.add(editor);
            }
            ++i;
        }
        if (editors.length > 0) {
            new MenuItem(menu, 2);
        }
        if (!defaultFound && defaultEditor != null) {
            this.createMenuItem(menu, defaultEditor, preferredEditor);
        }
        IEditorDescriptor descriptor = this.registry.findEditor("org.eclipse.ui.systemExternalEditor");
        this.createMenuItem(menu, descriptor, preferredEditor);
        this.createDefaultMenuItem(menu, this._remoteFile);
    }

    public boolean isDynamic() {
        return true;
    }

    protected void createDefaultMenuItem(Menu menu, final IRemoteFile file) {
        final MenuItem menuItem = new MenuItem(menu, 16);
        IEditorDescriptor defaultEditor = this.getDefaultEditor(file);
        menuItem.setSelection(defaultEditor == null);
        menuItem.setText(FileResources.DefaultEditorDescription_name);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        if (!menuItem.getSelection()) break;
                        SystemRemoteFileOpenWithMenu.this.setDefaultEditor(file, null);
                        IEditorDescriptor defaultEditor = null;
                        try {
                            defaultEditor = SystemRemoteFileOpenWithMenu.this.getEditorDescriptor(file);
                            SystemRemoteFileOpenWithMenu.this.openEditor(file, defaultEditor);
                            break;
                        }
                        catch (PartInitException e) {
                            SystemBasePlugin.logError((String)"Error getting default editor descriptor", (Throwable)e);
                        }
                    }
                }
            }
        };
        menuItem.addListener(13, listener);
    }

    protected IEditorDescriptor getEditorDescriptor(IRemoteFile file) throws PartInitException {
        return IDE.getEditorDescriptor((String)file.getName(), (boolean)true);
    }
}

