/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.files.ui.wizards;

import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.rse.core.SystemBasePlugin;
import org.eclipse.rse.core.filters.ISystemFilter;
import org.eclipse.rse.core.filters.ISystemFilterReference;
import org.eclipse.rse.files.ui.FileResources;
import org.eclipse.rse.files.ui.wizards.SystemNewFileWizard;
import org.eclipse.rse.files.ui.wizards.SystemNewFolderWizardMainPage;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.files.RemoteFileIOException;
import org.eclipse.rse.services.files.RemoteFileSecurityException;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.messages.SystemMessageDialog;
import org.eclipse.rse.ui.wizards.AbstractSystemWizard;

public class SystemNewFolderWizard
extends AbstractSystemWizard {
    private SystemNewFolderWizardMainPage mainPage;
    private static final String CLASSNAME = "SystemNewFolderWizard";

    public SystemNewFolderWizard() {
        super(FileResources.RESID_NEWFOLDER_TITLE, RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.newfolder_wizBannerIcon"));
    }

    public void addPages() {
        try {
            this.mainPage = this.createMainPage();
            this.addPage((IWizardPage)this.mainPage);
        }
        catch (Exception exc) {
            SystemBasePlugin.logError((String)"New File: Error in createPages: ", (Throwable)exc);
        }
    }

    protected SystemNewFolderWizardMainPage createMainPage() {
        IRemoteFile[] parentFolders = null;
        SystemMessage errMsg = null;
        try {
            parentFolders = this.getParentFolders();
        }
        catch (SystemMessageException exc) {
            errMsg = exc.getSystemMessage();
        }
        this.mainPage = new SystemNewFolderWizardMainPage((Wizard)this, parentFolders);
        if (errMsg != null) {
            this.mainPage.setErrorMessage(errMsg);
        }
        return this.mainPage;
    }

    public boolean performFinish() {
        boolean ok = true;
        if (this.mainPage.performFinish()) {
            SystemMessage msg = null;
            IRemoteFile parentFolder = this.mainPage.getParentFolder();
            String name = this.mainPage.getfolderName();
            String absName = SystemNewFileWizard.getNewAbsoluteName(parentFolder, name);
            IRemoteFileSubSystem rfss = parentFolder.getParentRemoteFileSubSystem();
            if (!parentFolder.exists()) {
                msg = RSEUIPlugin.getPluginMessage((String)"RSEF1004");
                msg.makeSubstitution((Object)parentFolder.getAbsolutePath());
                this.mainPage.setMessage(msg);
                return false;
            }
            if (this.isInputAFilter() && !this.meetsFilterCriteria(this.getSelectedFilterReference(), parentFolder, absName)) {
                return false;
            }
            IRemoteFile newFolder = null;
            try {
                IRemoteFile newFolderPath = rfss.getRemoteFileObject(absName);
                newFolder = rfss.createFolder(newFolderPath);
            }
            catch (RemoteFileIOException exc) {
                SystemBasePlugin.logDebugMessage((String)"SystemNewFolderWizard:", (String)(" Creating remote folder " + absName + " failed with RemoteFileIOException "));
                msg = exc.getRemoteException() instanceof SystemMessageException ? ((SystemMessageException)((Object)exc.getRemoteException())).getSystemMessage() : RSEUIPlugin.getPluginMessage((String)"RSEF1309").makeSubstitution((Object)absName);
                this.mainPage.setMessage(msg);
                ok = false;
            }
            catch (RemoteFileSecurityException remoteFileSecurityException) {
                SystemBasePlugin.logDebugMessage((String)"SystemNewFolderWizard:", (String)(" Creating remote folder " + absName + " failed with RemoteFileSecurityException "));
                msg = RSEUIPlugin.getPluginMessage((String)"RSEF1304").makeSubstitution((Object)absName);
                this.mainPage.setMessage(msg);
                ok = false;
            }
            catch (SystemMessageException e) {
                SystemBasePlugin.logError((String)"SystemNewFolderWizard:", (Throwable)e);
                this.mainPage.setMessage(e.getSystemMessage());
                ok = false;
            }
            if (ok) {
                SystemNewFileWizard.updateGUI(parentFolder, newFolder, this.getViewer(), this.isInputAFilter(), this.getSelectedFilterReference());
            }
        } else {
            ok = false;
        }
        return ok;
    }

    protected boolean meetsFilterCriteria(ISystemFilterReference selectedFilterRef, IRemoteFile parentFolder, String newAbsName) {
        boolean meets = false;
        ISystemFilter filter = selectedFilterRef.getReferencedFilter();
        String[] strings = filter.getFilterStrings();
        if (strings != null) {
            int idx = 0;
            while (!meets && idx < strings.length) {
                String filterString = strings[idx];
                if (filterString.indexOf("/ns") == -1) {
                    meets = strings.length > 0 && !filterString.startsWith(parentFolder.getAbsolutePath()) ? filterString.equals("./*") : true;
                }
                ++idx;
            }
        }
        if (!meets) {
            SystemMessage msg = RSEUIPlugin.getPluginMessage((String)"RSEF1310");
            SystemMessageDialog msgDlg = new SystemMessageDialog(this.getShell(), msg);
            if (msgDlg.openQuestionNoException()) {
                meets = true;
            }
        }
        return meets;
    }

    protected boolean isInputAFilter() {
        return this.getInputObject() instanceof ISystemFilterReference;
    }

    protected ISystemFilterReference getSelectedFilterReference() {
        if (this.isInputAFilter()) {
            return (ISystemFilterReference)this.getInputObject();
        }
        return null;
    }

    protected IRemoteFile[] getParentFolders() throws SystemMessageException {
        Object input = this.getInputObject();
        if (input instanceof IRemoteFile) {
            return new IRemoteFile[]{(IRemoteFile)input};
        }
        if (input instanceof ISystemFilterReference) {
            return SystemNewFileWizard.getParentFolders((ISystemFilterReference)input);
        }
        return null;
    }
}

