/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.remotecdt;

import org.eclipse.cdt.launch.internal.ui.LaunchUIPlugin;
import org.eclipse.cdt.launch.ui.CMainTab;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.remotecdt.IRemoteConnectionConfigurationConstants;
import org.eclipse.rse.remotecdt.Messages;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.actions.SystemNewConnectionAction;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class RemoteCMainTab
extends CMainTab {
    private static final String REMOTE_PROG_LABEL_TEXT = Messages.RemoteCMainTab_Program;
    private static final String SKIP_DOWNLOAD_BUTTON_TEXT = Messages.RemoteCMainTab_SkipDownload;
    private static final String REMOTE_PROG_TEXT_ERROR = Messages.RemoteCMainTab_ErrorNoProgram;
    private static final String CONNECTION_TEXT_ERROR = Messages.RemoteCMainTab_ErrorNoConnection;
    private static final String REMOTE_PATH_DEFAULT = "";
    private static final boolean SKIP_DOWNLOAD_TO_REMOTE_DEFAULT = false;
    protected Button newRemoteConnectionButton;
    protected Label connectionLabel;
    protected Combo connectionCombo;
    protected Label remoteProgLabel;
    protected Text remoteProgText;
    protected Button skipDownloadButton;
    protected Button useLocalPathButton;
    SystemNewConnectionAction action = null;

    public RemoteCMainTab(boolean terminalOption) {
        super(terminalOption);
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout topLayout = new GridLayout();
        this.setControl((Control)comp);
        comp.setLayout((Layout)topLayout);
        this.createVerticalSpacer(comp, 1);
        this.createRemoteConnectionGroup(comp, 3);
        this.createVerticalSpacer(comp, 1);
        this.createProjectGroup(comp, 1);
        this.createExeFileGroup(comp, 1);
        this.createVerticalSpacer(comp, 1);
        this.createTargetExePath(comp);
        this.createDownloadOption(comp);
        this.fProgText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                RemoteCMainTab.this.setLocalPathForRemotePath();
            }
        });
        LaunchUIPlugin.getDefault().getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.rse.remotecdt.launchgroup");
        LaunchUIPlugin.setDialogShell((Shell)parent.getShell());
    }

    public boolean isValid(ILaunchConfiguration config) {
        boolean retVal = super.isValid(config);
        if (retVal) {
            String name;
            String connection_name;
            this.setErrorMessage(null);
            int currentSelection = this.connectionCombo.getSelectionIndex();
            String string = connection_name = currentSelection >= 0 ? this.connectionCombo.getItem(currentSelection) : REMOTE_PATH_DEFAULT;
            if (connection_name.equals(REMOTE_PATH_DEFAULT)) {
                this.setErrorMessage(CONNECTION_TEXT_ERROR);
                retVal = false;
            }
            if (retVal && (name = this.remoteProgText.getText().trim()).length() == 0) {
                this.setErrorMessage(REMOTE_PROG_TEXT_ERROR);
                retVal = false;
            }
        }
        return retVal;
    }

    protected void createRemoteConnectionGroup(Composite parent, int colSpan) {
        Composite projComp = new Composite(parent, 0);
        GridLayout projLayout = new GridLayout();
        projLayout.numColumns = 3;
        projLayout.marginHeight = 0;
        projLayout.marginWidth = 0;
        projComp.setLayout((Layout)projLayout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = colSpan;
        projComp.setLayoutData((Object)gd);
        this.connectionLabel = new Label(projComp, 0);
        this.connectionLabel.setText(Messages.RemoteCMainTab_Connection);
        gd = new GridData();
        gd.horizontalSpan = 1;
        this.connectionLabel.setLayoutData((Object)gd);
        this.connectionCombo = new Combo(projComp, 12);
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        this.connectionCombo.setLayoutData((Object)gd);
        this.connectionCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RemoteCMainTab.this.setDirty(true);
                RemoteCMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.updateConnectionPulldown();
        this.newRemoteConnectionButton = this.createPushButton(projComp, Messages.RemoteCMainTab_New, null);
        this.newRemoteConnectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                RemoteCMainTab.this.handleNewRemoteConnectionSelected();
                RemoteCMainTab.this.updateLaunchConfigurationDialog();
                RemoteCMainTab.this.updateConnectionPulldown();
            }
        });
    }

    protected void createTargetExePath(Composite parent) {
        Composite mainComp = new Composite(parent, 0);
        GridLayout mainLayout = new GridLayout();
        mainLayout.marginHeight = 0;
        mainLayout.marginWidth = 0;
        mainComp.setLayout((Layout)mainLayout);
        GridData gd = new GridData(768);
        mainComp.setLayoutData((Object)gd);
        this.remoteProgLabel = new Label(mainComp, 0);
        this.remoteProgLabel.setText(REMOTE_PROG_LABEL_TEXT);
        gd = new GridData();
        this.remoteProgLabel.setLayoutData((Object)gd);
        this.remoteProgText = new Text(mainComp, 2052);
        gd = new GridData(768);
        this.remoteProgText.setLayoutData((Object)gd);
        this.remoteProgText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                RemoteCMainTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    protected void createDownloadOption(Composite parent) {
        Composite mainComp = new Composite(parent, 0);
        GridLayout mainLayout = new GridLayout();
        mainLayout.marginHeight = 0;
        mainLayout.marginWidth = 0;
        mainComp.setLayout((Layout)mainLayout);
        GridData gd = new GridData(768);
        mainComp.setLayoutData((Object)gd);
        this.skipDownloadButton = this.createCheckButton(mainComp, SKIP_DOWNLOAD_BUTTON_TEXT);
        this.skipDownloadButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                RemoteCMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.skipDownloadButton.setEnabled(true);
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        int currentSelection = this.connectionCombo.getSelectionIndex();
        config.setAttribute(IRemoteConnectionConfigurationConstants.ATTR_REMOTE_CONNECTION, currentSelection >= 0 ? this.connectionCombo.getItem(currentSelection) : null);
        config.setAttribute(IRemoteConnectionConfigurationConstants.ATTR_REMOTE_PATH, this.remoteProgText.getText());
        config.setAttribute(IRemoteConnectionConfigurationConstants.ATTR_SKIP_DOWNLOAD_TO_TARGET, this.skipDownloadButton.getSelection());
        super.performApply(config);
    }

    public void initializeFrom(ILaunchConfiguration config) {
        String remoteConnection = null;
        try {
            remoteConnection = config.getAttribute(IRemoteConnectionConfigurationConstants.ATTR_REMOTE_CONNECTION, REMOTE_PATH_DEFAULT);
        }
        catch (CoreException coreException) {}
        String[] items = this.connectionCombo.getItems();
        int i = 0;
        i = 0;
        while (i < items.length) {
            if (items[i].equals(remoteConnection)) break;
            ++i;
        }
        if (i < items.length) {
            this.connectionCombo.select(i);
        } else if (items.length > 0) {
            this.connectionCombo.select(0);
        }
        super.initializeFrom(config);
        this.updateTargetProgFromConfig(config);
        this.updateSkipDownloadFromConfig(config);
    }

    protected void handleNewRemoteConnectionSelected() {
        if (this.action == null) {
            this.action = new SystemNewConnectionAction(this.getControl().getShell(), false, false, null);
        }
        try {
            this.action.run();
        }
        catch (Exception exception) {}
    }

    protected void updateConnectionPulldown() {
        this.connectionCombo.removeAll();
        IHost[] connections = RSEUIPlugin.getTheSystemRegistry().getHostsBySubSystemConfigurationCategory("shells");
        int i = 0;
        while (i < connections.length) {
            this.connectionCombo.add(connections[i].getAliasName());
            ++i;
        }
        if (connections.length > 0) {
            this.connectionCombo.select(connections.length - 1);
        }
    }

    protected void updateTargetProgFromConfig(ILaunchConfiguration config) {
        String targetPath = null;
        try {
            targetPath = config.getAttribute(IRemoteConnectionConfigurationConstants.ATTR_REMOTE_PATH, REMOTE_PATH_DEFAULT);
        }
        catch (CoreException coreException) {}
        this.remoteProgText.setText(targetPath);
    }

    protected void updateSkipDownloadFromConfig(ILaunchConfiguration config) {
        boolean downloadToTarget = true;
        try {
            downloadToTarget = config.getAttribute(IRemoteConnectionConfigurationConstants.ATTR_SKIP_DOWNLOAD_TO_TARGET, false);
        }
        catch (CoreException coreException) {}
        this.skipDownloadButton.setSelection(downloadToTarget);
    }

    private void setLocalPathForRemotePath() {
        String programName = this.fProgText.getText().trim();
        String remoteName = this.remoteProgText.getText().trim();
        if (programName.length() != 0 && remoteName.length() == 0) {
            IProject project = this.getCProject().getProject();
            Path exePath = new Path(programName);
            if (!exePath.isAbsolute()) {
                exePath = project.getFile(programName).getLocation();
            }
            String path = exePath.toString();
            this.remoteProgText.setText(path);
        }
    }
}

