/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.services.dstore.files;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.dstore.core.model.DataStoreResources;
import org.eclipse.dstore.core.model.IDataStoreProvider;
import org.eclipse.rse.dstore.universal.miners.IUniversalDataStoreConstants;
import org.eclipse.rse.dstore.universal.miners.filesystem.UniversalFileSystemMiner;
import org.eclipse.rse.services.clientserver.ISystemFileTypes;
import org.eclipse.rse.services.clientserver.PathUtility;
import org.eclipse.rse.services.clientserver.archiveutils.ArchiveHandlerManager;
import org.eclipse.rse.services.clientserver.messages.ISystemMessageProvider;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.dstore.AbstractDStoreService;
import org.eclipse.rse.services.dstore.ServiceResources;
import org.eclipse.rse.services.dstore.files.DStoreHostFile;
import org.eclipse.rse.services.dstore.files.DStoreVirtualHostFile;
import org.eclipse.rse.services.dstore.util.DownloadListener;
import org.eclipse.rse.services.dstore.util.FileSystemMessageUtil;
import org.eclipse.rse.services.files.IFileService;
import org.eclipse.rse.services.files.IHostFile;

public class DStoreFileService
extends AbstractDStoreService
implements IFileService,
IUniversalDataStoreConstants {
    protected DataElement _uploadLogElement = null;
    protected Map _fileElementMap = new HashMap();
    private int _bufferUploadSize = 10240;
    private int _bufferDownloadSize = 10240;
    protected ISystemFileTypes _fileTypeRegistry;
    private static String _percentMsg = SystemMessage.sub((String)SystemMessage.sub((String)SystemMessage.sub((String)ServiceResources.DStore_Service_Percent_Complete_Message, (String)"&0", (String)"{0}"), (String)"&1", (String)"{1}"), (String)"&2", (String)"{2}");
    private static String[] _filterAttributes = new String[]{"attributes", "filter", "filter.id", "doc", "", "", DataStoreResources.FALSE, "2"};
    static /* synthetic */ Class class$0;

    public DStoreFileService(IDataStoreProvider dataStoreProvider, ISystemFileTypes fileTypeRegistry, ISystemMessageProvider msgProvider) {
        super(dataStoreProvider, msgProvider);
        this._fileTypeRegistry = fileTypeRegistry;
    }

    public void uninitService(IProgressMonitor monitor) {
        super.uninitService(monitor);
        this._fileElementMap.clear();
    }

    public String getName() {
        return ServiceResources.DStore_File_Service_Label;
    }

    public String getDescription() {
        return ServiceResources.DStore_File_Service_Description;
    }

    public void setBufferUploadSize(int size) {
        this._bufferUploadSize = size;
    }

    public void setBufferDownloadSize(int size) {
        this._bufferDownloadSize = size;
    }

    protected int getBufferUploadSize() {
        return this._bufferUploadSize;
    }

    protected int getBufferDownloadSize() {
        return this._bufferDownloadSize;
    }

    protected String getMinerId() {
        return UniversalFileSystemMiner.MINER_ID;
    }

    protected String getByteStreamHandlerId() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.dstore.universal.miners.filesystem.UniversalByteStreamHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz.getName();
    }

    protected String getDataStoreRoot() {
        return this.getDataStore().getAttribute(7);
    }

    protected String prepareForDownload(String localPath) {
        int index = localPath.lastIndexOf(File.separator);
        String parentDir = localPath.substring(0, index + 1);
        this.setDataStoreRoot(parentDir);
        String dataStoreLocalPath = localPath.substring(index + 1);
        if (!dataStoreLocalPath.startsWith("/")) {
            dataStoreLocalPath = "/" + dataStoreLocalPath;
        }
        return dataStoreLocalPath;
    }

    protected void setDataStoreRoot(String root) {
        this.getDataStore().setAttribute(7, root);
    }

    protected DataElement findUploadLog() {
        DataElement minerInfo = this.getMinerElement();
        if (this._uploadLogElement == null || this._uploadLogElement.getDataStore() != this.getDataStore()) {
            this._uploadLogElement = this.getDataStore().find(minerInfo, 2, "universal.uploadlog", 2);
        }
        return this._uploadLogElement;
    }

    protected DataElement getAttributes(String fileNameFilter, boolean showHidden) {
        DataElement attributes = this.getDataStore().createTransientObject(_filterAttributes);
        String version = "version_1";
        StringBuffer buffer = new StringBuffer();
        String filter = fileNameFilter == null ? "*" : fileNameFilter;
        buffer.append(version).append("|").append(filter).append("|").append(showHidden);
        attributes.setAttribute(4, buffer.toString());
        return attributes;
    }

    /*
     * Exception decompiling
     */
    public boolean upload(IProgressMonitor monitor, InputStream inputStream, String remoteParent, String remoteFile, boolean isBinary, String hostEncoding) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [11[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean upload(IProgressMonitor monitor, File file, String remoteParent, String remoteFile, boolean isBinary, String srcEncoding, String hostEncoding) {
        inputStream = null;
        bufInputStream = null;
        isCancelled = false;
        transferSuccessful = false;
        totalBytes = file.length();
        try {
            if (totalBytes != 0L) ** GOTO lbl-1000
            created = this.createFile(monitor, remoteParent, remoteFile);
            var32_15 = created.exists();
            ** GOTO lbl32
        }
        catch (FileNotFoundException v0) {}
        ** GOTO lbl-1000
        catch (UnsupportedEncodingException v1) {
            try {
                ** GOTO lbl-1000
                catch (IOException v2) {
                    ** GOTO lbl-1000
                }
                catch (Exception v3) {
                }
            }
            catch (Throwable var31_31) {
                try {
                    if (bufInputStream != null) {
                        bufInputStream.close();
                    }
                    if (isCancelled) {
                        return false;
                    }
                }
                catch (IOException v4) {
                    return false;
                }
                if (totalBytes > 0L) {
                    // empty if block
                }
                throw var31_31;
lbl32:
                // 1 sources

                try {
                    if (bufInputStream != null) {
                        bufInputStream.close();
                    }
                    if (isCancelled) {
                        return false;
                    }
                }
                catch (IOException v5) {
                    return false;
                }
                if (totalBytes > 0L) {
                    // empty if block
                }
                return var32_15;
lbl-1000:
                // 1 sources

                {
                    if (monitor != null) {
                        monitor.setTaskName(file.getName());
                    }
                    this.findUploadLog();
                    buffer_size = this.getBufferUploadSize();
                    inputStream = new FileInputStream(file);
                    bufInputStream = new BufferedInputStream(inputStream, buffer_size);
                    first = true;
                    buffer = new byte[buffer_size];
                    numToRead = 0;
                    available = bufInputStream.available();
                    totalSent = 0L;
                    while (available > 0 && !isCancelled) {
                        numToRead = available < buffer_size ? available : buffer_size;
                        bytesRead = bufInputStream.read(buffer, 0, numToRead);
                        if (bytesRead == -1) break;
                        totalSent += (long)bytesRead;
                        byteStreamHandlerId = this.getByteStreamHandlerId();
                        remotePath = String.valueOf(remoteParent) + this.getSeparator(remoteParent) + remoteFile;
                        if (!isBinary && srcEncoding != null && hostEncoding != null) {
                            tempStr = new String(buffer, 0, bytesRead, srcEncoding);
                            convBytes = tempStr.getBytes(hostEncoding);
                            if (first) {
                                first = false;
                                this.getDataStore().replaceFile(remotePath, convBytes, convBytes.length, true, byteStreamHandlerId);
                            } else {
                                this.getDataStore().replaceAppendFile(remotePath, convBytes, convBytes.length, true, byteStreamHandlerId);
                            }
                        } else if (first) {
                            first = false;
                            this.getDataStore().replaceFile(remotePath, buffer, bytesRead, true, byteStreamHandlerId);
                        } else {
                            this.getDataStore().replaceAppendFile(remotePath, buffer, bytesRead, true, byteStreamHandlerId);
                        }
                        if (monitor != null) {
                            percent = totalSent * 100L / totalBytes;
                            totalSentBuf = new StringBuffer();
                            totalSentBuf.append(totalSent / 1024L);
                            totalSentBuf.append(" KB");
                            totalBuf = new StringBuffer();
                            totalBuf.append(totalBytes / 1024L);
                            totalBuf.append(" KB");
                            percentBuf = new StringBuffer();
                            percentBuf.append(percent);
                            percentBuf.append("%");
                            monitor.worked(bytesRead);
                            str = MessageFormat.format(DStoreFileService._percentMsg, new Object[]{totalSentBuf, totalBuf, percentBuf});
                            monitor.subTask(str);
                            isCancelled = monitor.isCanceled();
                        }
                        available = bufInputStream.available();
                    }
                    transferSuccessful = true;
                }
            }
        }
lbl-1000:
        // 4 sources

        {
            try {
                if (bufInputStream != null) {
                    bufInputStream.close();
                }
                if (isCancelled) {
                    return false;
                }
            }
            catch (IOException v6) {
                return false;
            }
            if (totalBytes > 0L) {
                // empty if block
            }
            return false;
        }
        try {
            if (bufInputStream != null) {
                bufInputStream.close();
            }
            if (isCancelled) {
                return false;
            }
        }
        catch (IOException v7) {
            return false;
        }
        if (totalBytes > 0L) {
            // empty if block
        }
        return true;
    }

    public boolean download(IProgressMonitor monitor, String remoteParent, String remoteFile, File localFile, boolean isBinary, String encoding) throws SystemMessageException {
        DataElement universaltemp = this.getMinerElement();
        if (!localFile.exists()) {
            File parentDir = localFile.getParentFile();
            parentDir.mkdirs();
        }
        try {
            if (localFile.exists()) {
                localFile.delete();
            }
            localFile.createNewFile();
        }
        catch (IOException iOException) {
            return false;
        }
        int mode = isBinary ? -2 : -1;
        DataStore ds = this.getDataStore();
        String remotePath = String.valueOf(remoteParent) + this.getSeparator(remoteParent) + remoteFile;
        DataElement de = this.getElementFor(remotePath);
        if (de.getType().equals("universal.FilterObject")) {
            DStoreHostFile hostFile = (DStoreHostFile)this.getFile(monitor, remoteParent, remoteFile);
            de = hostFile._element;
        }
        long fileLength = DStoreHostFile.getFileLength(de.getSource());
        DataElement remoteElement = ds.createObject(universaltemp, de.getType(), remotePath, String.valueOf(mode));
        this.getDataStoreRoot();
        DataElement localElement = ds.createObject(universaltemp, de.getType(), localFile.getAbsolutePath(), encoding);
        DataElement bufferSizeElement = ds.createObject(universaltemp, "buffer_size", "" + this.getBufferDownloadSize(), "");
        DataElement queryCmd = this.getCommandDescriptor(de, "C_DOWNLOAD_FILE");
        ArrayList<DataElement> argList = new ArrayList<DataElement>();
        argList.add(remoteElement);
        argList.add(localElement);
        argList.add(bufferSizeElement);
        DataElement subject = ds.createObject(universaltemp, de.getType(), remotePath, String.valueOf(mode));
        DataElement status = ds.command(queryCmd, argList, subject);
        if (status == null) {
            System.out.println("no download descriptor for " + remoteElement);
        }
        try {
            DownloadListener dlistener = new DownloadListener(monitor, status, localFile, remotePath, fileLength);
            try {
                dlistener.waitForUpdate();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        catch (Exception exception) {
            return false;
        }
        long localBytes = localFile.length();
        long lastLocalBytes = 0L;
        while (!(localBytes >= fileLength || monitor != null && monitor.isCanceled() || lastLocalBytes == localBytes)) {
            try {
                lastLocalBytes = localBytes;
                Thread.sleep(100L);
                localBytes = localFile.length();
            }
            catch (Exception exception) {}
        }
        List resultList = remoteElement.getNestedData();
        DataElement resultChild = null;
        int i = 0;
        while (i < resultList.size()) {
            resultChild = (DataElement)resultList.get(i);
            if (resultChild.getType().equals("universal.download.success")) {
                return true;
            }
            if (resultChild.getType().equals("FileNotFoundException")) {
                localFile.delete();
                SystemMessage msg = this.getMessage("RSEF1001").makeSubstitution((Object)"FileNotFoundException");
                throw new SystemMessageException(msg);
            }
            if (!resultChild.getType().equals("UnsupportedEncodingException") && resultChild.getType().equals("IOException")) {
                localFile.delete();
                SystemMessage msg = this.getMessage("RSEF1001").makeSubstitution((Object)"IOException");
                throw new SystemMessageException(msg);
            }
            ++i;
        }
        return true;
    }

    public IHostFile getFile(IProgressMonitor monitor, String remoteParent, String name) {
        DataElement de = null;
        if (name.equals(".") && name.equals(remoteParent)) {
            de = this.getElementFor(name);
        } else {
            StringBuffer buf = new StringBuffer(remoteParent);
            buf.append(this.getSeparator(remoteParent));
            buf.append(name);
            de = this.getElementFor(buf.toString());
        }
        this.dsQueryCommand(monitor, de, "C_QUERY_GET_REMOTE_OBJECT");
        return new DStoreHostFile(de);
    }

    protected String getSeparator(String parentPath) {
        if (parentPath == null || parentPath.length() < 2) {
            return "/";
        }
        if (parentPath.endsWith("#virtual#/")) {
            return "";
        }
        if (parentPath.endsWith("#virtual#")) {
            return "/";
        }
        if (parentPath.charAt(1) == ':') {
            if (parentPath.indexOf("#virtual#") != -1) {
                if (parentPath.endsWith("/")) {
                    return "";
                }
                return "/";
            }
            if (ArchiveHandlerManager.getInstance().isArchive(new File(parentPath))) {
                return "#virtual#/";
            }
            if (parentPath.endsWith("\\")) {
                return "";
            }
            return "\\";
        }
        if (parentPath.charAt(0) == '/') {
            if (ArchiveHandlerManager.getInstance().isArchive(new File(parentPath))) {
                return "#virtual#/";
            }
            if (parentPath.endsWith("/")) {
                return "";
            }
            return "/";
        }
        return "/";
    }

    protected IHostFile convertToHostFile(DataElement element) {
        String type = element.getType();
        DStoreHostFile file = null;
        file = type.equals("universal.VirtualFileObject") || type.equals("universal.VirtualFolderObject") ? new DStoreVirtualHostFile(element) : new DStoreHostFile(element);
        String path = file.getAbsolutePath();
        this._fileElementMap.put(path, element);
        return file;
    }

    protected IHostFile[] convertToHostFiles(DataElement[] elements) {
        ArrayList<IHostFile> results = new ArrayList<IHostFile>();
        int i = 0;
        while (i < elements.length) {
            if (!elements[i].isDeleted()) {
                results.add(this.convertToHostFile(elements[i]));
            }
            ++i;
        }
        return results.toArray(new IHostFile[results.size()]);
    }

    public IHostFile getUserHome() {
        return this.getFile(null, ".", ".");
    }

    public IHostFile createFile(IProgressMonitor monitor, String remoteParent, String fileName) throws SystemMessageException {
        String remotePath = String.valueOf(remoteParent) + this.getSeparator(remoteParent) + fileName;
        DataElement de = this.getElementFor(remotePath);
        DataElement status = this.dsStatusCommand(monitor, de, "C_CREATE_FILE");
        if (status == null) {
            return null;
        }
        if (FileSystemMessageUtil.getSourceMessage(status).equals("success")) {
            return new DStoreHostFile(de);
        }
        throw new SystemMessageException(this.getMessage("RSEF1302").makeSubstitution((Object)remotePath));
    }

    public IHostFile createFolder(IProgressMonitor monitor, String remoteParent, String folderName) throws SystemMessageException {
        String remotePath = String.valueOf(remoteParent) + this.getSeparator(remoteParent) + folderName;
        DataElement de = this.getElementFor(remotePath);
        DataElement status = this.dsStatusCommand(monitor, de, "C_CREATE_FOLDER");
        if (status == null) {
            return null;
        }
        if (FileSystemMessageUtil.getSourceMessage(status).equals("success")) {
            return new DStoreHostFile(de);
        }
        throw new SystemMessageException(this.getMessage("RSEF1304").makeSubstitution((Object)remotePath));
    }

    public boolean delete(IProgressMonitor monitor, String remoteParent, String fileName) throws SystemMessageException {
        String remotePath = String.valueOf(remoteParent) + this.getSeparator(remoteParent) + fileName;
        DataElement de = this.getElementFor(remotePath);
        DataElement status = this.dsStatusCommand(monitor, de, "C_DELETE");
        if (status == null) {
            return false;
        }
        if (de.getType().equals("universal.FileObject")) {
            if (FileSystemMessageUtil.getSourceMessage(status).equals("success")) {
                return true;
            }
            throw new SystemMessageException(this.getMessage("RSEF1300").makeSubstitution((Object)FileSystemMessageUtil.getSourceLocation(status)));
        }
        return true;
    }

    public boolean deleteBatch(IProgressMonitor monitor, String[] remoteParents, String[] fileNames) throws SystemMessageException {
        if (remoteParents.length == 1) {
            return this.delete(monitor, remoteParents[0], fileNames[0]);
        }
        ArrayList<DataElement> dataElements = new ArrayList<DataElement>(remoteParents.length);
        int i = 0;
        while (i < remoteParents.length) {
            String remotePath = String.valueOf(remoteParents[i]) + this.getSeparator(remoteParents[i]) + fileNames[i];
            DataElement de = this.getElementFor(remotePath);
            if (de != null) {
                dataElements.add(de);
            }
            ++i;
        }
        DataElement status = this.dsStatusCommand(monitor, (DataElement)dataElements.get(0), dataElements, "C_DELETE_BATCH");
        if (status == null) {
            return false;
        }
        if (FileSystemMessageUtil.getSourceMessage(status).startsWith("failed")) {
            throw new SystemMessageException(this.getMessage("RSEF1300").makeSubstitution((Object)FileSystemMessageUtil.getSourceLocation(status)));
        }
        return true;
    }

    public boolean rename(IProgressMonitor monitor, String remoteParent, String oldName, String newName) throws SystemMessageException {
        String remotePath = String.valueOf(remoteParent) + this.getSeparator(remoteParent) + oldName;
        DataElement de = this.getElementFor(remotePath);
        de.setAttribute(4, newName);
        DataElement status = this.dsStatusCommand(monitor, de, "C_RENAME");
        if (status == null) {
            return false;
        }
        if (FileSystemMessageUtil.getSourceMessage(status).equals("success")) {
            return true;
        }
        throw new SystemMessageException(this.getMessage("RSEF1301").makeSubstitution((Object)FileSystemMessageUtil.getSourceLocation(status)));
    }

    public boolean rename(IProgressMonitor monitor, String remoteParent, String oldName, String newName, IHostFile oldFile) throws SystemMessageException {
        boolean retVal = this.rename(monitor, remoteParent, oldName, newName);
        String newPath = String.valueOf(remoteParent) + this.getSeparator(remoteParent) + newName;
        oldFile.renameTo(newPath);
        return retVal;
    }

    public boolean move(IProgressMonitor monitor, String srcParent, String srcName, String tgtParent, String tgtName) throws SystemMessageException {
        if (this.copy(monitor, srcParent, srcName, tgtParent, tgtName)) {
            try {
                this.delete(monitor, srcParent, srcName);
            }
            catch (Exception exception) {
                return false;
            }
            return true;
        }
        return false;
    }

    protected boolean isSpecialChar(char c) {
        return c == '$' || c == '`' || c == '\"' || c == '\\';
    }

    public boolean copy(IProgressMonitor monitor, String srcParent, String srcName, String tgtParent, String tgtName) throws SystemMessageException {
        DataElement cpCmd;
        DataStore ds = this.getDataStore();
        String srcRemotePath = String.valueOf(srcParent) + this.getSeparator(srcParent) + srcName;
        DataElement srcDE = this.getElementFor(srcRemotePath);
        DataElement tgtDE = this.getElementFor(tgtParent);
        if (tgtDE.getType().equals("universal.FilterObject")) {
            this.dsQueryCommand(monitor, tgtDE, "C_QUERY_GET_REMOTE_OBJECT");
        }
        if ((cpCmd = this.getCommandDescriptor(tgtDE, "C_COPY")) != null) {
            ArrayList<DataElement> args = new ArrayList<DataElement>();
            args.add(srcDE);
            DataElement nameObj = ds.createObject(null, "name", tgtName);
            args.add(nameObj);
            DataElement status = ds.command(cpCmd, args, tgtDE, true);
            try {
                this.getStatusMonitor(ds).waitForUpdate(status, monitor);
                if (status.getAttribute(4).equals("failed")) {
                    throw new SystemMessageException(this.getMessage("RSEF1306").makeSubstitution((Object)srcName));
                }
            }
            catch (InterruptedException interruptedException) {}
            return true;
        }
        return false;
    }

    public boolean copyBatch(IProgressMonitor monitor, String[] srcParents, String[] srcNames, String tgtParent) throws SystemMessageException {
        DataStore ds = this.getDataStore();
        DataElement tgtDE = this.getElementFor(tgtParent);
        DataElement cpCmd = this.getCommandDescriptor(tgtDE, "C_COPY_BATCH");
        if (cpCmd != null) {
            ArrayList<DataElement> args = new ArrayList<DataElement>();
            int i = 0;
            while (i < srcParents.length) {
                String srcRemotePath = String.valueOf(srcParents[i]) + this.getSeparator(srcParents[i]) + srcNames[i];
                DataElement srcDE = this.getElementFor(srcRemotePath);
                args.add(srcDE);
                ++i;
            }
            DataElement status = ds.command(cpCmd, args, tgtDE, true);
            try {
                this.getStatusMonitor(ds).waitForUpdate(status, monitor);
                if (status.getAttribute(4).equals("failed")) {
                    throw new SystemMessageException(this.getMessage("RSEF1306").makeSubstitution((Object)srcNames[0]));
                }
            }
            catch (InterruptedException interruptedException) {}
            return true;
        }
        return false;
    }

    public IHostFile[] getRoots(IProgressMonitor monitor) {
        if (!this.isInitialized()) {
            this.waitForInitialize(null);
        }
        DataStore ds = this.getDataStore();
        DataElement universaltemp = this.getMinerElement();
        DataElement deObj = ds.createObject(universaltemp, "universal.FilterObject", "", "", "", false);
        DataElement[] results = this.dsQueryCommand(monitor, deObj, "C_QUERY_ROOTS");
        return this.convertToHostFiles(results);
    }

    public IHostFile[] getFolders(IProgressMonitor monitor, String remoteParent, String fileFilter) {
        return this.fetch(monitor, remoteParent, fileFilter, "C_QUERY_VIEW_FOLDERS");
    }

    public IHostFile[] getFiles(IProgressMonitor monitor, String remoteParent, String fileFilter) {
        return this.fetch(monitor, remoteParent, fileFilter, "C_QUERY_VIEW_FILES");
    }

    public IHostFile[] getFilesAndFolders(IProgressMonitor monitor, String remoteParent, String fileFilter) {
        return this.fetch(monitor, remoteParent, fileFilter, "C_QUERY_VIEW_ALL");
    }

    protected DataElement getElementFor(String path) {
        String normalizedPath;
        DataElement element;
        if (!this.isInitialized()) {
            this.waitForInitialize(null);
        }
        if ((element = (DataElement)this._fileElementMap.get(normalizedPath = PathUtility.normalizeUnknown((String)path))) != null && element.isDeleted()) {
            this._fileElementMap.remove(normalizedPath);
            element = null;
        }
        if (element == null || element.isDeleted()) {
            DataElement universaltemp = this.getMinerElement();
            element = this.getDataStore().createObject(universaltemp, "universal.FilterObject", normalizedPath, normalizedPath, "", false);
        }
        return element;
    }

    protected IHostFile[] fetch(IProgressMonitor monitor, String remoteParent, String fileFilter, String queryType) {
        DataStore ds = this.getDataStore();
        DataElement deObj = this.getElementFor(remoteParent);
        if (deObj == null) {
            DataElement universaltemp = this.getMinerElement();
            ds.createObject(universaltemp, "universal.FilterObject", remoteParent, remoteParent, "", false);
        }
        DataElement attributes = this.getAttributes(fileFilter, true);
        ArrayList<DataElement> args = new ArrayList<DataElement>(1);
        args.add(attributes);
        DataElement[] results = this.dsQueryCommand(monitor, deObj, args, queryType);
        return this.convertToHostFiles(results);
    }

    public boolean isCaseSensitive() {
        return true;
    }
}

