/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.services.dstore.files;

import java.io.File;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.rse.services.clientserver.PathUtility;
import org.eclipse.rse.services.clientserver.archiveutils.ArchiveHandlerManager;
import org.eclipse.rse.services.files.IHostFile;

public class DStoreHostFile
implements IHostFile {
    public static final int ATTRIBUTE_MODIFIED_DATE = 1;
    public static final int ATTRIBUTE_SIZE = 2;
    public static final int ATTRIBUTE_CLASSIFICATION = 11;
    public static final int ATTRIBUTE_IS_HIDDEN = 3;
    public static final int ATTRIBUTE_CAN_WRITE = 4;
    public static final int ATTRIBUTE_CAN_READ = 5;
    protected DataElement _element;
    protected boolean _isArchive;

    public DStoreHostFile(DataElement element) {
        this._element = element;
        this._isArchive = this.internalIsArchive();
    }

    public DataElement getDataElement() {
        return this._element;
    }

    public static String getNameFromPath(String path) {
        int lastSlash = path.lastIndexOf(47);
        if (lastSlash == -1) {
            lastSlash = path.lastIndexOf(92);
        }
        if (lastSlash > 0 && lastSlash != path.length() - 1) {
            return path.substring(lastSlash + 1);
        }
        return path;
    }

    public static String getParentPathFromPath(String path) {
        int lastSlash = path.lastIndexOf(47);
        if (lastSlash == -1) {
            lastSlash = path.lastIndexOf(92);
        }
        if (lastSlash > 0 && lastSlash != path.length() - 1) {
            return path.substring(0, lastSlash);
        }
        return path;
    }

    public String getName() {
        String type = this._element.getType();
        if (type.equals("universal.FilterObject")) {
            String path = this._element.getName();
            return DStoreHostFile.getNameFromPath(path);
        }
        if (this.isRoot()) {
            return this._element.getValue();
        }
        String name = this._element.getName();
        String parentPath = this.getParentPath();
        if (name.length() == 0 && (parentPath.equals("/") || parentPath.endsWith(":\\"))) {
            return parentPath;
        }
        if (name.length() == 0) {
            String path = this._element.getValue();
            int lastSep = path.lastIndexOf(47);
            if (lastSep == -1) {
                lastSep = path.lastIndexOf(92);
            }
            name = path.substring(lastSep + 1);
            return name;
        }
        return name;
    }

    public String getParentPath() {
        String type = this._element.getType();
        if (type.equals("universal.FilterObject")) {
            String path = this._element.getName();
            return DStoreHostFile.getParentPathFromPath(path);
        }
        if (this._element.getName().length() == 0) {
            String fullPath = this._element.getValue();
            int sep = fullPath.lastIndexOf(47);
            if (sep == -1) {
                sep = fullPath.lastIndexOf(92);
            }
            if (sep == -1) {
                return fullPath;
            }
            return fullPath.substring(0, sep);
        }
        return this._element.getValue();
    }

    public boolean isHidden() {
        String name = this.getName();
        if (name == null || name.length() == 0) {
            return false;
        }
        if (name.charAt(0) == '.') {
            return true;
        }
        if (this.isRoot()) {
            return false;
        }
        String str = DStoreHostFile.getAttribute(this._element.getSource(), 3);
        return str.equals("true");
    }

    public boolean isDirectory() {
        String type = this._element.getType();
        return type.equals("universal.FolderObject") || type.equals("universal.VirtualFolderObject");
    }

    public boolean isRoot() {
        String parentPath = this._element.getValue();
        String name = this._element.getName();
        return parentPath == null || parentPath.length() == 0 || name.length() == 0 && (parentPath.equals("/") || parentPath.endsWith(":\\"));
    }

    public boolean isFile() {
        String type = this._element.getType();
        return type.equals("universal.FileObject") || type.equals("universal.VirtualFileObject") || type.equals("universal.ArchiveFileObject");
    }

    public boolean exists() {
        if (this._element.isDeleted()) {
            return false;
        }
        String type = this._element.getType();
        return type.equals("universal.FileObject") || type.equals("universal.FolderObject") || type.equals("universal.VirtualFileObject") || type.equals("universal.VirtualFolderObject") || type.equals("universal.ArchiveFileObject");
    }

    public String getAbsolutePath() {
        String name = this._element.getName();
        if (name.length() == 0) {
            return this._element.getValue();
        }
        String parentPath = this.getParentPath();
        String type = this._element.getType();
        if (type.equals("universal.FilterObject")) {
            return name;
        }
        if (name.length() == 0) {
            return PathUtility.normalizeUnknown((String)parentPath);
        }
        return PathUtility.normalizeUnknown((String)(String.valueOf(parentPath) + "/" + name));
    }

    public long getSize() {
        return DStoreHostFile.getFileLength(this._element.getSource());
    }

    public long getModifiedDate() {
        return DStoreHostFile.getModifiedDate(this._element.getSource());
    }

    public String getClassification() {
        String classification = DStoreHostFile.getClassification(this._element.getSource());
        if (classification == null) {
            classification = this.isFile() ? "file" : "directory";
        }
        return classification;
    }

    protected static String getClassification(String attributes) {
        return DStoreHostFile.getAttribute(attributes, 11);
    }

    protected static long getFileLength(String attributes) {
        String str = DStoreHostFile.getAttribute(attributes, 2);
        return Long.parseLong(str);
    }

    protected static long getModifiedDate(String attributes) {
        String str = DStoreHostFile.getAttribute(attributes, 1);
        return Long.parseLong(str);
    }

    protected static String getAttribute(String attributes, int index) {
        String[] str = attributes.split("\\|");
        if (str.length > index) {
            return str[index];
        }
        return null;
    }

    public void renameTo(String newAbsolutePath) {
        String current = this.getName();
        if (!newAbsolutePath.endsWith(current)) {
            int lastSep = newAbsolutePath.lastIndexOf(47);
            if (lastSep == -1) {
                lastSep = newAbsolutePath.lastIndexOf(92);
            }
            String newName = newAbsolutePath.substring(lastSep + 1);
            this._element.setAttribute(2, newName);
        }
        this._isArchive = this.internalIsArchive();
    }

    protected boolean internalIsArchive() {
        String path = this.getAbsolutePath();
        return ArchiveHandlerManager.getInstance().isArchive(new File(path)) && !ArchiveHandlerManager.isVirtual((String)path);
    }

    public boolean isArchive() {
        return this._isArchive;
    }

    public boolean canRead() {
        String str = DStoreHostFile.getAttribute(this._element.getSource(), 5);
        return str.equals("true");
    }

    public boolean canWrite() {
        String str = DStoreHostFile.getAttribute(this._element.getSource(), 4);
        return str.equals("true");
    }
}

