/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.services.files.ftp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.rse.services.clientserver.FileTypeMatcher;
import org.eclipse.rse.services.clientserver.NamePatternMatcher;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.files.AbstractFileService;
import org.eclipse.rse.services.files.IFileService;
import org.eclipse.rse.services.files.IHostFile;
import org.eclipse.rse.services.files.RemoteFileIOException;
import org.eclipse.rse.services.files.RemoteFolderNotEmptyException;
import org.eclipse.rse.services.files.ftp.FTPHostFile;
import org.eclipse.rse.services.files.ftp.FTPServiceResources;
import org.eclipse.rse.services.files.ftp.IFTPService;

public class FTPService
extends AbstractFileService
implements IFileService,
IFTPService {
    private FTPClient _ftpClient;
    private FTPFile[] _ftpFiles;
    private String _userHome;
    private transient String _hostName;
    private transient String _userId;
    private transient String _password;
    private transient int _portNumber;
    private OutputStream _ftpLoggingOutputStream;

    public String getName() {
        return FTPServiceResources.FTP_File_Service_Name;
    }

    public String getDescription() {
        return FTPServiceResources.FTP_File_Service_Description;
    }

    public void setHostName(String hostname) {
        this._hostName = hostname;
    }

    public void setPortNumber(int portNumber) {
        this._portNumber = portNumber;
    }

    public void setUserId(String userId) {
        this._userId = userId;
    }

    public void setPassword(String password) {
        this._password = password;
    }

    public void setLoggingStream(OutputStream ftpLoggingOutputStream) {
        this._ftpLoggingOutputStream = ftpLoggingOutputStream;
    }

    public void connect() throws Exception {
        if (this._ftpClient == null) {
            this._ftpClient = new FTPClient();
        }
        if (this._ftpLoggingOutputStream != null) {
            this._ftpClient.registerSpyStream(this._ftpLoggingOutputStream);
        }
        if (this._portNumber == 0) {
            this._ftpClient.connect(this._hostName);
        } else {
            this._ftpClient.connect(this._hostName, this._portNumber);
        }
        this._ftpClient.login(this._userId, this._password);
        this._userHome = this._ftpClient.printWorkingDirectory();
    }

    public void disconnect() {
        try {
            this.getFTPClient().logout();
            this._ftpClient = null;
        }
        catch (Exception exception) {
            this._ftpClient = null;
        }
    }

    public FTPClient getFTPClient() {
        if (this._ftpClient == null) {
            this._ftpClient = new FTPClient();
        }
        if (this._hostName != null) {
            try {
                this._ftpClient.sendNoOp();
            }
            catch (IOException iOException) {
                try {
                    this.connect();
                }
                catch (Exception exception) {}
            }
        }
        return this._ftpClient;
    }

    public IHostFile getFile(IProgressMonitor monitor, String remoteParent, String fileName) throws SystemMessageException {
        String systemName;
        FTPHostFile file;
        block9: {
            block8: {
                if (monitor != null && monitor.isCanceled()) {
                    return null;
                }
                file = null;
                this._ftpClient = this.getFTPClient();
                if (this._ftpClient.changeWorkingDirectory(remoteParent)) break block8;
                return null;
            }
            systemName = this._ftpClient.getSystemName();
            if (this.listFiles(monitor)) break block9;
            return null;
        }
        try {
            int i = 0;
            while (i < this._ftpFiles.length) {
                if (this._ftpFiles[i].getName().equalsIgnoreCase(fileName)) {
                    file = new FTPHostFile(remoteParent, this._ftpFiles[i], systemName);
                    break;
                }
                ++i;
            }
            if (file == null) {
                file = new FTPHostFile(remoteParent, fileName, false, false, 0L, 0L, false);
            }
        }
        catch (Exception e) {
            throw new RemoteFileIOException(e);
        }
        return file;
    }

    public boolean isConnected() {
        boolean isConnected = false;
        if (this._ftpClient != null) {
            isConnected = this._ftpClient.isConnected();
        }
        return isConnected;
    }

    protected IHostFile[] internalFetch(IProgressMonitor monitor, String parentPath, String fileFilter, int fileType) throws SystemMessageException {
        ArrayList<FTPHostFile> results;
        NamePatternMatcher filematcher;
        block11: {
            block10: {
                if (monitor != null && monitor.isCanceled()) {
                    return null;
                }
                if (fileFilter == null) {
                    fileFilter = "*";
                }
                filematcher = null;
                if (fileFilter.endsWith(",")) {
                    String[] types = fileFilter.split(",");
                    filematcher = new FileTypeMatcher(types, true);
                } else {
                    filematcher = new NamePatternMatcher(fileFilter, true, true);
                }
                results = new ArrayList<FTPHostFile>();
                this._ftpClient = this.getFTPClient();
                if (this._ftpClient.changeWorkingDirectory(parentPath)) break block10;
                return null;
            }
            if (this.listFiles(monitor)) break block11;
            return null;
        }
        try {
            String systemName = this._ftpClient.getSystemName();
            int i = 0;
            while (i < this._ftpFiles.length) {
                FTPFile f = this._ftpFiles[i];
                if (filematcher.matches(f.getName()) || f.isDirectory()) {
                    results.add(new FTPHostFile(parentPath, this._ftpFiles[i], systemName));
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new RemoteFileIOException(e);
        }
        return results.toArray(new IHostFile[results.size()]);
    }

    public String getSeparator() {
        return "/";
    }

    public boolean upload(IProgressMonitor monitor, File localFile, String remoteParent, String remoteFile, boolean isBinary, String srcEncoding, String hostEncoding) throws SystemMessageException {
        boolean retValue = true;
        if (monitor != null && monitor.isCanceled()) {
            return false;
        }
        FTPClient ftpClient = this.getFTPClient();
        MyProgressMonitor progressMonitor = new MyProgressMonitor(monitor);
        try {
            int readCount;
            ftpClient.changeWorkingDirectory(remoteParent);
            if (isBinary) {
                ftpClient.setFileType(2);
            } else {
                ftpClient.setFileType(0);
            }
            FileInputStream input = new FileInputStream(localFile);
            OutputStream output = ftpClient.storeFileStream(remoteFile);
            progressMonitor.init(0, localFile.getName(), remoteFile, localFile.length());
            long bytes = 0L;
            byte[] buffer = new byte[4096];
            while ((readCount = input.read(buffer)) > 0) {
                bytes += (long)readCount;
                output.write(buffer, 0, readCount);
                progressMonitor.count(readCount);
                if (monitor == null || !monitor.isCanceled()) continue;
                retValue = false;
                break;
            }
            input.close();
            output.flush();
            output.close();
            ftpClient.completePendingCommand();
            if (!retValue) {
                ftpClient.deleteFile(remoteFile);
            }
            progressMonitor.end();
        }
        catch (Exception e) {
            throw new RemoteFileIOException(e);
        }
        return retValue;
    }

    public boolean upload(IProgressMonitor monitor, InputStream stream, String remoteParent, String remoteFile, boolean isBinary, String hostEncoding) throws SystemMessageException {
        boolean retValue = true;
        try {
            int readCount;
            BufferedInputStream bis = new BufferedInputStream(stream);
            File tempFile = File.createTempFile("ftpup", "temp");
            FileOutputStream os = new FileOutputStream(tempFile);
            BufferedOutputStream bos = new BufferedOutputStream(os);
            byte[] buffer = new byte[4096];
            while ((readCount = bis.read(buffer)) > 0) {
                bos.write(buffer, 0, readCount);
                if (monitor == null || !monitor.isCanceled()) continue;
                retValue = false;
                break;
            }
            bos.close();
            if (retValue) {
                retValue = this.upload(monitor, tempFile, remoteParent, remoteFile, isBinary, "", hostEncoding);
            }
        }
        catch (Exception e) {
            throw new RemoteFileIOException(e);
        }
        return retValue;
    }

    public boolean download(IProgressMonitor monitor, String remoteParent, String remoteFile, File localFile, boolean isBinary, String hostEncoding) throws SystemMessageException {
        if (monitor != null && monitor.isCanceled()) {
            return false;
        }
        MyProgressMonitor progressMonitor = new MyProgressMonitor(monitor);
        IHostFile remoteHostFile = this.getFile(null, remoteParent, remoteFile);
        boolean retValue = false;
        FTPClient ftpClient = this.getFTPClient();
        try {
            int readCount;
            ftpClient.changeWorkingDirectory(remoteParent);
            if (isBinary) {
                ftpClient.setFileType(2);
            } else {
                ftpClient.setFileType(0);
            }
            if (!localFile.exists()) {
                File localParentFile = localFile.getParentFile();
                if (!localParentFile.exists()) {
                    localParentFile.mkdirs();
                }
                localFile.createNewFile();
            }
            FileOutputStream output = new FileOutputStream(localFile);
            InputStream input = ftpClient.retrieveFileStream(remoteFile);
            progressMonitor.init(0, remoteFile, localFile.getName(), remoteHostFile.getSize());
            byte[] buffer = new byte[4096];
            while ((readCount = input.read(buffer)) > 0) {
                ((OutputStream)output).write(buffer, 0, readCount);
                progressMonitor.count(readCount);
                if (monitor == null || !monitor.isCanceled()) continue;
                retValue = false;
                break;
            }
            progressMonitor.end();
            output.flush();
            input.close();
            ((OutputStream)output).close();
            ftpClient.completePendingCommand();
        }
        catch (Exception e) {
            throw new RemoteFileIOException(e);
        }
        return retValue;
    }

    public IHostFile getUserHome() {
        int lastSlash = this._userHome.lastIndexOf(47);
        String name = this._userHome.substring(lastSlash + 1);
        String parent = this._userHome.substring(0, lastSlash);
        if (parent.equals("")) {
            parent = "/";
        }
        return new FTPHostFile(parent, name, true, true, 0L, 0L, true);
    }

    public IHostFile[] getRoots(IProgressMonitor monitor) {
        return new IHostFile[]{new FTPHostFile(null, "/", true, true, 0L, 0L, true)};
    }

    public boolean delete(IProgressMonitor monitor, String remoteParent, String fileName) throws SystemMessageException {
        boolean hasSucceeded = false;
        FTPClient ftpClient = this.getFTPClient();
        MyProgressMonitor progressMonitor = new MyProgressMonitor(monitor);
        progressMonitor.init(String.valueOf(FTPServiceResources.FTP_File_Service_Deleting_Task) + fileName, 1);
        boolean isFile = this.getFile(null, remoteParent, fileName).isFile();
        try {
            hasSucceeded = FTPReply.isPositiveCompletion((int)ftpClient.cwd(remoteParent));
            if (hasSucceeded) {
                hasSucceeded = isFile ? ftpClient.deleteFile(fileName) : ftpClient.removeDirectory(fileName);
            }
            if (!hasSucceeded) {
                throw new Exception(String.valueOf(ftpClient.getReplyString()) + " (" + fileName + ")");
            }
            progressMonitor.worked(1);
        }
        catch (Exception e) {
            if (isFile) {
                throw new RemoteFileIOException(e);
            }
            throw new RemoteFolderNotEmptyException(e);
        }
        return hasSucceeded;
    }

    public boolean rename(IProgressMonitor monitor, String remoteParent, String oldName, String newName) throws SystemMessageException {
        FTPClient ftpClient = this.getFTPClient();
        try {
            if (newName.startsWith("/")) {
                ftpClient.rename(String.valueOf(remoteParent) + this.getSeparator() + oldName, newName);
            } else {
                ftpClient.rename(String.valueOf(remoteParent) + this.getSeparator() + oldName, String.valueOf(remoteParent) + this.getSeparator() + newName);
            }
        }
        catch (Exception e) {
            throw new RemoteFileIOException(e);
        }
        return true;
    }

    public boolean rename(IProgressMonitor monitor, String remoteParent, String oldName, String newName, IHostFile oldFile) {
        boolean hasSucceeded = false;
        oldFile.renameTo(newName);
        return hasSucceeded;
    }

    public boolean move(IProgressMonitor monitor, String srcParent, String srcName, String tgtParent, String tgtName) throws SystemMessageException {
        boolean success = false;
        FTPClient ftpClient = this.getFTPClient();
        try {
            int returnedValue = ftpClient.sendCommand("RNFR " + srcParent + this.getSeparator() + srcName);
            if (350 == returnedValue) {
                returnedValue = ftpClient.sendCommand("RNTO " + tgtParent + this.getSeparator() + tgtName);
            }
            if (!(success = FTPReply.isPositiveCompletion((int)returnedValue))) {
                throw new Exception(ftpClient.getReplyString());
            }
        }
        catch (Exception e) {
            throw new RemoteFileIOException(e);
        }
        return success;
    }

    public IHostFile createFolder(IProgressMonitor monitor, String remoteParent, String folderName) throws SystemMessageException {
        FTPClient ftpClient = this.getFTPClient();
        try {
            if (!ftpClient.changeWorkingDirectory(remoteParent)) {
                throw new Exception(String.valueOf(ftpClient.getReplyString()) + " (" + remoteParent + ")");
            }
            if (!ftpClient.makeDirectory(folderName)) {
                throw new Exception(String.valueOf(ftpClient.getReplyString()) + " (" + folderName + ")");
            }
        }
        catch (Exception e) {
            throw new RemoteFileIOException(e);
        }
        return this.getFile(monitor, remoteParent, folderName);
    }

    public IHostFile createFile(IProgressMonitor monitor, String remoteParent, String fileName) throws SystemMessageException {
        try {
            File tempFile = File.createTempFile("ftp", "temp");
            tempFile.deleteOnExit();
            boolean success = this.upload(monitor, tempFile, remoteParent, fileName, true, null, null);
            if (!success) {
                throw new Exception(this.getFTPClient().getReplyString());
            }
        }
        catch (Exception e) {
            throw new RemoteFileIOException(e);
        }
        return this.getFile(monitor, remoteParent, fileName);
    }

    public boolean copy(IProgressMonitor monitor, String srcParent, String srcName, String tgtParent, String tgtName) throws SystemMessageException {
        throw new RemoteFileIOException(new Exception(FTPServiceResources.FTP_File_Service_Copy_Not_Supported));
    }

    public boolean copyBatch(IProgressMonitor monitor, String[] srcParents, String[] srcNames, String tgtParent) throws SystemMessageException {
        boolean hasSucceeded = false;
        int i = 0;
        while (i < srcNames.length) {
            hasSucceeded = this.copy(monitor, srcParents[i], srcNames[i], tgtParent, srcNames[i]);
            if (!hasSucceeded) break;
            ++i;
        }
        return hasSucceeded;
    }

    public void initService(IProgressMonitor monitor) {
    }

    public void uninitService(IProgressMonitor monitor) {
    }

    public boolean isCaseSensitive() {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean listFiles(IProgressMonitor monitor) throws Exception {
        boolean result = true;
        Job fetchJob = new Job(FTPServiceResources.FTP_File_Service_Listing_Job){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    FTPService.this._ftpFiles = FTPService.this._ftpClient.listFiles();
                }
                catch (IOException e) {
                    return new Status(4, "org.eclipse.rse.services.files.ftp", 4, e.getMessage(), (Throwable)e);
                }
                return new Status(0, "org.eclipse.rse.services.files.ftp", 0, FTPServiceResources.FTP_File_Service_Listing_Job_Success, null);
            }
        };
        IStatus fetchResult = null;
        if (monitor != null) {
            if (monitor.isCanceled()) return false;
            fetchJob.schedule();
        } else {
            fetchJob.schedule();
        }
        if (monitor != null) {
            while (!monitor.isCanceled() && (fetchResult = fetchJob.getResult()) == null) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (monitor.isCanceled() && fetchJob.getState() != 0) {
                fetchJob.cancel();
                this._ftpClient.completePendingCommand();
                result = false;
            }
        } else {
            fetchJob.join();
            fetchResult = fetchJob.getResult();
        }
        if (fetchResult == null) {
            return false;
        }
        if (fetchResult.getSeverity() != 4) return result;
        throw new RemoteFileIOException(new Exception(fetchResult.getException()));
    }

    private class MyProgressMonitor {
        private IProgressMonitor fMonitor;
        private double fWorkPercentFactor;
        private Long fMaxWorkKB;
        private long fWorkToDate;

        public MyProgressMonitor(IProgressMonitor monitor) {
            this.fMonitor = monitor;
        }

        public void init(int op, String src, String dest, long max) {
            String srcFile;
            this.fWorkPercentFactor = 1.0 / (double)max;
            this.fMaxWorkKB = new Long(max / 1024L);
            this.fWorkToDate = 0L;
            String desc = srcFile = new Path(src).lastSegment();
            this.fMonitor.beginTask(desc, (int)max);
        }

        public void init(String label, int max) {
            this.fMonitor.beginTask(label, max);
        }

        public boolean count(long count) {
            this.fWorkToDate += count;
            Long workToDateKB = new Long(this.fWorkToDate / 1024L);
            Double workPercent = new Double(this.fWorkPercentFactor * (double)this.fWorkToDate);
            String subDesc = MessageFormat.format(FTPServiceResources.FTP_File_Service_Monitor_Format, workToDateKB, this.fMaxWorkKB, workPercent);
            this.fMonitor.subTask(subDesc);
            this.fMonitor.worked((int)count);
            return !this.fMonitor.isCanceled();
        }

        public void worked(int work) {
            this.fMonitor.worked(work);
        }

        public void end() {
            this.fMonitor.done();
        }
    }
}

