/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.services.clientserver.archiveutils;

import java.util.zip.ZipEntry;

public class SystemUniversalZipEntry {
    protected ZipEntry _entry;
    protected String _entryFullName;
    protected String _entryFullPath;
    protected String _entryName;
    protected String _extension;
    protected boolean _nested;

    public SystemUniversalZipEntry(ZipEntry entry) {
        this._entry = entry;
        this.doNameProcessing();
    }

    public ZipEntry getEntry() {
        return this._entry;
    }

    public void setEntry(ZipEntry newEntry) {
        this._entry = newEntry;
        this.doNameProcessing();
    }

    private void doNameProcessing() {
        this._entryFullName = this._entry.isDirectory() ? this._entry.getName().substring(0, this._entry.getName().length() - 1) : this._entry.getName();
        int endOfPathPosition = this._entryFullName.lastIndexOf("/");
        if (endOfPathPosition != -1) {
            this._entryFullPath = this._entryFullName.substring(0, endOfPathPosition);
            this._entryName = this._entryFullName.substring(endOfPathPosition + 1);
        } else {
            this._entryFullPath = "";
            this._entryName = this._entryFullName;
        }
        int i = this._entryFullName.lastIndexOf(".");
        this._extension = i == -1 ? "" : this._entryFullName.substring(i + 1);
        if (this._entryFullName.indexOf("/") != -1) {
            this._nested = true;
        }
    }

    public String getFullPath() {
        return this._entryFullPath;
    }

    public String getFullName() {
        return this._entryFullName;
    }

    public String getName() {
        return this._entryName;
    }

    public String getExtension() {
        return this._extension;
    }

    public boolean isNested() {
        return this._nested;
    }

    public boolean isDirectory() {
        return this._entry.isDirectory();
    }
}

