/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.shells.ui.view;

import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.rse.model.ISystemResourceChangeEvent;
import org.eclipse.rse.shells.ui.view.SystemBuildErrorViewProvider;
import org.eclipse.rse.shells.ui.view.SystemViewRemoteErrorAdapter;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteError;
import org.eclipse.rse.ui.messages.ISystemMessageLine;
import org.eclipse.rse.ui.view.SystemTableView;
import org.eclipse.rse.ui.view.SystemTableViewProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class SystemBuildErrorView
extends SystemTableView {
    private Color _errColor;
    private Color _outColor;
    private Color _infColor;
    private Color _warColor;
    private Color _prmColor;

    public SystemBuildErrorView(Table table, ISystemMessageLine msgLine) {
        super(table, msgLine);
        Display display = this.getControl().getDisplay();
        this._errColor = new Color((Device)display, 255, 0, 0);
        this._outColor = new Color((Device)display, 50, 50, 50);
        this._infColor = new Color((Device)display, 0, 0, 255);
        this._warColor = new Color((Device)display, 200, 150, 0);
        this._prmColor = new Color((Device)display, 0, 50, 0);
        this._provider = new SystemBuildErrorViewProvider();
        this.setContentProvider((IContentProvider)this._provider);
        this.addFilter(new ErrorViewerFilter());
    }

    public void refresh() {
        super.refresh();
        Table table = this.getTable();
        if (table != null && table.getItemCount() > 0) {
            TableItem lastItem = table.getItem(table.getItemCount() - 1);
            table.showItem(lastItem);
        }
    }

    public IPropertyDescriptor[] getVisibleDescriptors(Object object) {
        SystemViewRemoteErrorAdapter adpt = new SystemViewRemoteErrorAdapter();
        return adpt.getUniquePropertyDescriptors();
    }

    public IPropertyDescriptor getNameDescriptor(Object object) {
        SystemViewRemoteErrorAdapter adpt = new SystemViewRemoteErrorAdapter();
        return adpt.getPropertyDescriptors()[0];
    }

    public void setOffset(int offset) {
        ((SystemBuildErrorViewProvider)this._provider).setOffset(offset);
    }

    public synchronized void updateChildren() {
        this.computeLayout();
        this.internalRefresh(this.getInput());
    }

    public void clearAllItems() {
        Object input = this.getInput();
        SystemTableViewProvider provider = (SystemTableViewProvider)this.getContentProvider();
        Object[] children = provider.getChildren(input);
        ((SystemBuildErrorViewProvider)this._provider).moveOffsetToEnd();
        this.clearFirstItems(children, children.length - 1);
        provider.flushCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearFirstItems(Object[] children, int items) {
        Table table = this.getTable();
        table.setRedraw(false);
        Table table2 = table;
        synchronized (table2) {
            table.getItemCount();
            table.remove(0, items);
        }
        table.setRedraw(true);
    }

    protected Item newItem(Widget parent, int flags, int ix) {
        if (parent instanceof Table) {
            return new TableItem((Table)parent, flags);
        }
        return null;
    }

    public void systemResourceChanged(ISystemResourceChangeEvent event) {
        SystemTableViewProvider provider;
        Object child = event.getSource();
        if (event.getType() == 82 && child == this.getInput() && (provider = (SystemTableViewProvider)this.getContentProvider()) != null) {
            provider.flushCache();
            this.updateChildren();
            return;
        }
    }

    protected Object getParentForContent(Object element) {
        return this.getAdapter(element).getParent(element);
    }

    private class ErrorViewerFilter
    extends ViewerFilter {
        private ErrorViewerFilter() {
        }

        public boolean select(Viewer viewer, Object obj1, Object obj2) {
            return obj2 instanceof IRemoteError;
        }
    }
}

