/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.shells.ui.view;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.rse.core.subsystems.IRemoteLineReference;
import org.eclipse.rse.model.ISystemResourceChangeEvent;
import org.eclipse.rse.model.ISystemResourceChangeListener;
import org.eclipse.rse.model.SystemRegistry;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.shells.ui.view.SystemBuildErrorView;
import org.eclipse.rse.shells.ui.view.SystemBuildErrorViewProvider;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteCmdSubSystem;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteCommandShell;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteOutput;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemResources;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.messages.ISystemMessageLine;
import org.eclipse.rse.ui.view.ISystemViewElementAdapter;
import org.eclipse.rse.ui.view.SystemTableViewProvider;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;

public class SystemBuildErrorViewPart
extends ViewPart
implements ISelectionListener,
SelectionListener,
ISystemResourceChangeListener,
ISystemMessageLine {
    public static final String ID = "org.eclipse.rse.shells.ui.view.buildErrorView";
    private SystemBuildErrorView _viewer;
    private ClearAction _clearAction;
    private boolean _enableUpdates = true;
    private String _message;
    private String _errorMessage;
    private SystemMessage sysErrorMessage;
    private IStatusLineManager _statusLine = null;
    static /* synthetic */ Class class$0;

    public void setFocus() {
        this._viewer.getControl().setFocus();
    }

    public SystemBuildErrorView getViewer() {
        return this._viewer;
    }

    public Shell getShell() {
        return this._viewer.getShell();
    }

    public void fillLocalToolBar() {
        boolean firstCall = false;
        if (this._clearAction == null) {
            firstCall = true;
            this._clearAction = new ClearAction();
        }
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        this.addToolBarItems(toolBarManager);
        if (firstCall) {
            actionBars.getMenuManager();
            this._statusLine = actionBars.getStatusLineManager();
        }
    }

    private void addToolBarItems(IToolBarManager toolBarManager) {
        toolBarManager.removeAll();
        toolBarManager.add((IAction)this._clearAction);
    }

    public void createPartControl(Composite parent) {
        Table table = new Table(parent, 101122);
        this._viewer = new SystemBuildErrorView(table, this);
        table.setLinesVisible(true);
        ISelectionService selectionService = this.getSite().getWorkbenchWindow().getSelectionService();
        selectionService.addSelectionListener((ISelectionListener)this);
        SystemRegistry registry = RSEUIPlugin.getTheSystemRegistry();
        registry.addSystemResourceChangeListener((ISystemResourceChangeListener)this);
        this._viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SystemBuildErrorViewPart.this.handleDoubleClick(event);
            }
        });
        SystemWidgetHelpers.setHelp((Control)this._viewer.getControl(), (String)"org.eclipse.rse.ui.uerr0000");
        this.fillLocalToolBar();
    }

    private void handleDoubleClick(DoubleClickEvent event) {
        ISystemViewElementAdapter adapter;
        IStructuredSelection s = (IStructuredSelection)event.getSelection();
        Object element = s.getFirstElement();
        if (element == null) {
            return;
        }
        IAdaptable iAdaptable = (IAdaptable)element;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.ui.view.ISystemViewElementAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((adapter = (ISystemViewElementAdapter)iAdaptable.getAdapter((Class)clazz)) != null && !adapter.hasChildren(element)) {
            adapter.handleDoubleClick(element);
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection sel) {
    }

    public void dispose() {
        ISelectionService selectionService = this.getSite().getWorkbenchWindow().getSelectionService();
        selectionService.removeSelectionListener((ISelectionListener)this);
        this._viewer.dispose();
        SystemRegistry registry = RSEUIPlugin.getTheSystemRegistry();
        registry.removeSystemResourceChangeListener((ISystemResourceChangeListener)this);
        super.dispose();
    }

    public void selectionChanged(SelectionChangedEvent e) {
    }

    public void resetOffset() {
        SystemBuildErrorViewProvider provider = (SystemBuildErrorViewProvider)this._viewer.getContentProvider();
        int size = ((IRemoteCommandShell)this._viewer.getInput()).getSize();
        provider.setOffset(size - 1);
    }

    public void setInput(IAdaptable object, String cmdString) {
        this.setInput(object, true, cmdString);
    }

    public void setInput(IAdaptable object, boolean updateHistory, String cmdString) {
        this._viewer.getTable().removeAll();
        this.setEnableUpdates(true);
        if (object instanceof IRemoteCommandShell) {
            this._viewer.setInput(object);
        } else if (object instanceof IRemoteOutput) {
            IRemoteOutput output = (IRemoteOutput)object;
            this._viewer.setInput(output.getParent());
            SystemBuildErrorViewProvider provider = (SystemBuildErrorViewProvider)this._viewer.getContentProvider();
            provider.setOffset(output.getIndex() - 1);
        } else if (object instanceof IRemoteLineReference) {
            this._viewer.setInput(((IRemoteLineReference)object).getParent());
        }
        SystemMessage msg = RSEUIPlugin.getPluginMessage((String)"RSEG1500");
        msg.makeSubstitution((Object)cmdString);
        this.setPartName(msg.getLevelOneText());
    }

    public void updateOutput() {
        if (this._viewer != null) {
            ((SystemTableViewProvider)this._viewer.getContentProvider()).flushCache();
            this._viewer.updateChildren();
        }
    }

    private void updateOutput(IRemoteCommandShell root) {
        if (root != null && this._enableUpdates) {
            if (this._viewer.getInput() != root) {
                this._viewer.clearAllItems();
                this._viewer.setInput(root);
            }
            this.updateOutput();
        }
    }

    public void setEnableUpdates(boolean enable) {
        if (!enable) {
            this.updateOutput();
        }
        this._enableUpdates = enable;
    }

    public void systemResourceChanged(ISystemResourceChangeEvent event) {
        Object parent;
        if (event.getType() == 140) {
            Object source = event.getSource();
            if (source instanceof IRemoteCmdSubSystem) {
                RSEUIPlugin.getTheSystemRegistry().getShell();
            } else if (source instanceof IRemoteCommandShell) {
                this.updateOutput((IRemoteCommandShell)source);
            }
        } else if (event.getType() == 82 && (parent = event.getParent()) instanceof IRemoteCommandShell) {
            this.updateOutput((IRemoteCommandShell)parent);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
    }

    public void clearErrorMessage() {
        this._errorMessage = null;
        this.sysErrorMessage = null;
        if (this._statusLine != null) {
            this._statusLine.setErrorMessage(this._errorMessage);
        }
    }

    public void clearMessage() {
        this._message = null;
        if (this._statusLine != null) {
            this._statusLine.setMessage(this._message);
        }
    }

    public String getErrorMessage() {
        return this._errorMessage;
    }

    public String getMessage() {
        return this._message;
    }

    public void setErrorMessage(String message) {
        this._errorMessage = message;
        if (this._statusLine != null) {
            this._statusLine.setErrorMessage(message);
        }
    }

    public SystemMessage getSystemErrorMessage() {
        return this.sysErrorMessage;
    }

    public void setErrorMessage(SystemMessage message) {
        this.sysErrorMessage = message;
        this.setErrorMessage(message.getLevelOneText());
    }

    public void setErrorMessage(Throwable exc) {
        this.setErrorMessage(exc.getMessage());
    }

    public void setMessage(String message) {
        this._message = message;
        if (this._statusLine != null) {
            this._statusLine.setMessage(message);
        }
    }

    public void setMessage(SystemMessage message) {
        this.setMessage(message.getLevelOneText());
    }

    class BrowseAction
    extends Action {
        public BrowseAction(String label, ImageDescriptor des) {
            super(label, des);
            this.setToolTipText(label);
        }

        public void checkEnabledState() {
            if (SystemBuildErrorViewPart.this.getViewer().getInput() != null) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }

        public void run() {
        }
    }

    public class ClearAction
    extends BrowseAction {
        public ClearAction() {
            super(SystemResources.ACTION_CLEAR_LABEL, RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.clearIcon"));
            ImageDescriptor des = RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.clearIcon");
            this.setImageDescriptor(des);
        }

        public void checkEnabledState() {
            Object input = SystemBuildErrorViewPart.this.getViewer().getInput();
            if (input != null && input instanceof IRemoteCommandShell) {
                this.setEnabled(((IRemoteCommandShell)input).isActive());
                return;
            }
            this.setEnabled(false);
        }

        public void run() {
            this.clear();
        }

        private void clear() {
            SystemBuildErrorViewPart.this.getViewer().clearAllItems();
        }
    }
}

