/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.discovery.wizard;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.ui.ViewerPane;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.celleditor.AdapterFactoryTreeEditor;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.tm.discovery.engine.ServiceDiscoveryEngine;
import org.eclipse.tm.discovery.model.Device;
import org.eclipse.tm.discovery.model.Pair;
import org.eclipse.tm.discovery.model.Service;
import org.eclipse.tm.discovery.model.ServiceType;
import org.eclipse.tm.discovery.model.provider.ModelItemProviderAdapterFactory;
import org.eclipse.tm.discovery.protocol.IProtocol;
import org.eclipse.tm.discovery.protocol.ProtocolFactory;
import org.eclipse.tm.discovery.transport.ITransport;
import org.eclipse.tm.discovery.transport.TransportFactory;
import org.eclipse.tm.discovery.wizard.Messages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;

public class ServiceDiscoveryWizardDisplayPage
extends WizardPage {
    private TreeViewer treeViewer;
    private ViewerPane viewerPaneTree;
    private ViewerFilter filter;
    private TableViewer tableViewer;
    private ViewerPane viewerPaneTable;
    private Table table;
    private TableEditor editor;
    private ComposedAdapterFactory adapterFactory;
    private Button showAllButton;
    private final ServiceDiscoveryEngine serviceDiscoveryEngine = ServiceDiscoveryEngine.getServiceDiscoveryEngine();
    private String query = null;
    private String address = null;
    private String transportName = null;
    private String protocolName = null;
    private int timeOut = 500;
    private Service lastSelectedService = null;
    private Vector supportedServicesType = new Vector();

    public ServiceDiscoveryWizardDisplayPage(String query, String address, String transportName, String protocolName, int timeOut) {
        super("wizardPage2");
        this.setTitle(Messages.getString("ServiceDiscoveryWizardDisplayPage.WizardPageTitle"));
        this.setDescription(Messages.getString("ServiceDiscoveryWizardDisplayPage.WizardPageDescription"));
        IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.rse.ui", "subsystemConfigurations");
        IConfigurationElement[] ce = ep.getConfigurationElements();
        int i = 0;
        while (i < ce.length) {
            String id = ce[i].getAttribute("id");
            if (id != null) {
                this.supportedServicesType.add(id);
            }
            ++i;
        }
        this.query = query;
        this.address = address;
        this.transportName = transportName;
        this.protocolName = protocolName;
        this.timeOut = timeOut;
    }

    public void update(String query, String address, String transportName, String protocolName, int timeOut) {
        this.query = query;
        this.address = address;
        this.transportName = transportName;
        this.protocolName = protocolName;
        this.timeOut = timeOut;
        IProtocol protocol = null;
        ITransport transport = null;
        try {
            protocol = ProtocolFactory.getProtocol((String)protocolName);
        }
        catch (Exception exception) {
            MessageDialog.openError((Shell)new Shell(), (String)Messages.getString("ServiceDiscoveryWizardDisplayPage.ProtocolErrorTitle"), (String)(String.valueOf(Messages.getString("ServiceDiscoveryWizardDisplayPage.ProtocolErrorMessage")) + protocolName));
        }
        try {
            transport = TransportFactory.getTransport((String)transportName, (String)address, (int)timeOut);
        }
        catch (UnknownHostException unknownHostException) {
            MessageDialog.openError((Shell)new Shell(), (String)Messages.getString("ServiceDiscoveryWizardDisplayPage.TransportAddressNotFoundTitle"), (String)(String.valueOf(Messages.getString("ServiceDiscoveryWizardDisplayPage.TransportAddressNotFoundMessage")) + address));
        }
        catch (Exception exception) {
            MessageDialog.openError((Shell)new Shell(), (String)Messages.getString("ServiceDiscoveryWizardDisplayPage.TransportErrorTitle"), (String)(String.valueOf(Messages.getString("ServiceDiscoveryWizardDisplayPage.TransportErrorMessage")) + transportName));
        }
        if (protocol != null && transport != null) {
            try {
                this.serviceDiscoveryEngine.doServiceDiscovery(query, protocol, transport);
            }
            catch (Exception exception) {}
        }
    }

    public void createControl(Composite parent) {
        ArrayList<Object> factories = new ArrayList<Object>();
        factories.add(new ResourceItemProviderAdapterFactory());
        factories.add(new ModelItemProviderAdapterFactory());
        factories.add(new ReflectiveItemProviderAdapterFactory());
        this.adapterFactory = new ComposedAdapterFactory(factories);
        Composite comp = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        comp.setLayout((Layout)gridLayout);
        this.createToolBar(comp);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.verticalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        SashForm sashForm = new SashForm(comp, 0);
        sashForm.setOrientation(256);
        sashForm.setLayoutData((Object)data);
        Composite sashComposite = new Composite((Composite)sashForm, 2048);
        sashComposite.setLayout((Layout)new FillLayout());
        this.createTree(sashComposite);
        Composite innerComposite = new Composite((Composite)sashForm, 2048);
        innerComposite.setLayout((Layout)new FillLayout());
        this.createTable(innerComposite);
        this.createShowAllButton(comp);
        this.update(this.query, this.address, this.transportName, this.protocolName, this.timeOut);
        this.setPageComplete(false);
        this.setControl((Control)comp);
    }

    private void createToolBar(Composite comp) {
        ToolBar toolBar = new ToolBar(comp, 8405312);
        ToolItem refreshButton = new ToolItem(toolBar, 0);
        refreshButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ServiceDiscoveryWizardDisplayPage.this.update(ServiceDiscoveryWizardDisplayPage.this.query, ServiceDiscoveryWizardDisplayPage.this.address, ServiceDiscoveryWizardDisplayPage.this.transportName, ServiceDiscoveryWizardDisplayPage.this.protocolName, ServiceDiscoveryWizardDisplayPage.this.timeOut);
            }
        });
        refreshButton.setToolTipText(Messages.getString("ServiceDiscoveryWizardDisplayPage.RefreshButtonToolTipText"));
        refreshButton.setImage(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_REDO").createImage());
        ToolItem cleanButton = new ToolItem(toolBar, 0);
        cleanButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ServiceDiscoveryWizardDisplayPage.this.serviceDiscoveryEngine.getResource().getContents().clear();
                ServiceDiscoveryWizardDisplayPage.this.tableViewer.setInput(null);
            }
        });
        cleanButton.setToolTipText(Messages.getString("ServiceDiscoveryWizardDisplayPage.ClearButtonToolTipText"));
        cleanButton.setImage(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE").createImage());
    }

    private void createTree(Composite comp) {
        this.viewerPaneTree = new ViewerPane(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart()){

            public Viewer createViewer(Composite composite) {
                Tree tree = new Tree(composite, 32);
                ContainerCheckedTreeViewer treeViewer = new ContainerCheckedTreeViewer(tree);
                return treeViewer;
            }

            public void requestActivation() {
                super.requestActivation();
            }
        };
        this.viewerPaneTree.createControl(comp);
        this.treeViewer = (TreeViewer)this.viewerPaneTree.getViewer();
        this.treeViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory));
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory));
        this.viewerPaneTree.setTitle(Messages.getString("ServiceDiscoveryWizardDisplayPage.ServicesTreeTitle"), null);
        this.treeViewer.setInput((Object)this.serviceDiscoveryEngine.getResource());
        new AdapterFactoryTreeEditor(this.treeViewer.getTree(), (AdapterFactory)this.adapterFactory);
        ((ContainerCheckedTreeViewer)this.viewerPaneTree.getViewer()).addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                EObject obj;
                if (!event.getSelection().isEmpty() && (obj = (EObject)((IStructuredSelection)event.getSelection()).getFirstElement()) instanceof Service) {
                    ServiceDiscoveryWizardDisplayPage.this.tableViewer.setInput((Object)obj);
                    ServiceDiscoveryWizardDisplayPage.this.lastSelectedService = (Service)obj;
                }
            }
        });
        ((ContainerCheckedTreeViewer)this.viewerPaneTree.getViewer()).addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ContainerCheckedTreeViewer treeViewer = (ContainerCheckedTreeViewer)event.getSource();
                if (treeViewer.getCheckedElements().length > 0) {
                    ServiceDiscoveryWizardDisplayPage.this.setPageComplete(true);
                } else {
                    ServiceDiscoveryWizardDisplayPage.this.setPageComplete(false);
                }
            }
        });
        this.filter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                boolean supported = true;
                if (element instanceof ServiceType) {
                    String serviceTypeName = ((ServiceType)element).getName();
                    if (!ServiceDiscoveryWizardDisplayPage.this.supportedServicesType.contains(serviceTypeName)) {
                        supported = false;
                    }
                }
                return supported;
            }
        };
        ((ContainerCheckedTreeViewer)this.viewerPaneTree.getViewer()).addFilter(this.filter);
    }

    private void createTable(Composite comp) {
        this.viewerPaneTable = new ViewerPane(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart()){

            public Viewer createViewer(Composite composite) {
                return new TableViewer(composite);
            }
        };
        this.viewerPaneTable.createControl(comp);
        this.tableViewer = (TableViewer)this.viewerPaneTable.getViewer();
        this.viewerPaneTable.setTitle(Messages.getString("ServiceDiscoveryWizardDisplayPage.PropertiesTableTitle"), null);
        this.table = this.tableViewer.getTable();
        TableLayout layout = new TableLayout();
        this.table.setLayout((Layout)layout);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        TableColumn objectColumn = new TableColumn(this.table, 0);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(3, 100, true));
        objectColumn.setText(Messages.getString("ServiceDiscoveryWizardDisplayPage.KeyColumnLabel"));
        objectColumn.setResizable(true);
        TableColumn selfColumn = new TableColumn(this.table, 0);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(2, 100, true));
        selfColumn.setText(Messages.getString("ServiceDiscoveryWizardDisplayPage.ValueColumnLabel"));
        selfColumn.setResizable(true);
        this.tableViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory));
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory));
        this.editor = new TableEditor(this.table);
        this.editor.horizontalAlignment = 16384;
        this.editor.grabHorizontal = true;
        this.table.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                Rectangle clientArea = ServiceDiscoveryWizardDisplayPage.this.table.getClientArea();
                Point pt = new Point(event.x, event.y);
                int index = ServiceDiscoveryWizardDisplayPage.this.table.getTopIndex();
                while (index < ServiceDiscoveryWizardDisplayPage.this.table.getItemCount()) {
                    boolean visible = false;
                    TableItem item = ServiceDiscoveryWizardDisplayPage.this.table.getItem(index);
                    int i = ServiceDiscoveryWizardDisplayPage.this.table.getColumnCount() - 1;
                    while (i < ServiceDiscoveryWizardDisplayPage.this.table.getColumnCount()) {
                        Rectangle rect = item.getBounds(i);
                        if (rect.contains(pt)) {
                            int column = i;
                            Text text = new Text((Composite)ServiceDiscoveryWizardDisplayPage.this.table, 0);
                            Listener textListener = new Listener(this, item, column, text){
                                final /* synthetic */ 8 this$1;
                                private final /* synthetic */ TableItem val$item;
                                private final /* synthetic */ int val$column;
                                private final /* synthetic */ Text val$text;
                                {
                                    this.this$1 = var1_1;
                                    this.val$item = tableItem;
                                    this.val$column = n;
                                    this.val$text = text;
                                }

                                public void handleEvent(Event e) {
                                    switch (e.type) {
                                        case 16: {
                                            this.val$item.setText(this.val$column, this.val$text.getText());
                                            this.val$text.dispose();
                                            ServiceDiscoveryWizardDisplayPage.access$10(8.access$0(this.this$1), this.val$item.getText(0), this.val$item.getText(1));
                                            break;
                                        }
                                        case 31: {
                                            switch (e.detail) {
                                                case 4: {
                                                    this.val$item.setText(this.val$column, this.val$text.getText());
                                                    ServiceDiscoveryWizardDisplayPage.access$10(8.access$0(this.this$1), this.val$item.getText(0), this.val$item.getText(1));
                                                }
                                                case 2: {
                                                    this.val$text.dispose();
                                                    e.doit = false;
                                                }
                                            }
                                        }
                                    }
                                }
                            };
                            text.addListener(16, textListener);
                            text.addListener(31, textListener);
                            ServiceDiscoveryWizardDisplayPage.this.editor.setEditor((Control)text, item, i);
                            text.setText(item.getText(i));
                            text.selectAll();
                            text.setFocus();
                            return;
                        }
                        if (!visible && rect.intersects(clientArea)) {
                            visible = true;
                        }
                        ++i;
                    }
                    if (!visible) {
                        return;
                    }
                    ++index;
                }
            }

            static /* synthetic */ ServiceDiscoveryWizardDisplayPage access$0(8 var0) {
                return var0.ServiceDiscoveryWizardDisplayPage.this;
            }
        });
    }

    private void createShowAllButton(Composite comp) {
        this.showAllButton = new Button(comp, 32);
        this.showAllButton.setText(Messages.getString("ServiceDiscoveryWizardDisplayPage.ShowAllServicesButtonText"));
        this.showAllButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                Object src = e.getSource();
                if (((Button)src).getSelection()) {
                    ((ContainerCheckedTreeViewer)ServiceDiscoveryWizardDisplayPage.this.viewerPaneTree.getViewer()).removeFilter(ServiceDiscoveryWizardDisplayPage.this.filter);
                } else {
                    ((ContainerCheckedTreeViewer)ServiceDiscoveryWizardDisplayPage.this.viewerPaneTree.getViewer()).addFilter(ServiceDiscoveryWizardDisplayPage.this.filter);
                }
            }
        });
    }

    private void updatePairs(String key, String value) {
        Iterator pairsIterator = this.lastSelectedService.getPair().iterator();
        while (pairsIterator.hasNext()) {
            Pair pair = (Pair)pairsIterator.next();
            if (!pair.getKey().equals(key)) continue;
            pair.setValue(value);
        }
    }

    public Vector getSelectedServices(String address) {
        Vector<Service> services = new Vector<Service>();
        Object[] checkedElements = ((ContainerCheckedTreeViewer)this.viewerPaneTree.getViewer()).getCheckedElements();
        int i = 0;
        while (i < checkedElements.length) {
            Service service;
            if (checkedElements[i] instanceof Service && ((Device)(service = (Service)checkedElements[i]).eContainer().eContainer()).getAddress().equalsIgnoreCase(address)) {
                services.add(service);
            }
            ++i;
        }
        return services;
    }

    public String[] getAddresses() {
        Vector<String> addressVector = new Vector<String>();
        Object[] checkedElements = ((ContainerCheckedTreeViewer)this.viewerPaneTree.getViewer()).getCheckedElements();
        int i = 0;
        while (i < checkedElements.length) {
            if (checkedElements[i] instanceof Device) {
                addressVector.add(((Device)checkedElements[i]).getAddress());
            }
            ++i;
        }
        Object[] addresses = new String[addressVector.size()];
        addressVector.copyInto(addresses);
        return addresses;
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    static /* synthetic */ void access$10(ServiceDiscoveryWizardDisplayPage serviceDiscoveryWizardDisplayPage, String string, String string2) {
        serviceDiscoveryWizardDisplayPage.updatePairs(string, string2);
    }
}

