/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.services.dstore.shells;

import java.io.File;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.rse.dstore.universal.miners.CommandMiner;
import org.eclipse.rse.dstore.universal.miners.EnvironmentMiner;

public class DStoreShellThread {
    protected DataElement _runCmdDescriptor;
    protected DataElement _runShellDescriptor;
    protected DataElement _setEnvironmentDescriptor;
    protected DataElement _sendInputDescriptor;
    protected DataElement _cmdMinerElement;
    protected DataElement _envMinerElement;
    private String _encoding;
    private String _cwd;
    private String[] _envVars;
    private DataStore _dataStore;
    private DataElement _status;
    private String _invocation;

    public DStoreShellThread(DataStore dataStore, String cwd, String invocation, String encoding, String[] envVars) {
        this._dataStore = dataStore;
        this._encoding = encoding;
        this._cwd = cwd;
        this._envVars = envVars;
        this._invocation = invocation;
        this.init();
    }

    protected void init() {
        DataElement contextDir = this._dataStore.createObject(null, "directory", new File(this._cwd).getName(), this._cwd);
        this._dataStore.setObject(contextDir);
        this.setRemoteEnvironment(contextDir);
        if (this._invocation == null || this._invocation.equals(">")) {
            this.sendShellToMiner(contextDir);
        } else {
            this.sendCommandToMiner(contextDir, this._invocation);
        }
    }

    public DataElement getStatus() {
        return this._status;
    }

    protected void sendShellToMiner(DataElement contextDir) {
        DataElement cmdD = this.getRunShellDescriptor(contextDir);
        if (cmdD != null) {
            String encoding = this._encoding;
            if (encoding != null && encoding.length() > 0) {
                DataElement arg = this._dataStore.createObject(null, "shell.encoding", encoding);
                this._status = this._dataStore.command(cmdD, arg, contextDir);
            } else {
                this._status = this._dataStore.command(cmdD, contextDir);
            }
        }
    }

    protected void sendCommandToMiner(DataElement contextDir, String invocation) {
        DataElement cmdD = this.getRunCommandDescriptor(contextDir);
        if (cmdD != null) {
            if (invocation != null && invocation.length() > 0) {
                DataElement arg = this._dataStore.createObject(null, "command", invocation);
                this._status = this._dataStore.command(cmdD, arg, contextDir);
            } else {
                this._status = this._dataStore.command(cmdD, contextDir);
            }
        }
    }

    public void setRemoteEnvironment(DataElement theObject) {
        if (this._envVars != null && this._envVars.length > 0) {
            DataElement theEnvironment = this._dataStore.createObject(null, "Environment Variable", theObject.getName());
            int i = 0;
            while (i < this._envVars.length) {
                String var = this._envVars[i];
                this._dataStore.createObject(theEnvironment, "Environment Variable", var, var);
                ++i;
            }
            theEnvironment.setAttribute(2, theObject.getId());
            DataElement contObj = this._dataStore.findObjectDescriptor("Container Object");
            DataElement setD = this.getSetEnvironmentDescriptor(contObj);
            if (setD != null) {
                this._dataStore.command(setD, theEnvironment, theObject, false);
            }
        }
    }

    protected DataElement getRunCommandDescriptor(DataElement remoteObject) {
        if (this._runCmdDescriptor == null || this._dataStore != remoteObject.getDataStore()) {
            this._runCmdDescriptor = this._dataStore.localDescriptorQuery(remoteObject.getDescriptor(), this.getRunCommandId());
        }
        return this._runCmdDescriptor;
    }

    protected DataElement getRunShellDescriptor(DataElement remoteObject) {
        if (this._runShellDescriptor == null || this._dataStore != remoteObject.getDataStore()) {
            this._runShellDescriptor = this._dataStore.localDescriptorQuery(remoteObject.getDescriptor(), this.getRunShellId(), 2);
        }
        return this._runShellDescriptor;
    }

    protected DataElement getSetEnvironmentDescriptor(DataElement remoteObject) {
        if (this._setEnvironmentDescriptor == null || this._dataStore != remoteObject.getDataStore()) {
            this._setEnvironmentDescriptor = this._dataStore.localDescriptorQuery(remoteObject.getDescriptor(), this.getSetEnvironmentId(), 2);
        }
        return this._setEnvironmentDescriptor;
    }

    protected DataElement getSendInputDescriptor(DataElement remoteObject) {
        if (this._sendInputDescriptor == null || this._dataStore != remoteObject.getDataStore()) {
            this._sendInputDescriptor = this._dataStore.findCommandDescriptor("C_SEND_INPUT");
        }
        return this._sendInputDescriptor;
    }

    protected DataElement getCmdSystemMinerElement() {
        if (this._cmdMinerElement == null || this._cmdMinerElement.getDataStore() != this._dataStore) {
            this._cmdMinerElement = this._dataStore.findMinerInformation(this.getCmdSystemMinerId());
        }
        return this._cmdMinerElement;
    }

    protected DataElement getEnvSystemMinerElement() {
        if (this._envMinerElement == null || this._envMinerElement.getDataStore() != this._dataStore) {
            this._envMinerElement = this._dataStore.findMinerInformation(this.getEnvSystemMinerId());
        }
        return this._envMinerElement;
    }

    protected String getCmdSystemMinerId() {
        return CommandMiner.MINER_ID;
    }

    protected String getEnvSystemMinerId() {
        return EnvironmentMiner.MINER_ID;
    }

    protected String getRunShellId() {
        return "C_SHELL";
    }

    protected String getRunCommandId() {
        return "C_COMMAND";
    }

    protected String getSetEnvironmentId() {
        return "C_SET_ENVIRONMENT_VARIABLES";
    }

    public void writeToShell(String command) {
        DataElement commandElement = this._status.getParent();
        DataStore dataStore = commandElement.getDataStore();
        if (command.equals("") || command.equals("#break")) {
            DataElement commandDescriptor;
            String cmd = command;
            if (cmd.equals("")) {
                cmd = "#enter";
            }
            if ((commandDescriptor = this.getSendInputDescriptor(commandElement)) != null) {
                DataElement in = dataStore.createObject(null, "input", cmd);
                dataStore.command(commandDescriptor, in, commandElement);
            }
        } else {
            String[] tokens = command.split("\n\r");
            int i = 0;
            while (i < tokens.length) {
                DataElement commandDescriptor;
                String cmd = tokens[i];
                if (cmd != null && (commandDescriptor = this.getSendInputDescriptor(commandElement)) != null) {
                    DataElement in = dataStore.createObject(null, "input", cmd);
                    dataStore.command(commandDescriptor, in, commandElement);
                }
                ++i;
            }
        }
    }
}

