/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.subsystems.files.core.subsystems;

import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;

public class RemoteFileSchedulingRule
implements ISchedulingRule {
    private IRemoteFile _file;

    public RemoteFileSchedulingRule(IRemoteFile file) {
        this._file = file;
    }

    public boolean contains(ISchedulingRule rule) {
        if (this == rule) {
            return true;
        }
        if (rule instanceof MultiRule) {
            MultiRule multi = (MultiRule)rule;
            ISchedulingRule[] children = multi.getChildren();
            int i = 0;
            while (i < children.length) {
                if (!this.contains(children[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (!(rule instanceof RemoteFileSchedulingRule)) {
            return false;
        }
        return this.getHostName().equals(((RemoteFileSchedulingRule)rule).getHostName()) && ((RemoteFileSchedulingRule)rule).getAbsolutePath().startsWith(this.getAbsolutePath());
    }

    public boolean isConflicting(ISchedulingRule rule) {
        if (!(rule instanceof RemoteFileSchedulingRule)) {
            return false;
        }
        String otherPath = ((RemoteFileSchedulingRule)rule).getAbsolutePath();
        String path = this.getAbsolutePath();
        String otherHost = ((RemoteFileSchedulingRule)rule).getHostName();
        return this.getHostName().equals(otherHost) && path.startsWith(otherPath) || otherPath.startsWith(path);
    }

    public String getAbsolutePath() {
        return this._file.getAbsolutePath();
    }

    public String getHostName() {
        return this._file.getSystemConnection().getHostName();
    }
}

