/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.tests.framework.scripting;

import java.text.MessageFormat;

public class ScriptParserMessage {
    public static final int INFO = 0;
    public static final int WARNING = 1;
    public static final int ERROR = 2;
    public static final int SEVERE = 3;
    private int severity = 0;
    private String text = "";
    private Object[] data = new Object[0];
    private int lineNumber;

    public ScriptParserMessage(int lineNumber, int severity, String text) {
        if (severity < 0 || severity > 3) {
            throw new IllegalArgumentException();
        }
        this.lineNumber = lineNumber;
        this.severity = severity;
        this.text = text;
    }

    public ScriptParserMessage(int lineNumber, int severity, String text, Object[] data) {
        this.lineNumber = lineNumber;
        this.severity = severity;
        this.text = text;
        this.bind(data);
    }

    public int getSeverity() {
        return this.severity;
    }

    public String getText() {
        return this.text;
    }

    public Object[] getData() {
        Object[] result = new Object[this.data.length];
        System.arraycopy(result, 0, this.data, 0, this.data.length);
        return result;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public ScriptParserMessage bind(Object[] data) {
        this.data = new Object[data.length];
        System.arraycopy(data, 0, this.data, 0, data.length);
        return this;
    }

    public String toString() {
        String result = MessageFormat.format(this.text, this.data);
        return result;
    }
}

