/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.subsystems;

import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.PasswordPersistenceManager;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.SystemSignonInformation;
import org.eclipse.rse.core.subsystems.AbstractCredentialsProvider;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.ICredentials;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.logging.Logger;
import org.eclipse.rse.logging.LoggerFactory;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.dialogs.ICredentialsValidator;
import org.eclipse.rse.ui.dialogs.ISystemPasswordPromptDialog;
import org.eclipse.rse.ui.dialogs.SystemChangePasswordDialog;
import org.eclipse.rse.ui.dialogs.SystemPasswordPromptDialog;
import org.eclipse.rse.ui.messages.SystemMessageDialog;
import org.eclipse.rse.ui.subsystems.ISubSystemConfigurationAdapter;
import org.eclipse.rse.ui.validators.ISystemValidator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class StandardCredentialsProvider
extends AbstractCredentialsProvider {
    private String userId = null;
    private String password = null;
    private boolean savePassword = false;
    private boolean saveUserId = false;
    private boolean acquiring = false;
    static /* synthetic */ Class class$0;

    public StandardCredentialsProvider(IConnectorService connectorService) {
        super(connectorService);
    }

    public final void acquireCredentials(boolean reacquire) throws InterruptedException {
        PasswordPersistenceManager ppm;
        SystemSignonInformation savedSignonInformation;
        if (this.isSuppressed()) {
            throw new InterruptedException();
        }
        ISubSystem subsystem = this.getPrimarySubSystem();
        IHost host = subsystem.getHost();
        String hostName = host.getHostName();
        IRSESystemType systemType = host.getSystemType();
        this.savePassword = false;
        if (this.supportsUserId()) {
            boolean sameHost = hostName.equalsIgnoreCase(this.getConnectorService().getHostName());
            if (!sameHost) {
                this.clearCredentials();
            }
            this.getUserId();
        }
        if (this.supportsPassword() && this.password == null && (savedSignonInformation = (ppm = PasswordPersistenceManager.getInstance()).find(systemType, hostName, this.userId)) != null) {
            this.password = savedSignonInformation.getPassword();
            this.savePassword = true;
        }
        ICredentialsValidator validator = this.getSignonValidator();
        boolean signonValid = true;
        if (validator != null) {
            Shell shell;
            SystemMessage m = validator.validate(this.getCredentials());
            boolean bl = signonValid = m == null;
            if (!signonValid && (shell = this.getShell()) != null) {
                SystemMessage msg = RSEUIPlugin.getPluginMessage("RSEC1004");
                msg.makeSubstitution((Object)this.userId, (Object)this.getConnectorService().getHostName());
                SystemMessageDialog dialog = new SystemMessageDialog(shell, msg);
                dialog.open();
            }
        }
        if (this.supportsPassword() || this.supportsUserId()) {
            boolean userIdNeeded;
            boolean passwordNeeded = this.supportsPassword() && this.password == null;
            boolean bl = userIdNeeded = this.supportsUserId() && this.userId == null;
            if (passwordNeeded || userIdNeeded || reacquire) {
                this.promptForCredentials();
                this.acquiring = true;
                if (this.savePassword) {
                    this.getConnectorService().savePassword();
                } else {
                    this.getConnectorService().removePassword();
                }
                if (this.saveUserId) {
                    this.getConnectorService().saveUserId();
                }
                this.acquiring = false;
            }
        }
    }

    public final void clearCredentials() {
        if (!this.acquiring) {
            this.password = null;
            this.userId = null;
        }
    }

    public final void clearPassword() {
        if (!this.acquiring) {
            this.password = null;
        }
    }

    public final ICredentials getCredentials() {
        IHost host = this.getConnectorService().getHost();
        String hostName = host.getHostName();
        IRSESystemType systemType = host.getSystemType();
        SystemSignonInformation result = new SystemSignonInformation(hostName, this.userId, this.password, systemType);
        return result;
    }

    public final String getUserId() {
        if (this.supportsUserId() && this.userId == null) {
            this.userId = this.getSubSystemUserId();
        }
        return this.userId;
    }

    public final void repairCredentials(SystemMessage prompt) throws InterruptedException {
        this.promptForNewPassword(prompt);
    }

    public final void setPassword(String password) {
        this.password = password;
    }

    public final void setPassword(String matchingUserId, String password, boolean persist) {
        if (this.getPrimarySubSystem().forceUserIdToUpperCase()) {
            matchingUserId = matchingUserId.toUpperCase();
        }
        IConnectorService cs = this.getConnectorService();
        IRSESystemType systemType = cs.getHost().getSystemType();
        String hostName = cs.getHostName();
        SystemSignonInformation signonInformation = new SystemSignonInformation(hostName, matchingUserId, password, systemType);
        this.setSignonInformation(signonInformation);
        if (persist) {
            PasswordPersistenceManager.getInstance().add(signonInformation, true, true);
        } else {
            PasswordPersistenceManager.getInstance().remove(systemType, hostName, this.userId);
        }
    }

    public final void setUserId(String newId) {
        if (this.userId == null || !this.userId.equals(newId)) {
            this.userId = newId;
        }
    }

    protected ISystemPasswordPromptDialog getPasswordPromptDialog(Shell shell) {
        SystemPasswordPromptDialog dlg = new SystemPasswordPromptDialog(shell, this.requiresUserId(), this.requiresPassword());
        return dlg;
    }

    protected ICredentialsValidator getSignonValidator() {
        return null;
    }

    private boolean forcePasswordToUpperCase() {
        return this.getPrimarySubSystem().forceUserIdToUpperCase();
    }

    private ISystemValidator getPasswordValidator() {
        ISubSystemConfiguration subsystemConfiguration = this.getPrimarySubSystem().getSubSystemConfiguration();
        IAdapterManager iAdapterManager = Platform.getAdapterManager();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.ui.subsystems.ISubSystemConfigurationAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ISubSystemConfigurationAdapter adapter = (ISubSystemConfigurationAdapter)iAdapterManager.getAdapter((Object)subsystemConfiguration, (Class)clazz);
        return adapter.getPasswordValidator(subsystemConfiguration);
    }

    private ISubSystem getPrimarySubSystem() {
        return this.getConnectorService().getPrimarySubSystem();
    }

    private Shell getShell() {
        IWorkbenchWindow window;
        Shell shell = null;
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null && (window = workbench.getActiveWorkbenchWindow()) != null) {
            shell = window.getShell();
        }
        return shell;
    }

    private String getSubSystemUserId() {
        ISubSystem ss = this.getPrimarySubSystem();
        String result = ss.getUserId();
        return result;
    }

    private ISystemValidator getUserIdValidator() {
        ISubSystemConfiguration subsystemConfiguration = this.getPrimarySubSystem().getSubSystemConfiguration();
        IAdapterManager iAdapterManager = Platform.getAdapterManager();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.ui.subsystems.ISubSystemConfigurationAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ISubSystemConfigurationAdapter adapter = (ISubSystemConfigurationAdapter)iAdapterManager.getAdapter((Object)subsystemConfiguration, (Class)clazz);
        ISystemValidator validator = adapter.getUserIdValidator(subsystemConfiguration);
        return validator;
    }

    private void logException(Throwable t) {
        Logger log = LoggerFactory.getLogger((Plugin)RSEUIPlugin.getDefault());
        log.logError("Unexpected exception", t);
    }

    private void promptForCredentials() throws InterruptedException {
        PromptForCredentials runnable = new PromptForCredentials();
        Display.getDefault().syncExec((Runnable)runnable);
        if (runnable.isCanceled()) {
            throw new InterruptedException();
        }
    }

    private void promptForNewPassword(SystemMessage prompt) throws InterruptedException {
        PromptForNewPassword runnable = new PromptForNewPassword(prompt);
        Display.getDefault().syncExec((Runnable)runnable);
        if (runnable.isCancelled()) {
            throw new InterruptedException();
        }
    }

    private void setSignonInformation(SystemSignonInformation signonInfo) {
        this.password = signonInfo.getPassword();
        this.userId = signonInfo.getUserId();
    }

    private class PromptForCredentials
    implements Runnable {
        private boolean canceled = false;

        private PromptForCredentials() {
        }

        public boolean isCanceled() {
            return this.canceled;
        }

        public void run() {
            Shell shell = StandardCredentialsProvider.this.getShell();
            if (shell != null) {
                ISystemPasswordPromptDialog dialog = StandardCredentialsProvider.this.getPasswordPromptDialog(shell);
                dialog.setSystemInput(StandardCredentialsProvider.this.getConnectorService());
                dialog.setForceToUpperCase(StandardCredentialsProvider.this.forcePasswordToUpperCase());
                dialog.setSignonValidator(StandardCredentialsProvider.this.getSignonValidator());
                if (StandardCredentialsProvider.this.supportsUserId()) {
                    dialog.setUserIdValidator(StandardCredentialsProvider.this.getUserIdValidator());
                }
                if (StandardCredentialsProvider.this.supportsPassword()) {
                    dialog.setSavePassword(StandardCredentialsProvider.this.savePassword);
                    dialog.setPassword(StandardCredentialsProvider.this.password);
                    dialog.setPasswordValidator(StandardCredentialsProvider.this.getPasswordValidator());
                }
                try {
                    dialog.open();
                }
                catch (Exception e) {
                    StandardCredentialsProvider.this.logException(e);
                }
                this.canceled = dialog.wasCancelled();
                if (!this.canceled) {
                    StandardCredentialsProvider.this.userId = dialog.getUserId();
                    StandardCredentialsProvider.this.password = dialog.getPassword();
                    StandardCredentialsProvider.this.saveUserId = dialog.getIsUserIdChangePermanent();
                    StandardCredentialsProvider.this.savePassword = dialog.getIsSavePassword();
                }
            } else {
                this.canceled = true;
            }
        }
    }

    private class PromptForNewPassword
    implements Runnable {
        private SystemMessage message;
        private boolean canceled = false;

        public PromptForNewPassword(SystemMessage message) {
            this.message = message;
        }

        public boolean isCancelled() {
            return this.canceled;
        }

        public void run() {
            Shell shell = StandardCredentialsProvider.this.getShell();
            if (shell != null) {
                SystemChangePasswordDialog dlg = new SystemChangePasswordDialog(shell, StandardCredentialsProvider.this.getConnectorService().getHostName(), StandardCredentialsProvider.this.getUserId(), this.message);
                dlg.setSavePassword(StandardCredentialsProvider.this.savePassword);
                dlg.open();
                this.canceled = dlg.wasCancelled();
                if (!this.canceled) {
                    StandardCredentialsProvider.this.password = dlg.getNewPassword();
                    StandardCredentialsProvider.this.savePassword = dlg.getIsSavePassword();
                }
            } else {
                this.canceled = true;
            }
        }
    }
}

