/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.efs.ui;

import java.net.URI;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.rse.core.filters.ISystemFilterReference;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.files.ui.dialogs.SystemRemoteFolderDialog;
import org.eclipse.rse.internal.efs.RSEFileStoreImpl;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ide.fileSystem.FileSystemContributor;

public class RSEFileSystemContributor
extends FileSystemContributor {
    public URI browseFileSystem(String initialPath, Shell shell) {
        SystemRemoteFolderDialog dlg = new SystemRemoteFolderDialog(shell, "Select Folder");
        if (!initialPath.equals("")) {
            try {
                URI uri = new URI(initialPath);
                IHost host = RSEFileStoreImpl.getConnectionFor((String)uri.getHost(), null);
                IRemoteFileSubSystem fs = RSEFileStoreImpl.getRemoteFileSubSystem((IHost)host);
                dlg.setInputObject((Object)fs.getRemoteFileObject(uri.getPath(), (IProgressMonitor)new NullProgressMonitor()));
            }
            catch (Exception exception) {}
        }
        dlg.setNeedsProgressMonitor(true);
        if (dlg.open() == 0) {
            ISubSystem targetSubSystem;
            ISubSystemConfiguration factory;
            Object selected = dlg.getSelectedObject();
            if (selected instanceof ISystemFilterReference && (factory = (targetSubSystem = ((ISystemFilterReference)selected).getSubSystem()).getSubSystemConfiguration()).supportsDropInFilters()) {
                selected = targetSubSystem.getTargetForFilter((ISystemFilterReference)selected);
            }
            IRemoteFile file = (IRemoteFile)selected;
            String path = file.getAbsolutePath();
            IHost host = dlg.getSelectedConnection();
            String hostName = host.getHostName();
            try {
                return new URI("rse", hostName, path, null);
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public URI getURI(String string) {
        try {
            return new URI(string);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

