/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.services.local.shells;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.rse.internal.services.local.shells.LocalShellOutputReader;
import org.eclipse.rse.internal.services.local.shells.LocalShellThread;
import org.eclipse.rse.services.shells.AbstractHostShell;
import org.eclipse.rse.services.shells.IHostShell;
import org.eclipse.rse.services.shells.IHostShellOutputReader;

public class LocalHostShell
extends AbstractHostShell
implements IHostShell {
    private LocalShellThread _shellThread;
    private LocalShellOutputReader _stdoutHandler;
    private LocalShellOutputReader _stderrHandler;

    public LocalHostShell(String initialWorkingDirectory, String invocation, String encoding, String[] environment) {
        this._shellThread = new LocalShellThread(initialWorkingDirectory, invocation, encoding, environment);
        this._stdoutHandler = new LocalShellOutputReader(this, this._shellThread.getOutputStream(), false);
        this._stderrHandler = new LocalShellOutputReader(this, this._shellThread.getErrorStream(), true);
    }

    protected void run(IProgressMonitor monitor) {
        this._shellThread.start();
    }

    public boolean isActive() {
        if (this._stdoutHandler.isFinished()) {
            if (this._shellThread.isAlive()) {
                this._shellThread.stopThread();
            }
            return false;
        }
        return true;
    }

    public void writeToShell(String command) {
        this._shellThread.sendInput(command);
    }

    public IHostShellOutputReader getStandardOutputReader() {
        return this._stdoutHandler;
    }

    public IHostShellOutputReader getStandardErrorReader() {
        return this._stderrHandler;
    }

    public void exit() {
        this.writeToShell("exit");
    }
}

