/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.ui.filters.dialogs;

import org.eclipse.jface.wizard.IWizard;
import org.eclipse.rse.core.filters.ISystemFilterPool;
import org.eclipse.rse.core.filters.ISystemFilterPoolSelectionValidator;
import org.eclipse.rse.core.filters.ISystemFilterPoolWrapper;
import org.eclipse.rse.core.filters.ISystemFilterPoolWrapperInformation;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.filters.dialogs.ISystemNewFilterWizardConfigurator;
import org.eclipse.rse.ui.filters.dialogs.SystemNewFilterWizard;
import org.eclipse.rse.ui.validators.ISystemValidator;
import org.eclipse.rse.ui.wizards.AbstractSystemWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class SystemNewFilterWizardNamePage
extends AbstractSystemWizardPage
implements SelectionListener {
    protected Text nameText;
    protected Button uniqueCB;
    protected Label poolVerbiage;
    protected Label poolComboLabel;
    protected Combo poolWrapperCombo;
    protected Combo poolCombo;
    protected SystemMessage errorMessage;
    protected String inputFilterName;
    protected boolean contentsCreated;
    protected boolean userEditedName;
    protected boolean ignoreChanges;
    protected ISystemValidator nameValidator;
    protected ISystemValidator[] nameValidators;
    protected ISystemFilterPoolSelectionValidator filterPoolSelectionValidator;
    protected ISystemFilterPool[] poolsToSelectFrom = null;
    protected ISystemFilterPoolWrapper[] poolWrappers = null;
    protected ISystemFilterPoolWrapperInformation poolWrapperInformation;
    protected ISystemFilterPool parentPool = null;
    private ISystemNewFilterWizardConfigurator configurator;

    public SystemNewFilterWizardNamePage(SystemNewFilterWizard wizard, ISystemFilterPool parentPool, ISystemNewFilterWizardConfigurator data) {
        super((IWizard)wizard, "SetNewFilterName", data.getPage2Title(), data.getPage2Description());
        this.parentPool = parentPool;
        this.configurator = data;
        this.setHelp(data.getPage2HelpID());
    }

    public void setFilterName(String filterName) {
        this.inputFilterName = filterName;
        if (this.nameText != null) {
            this.nameText.setText(this.inputFilterName);
        }
    }

    public void setFilterNameValidator(ISystemValidator nameValidator) {
        this.nameValidator = nameValidator;
    }

    public void setAllowFilterPoolSelection(ISystemFilterPool[] poolsToSelectFrom, ISystemValidator[] nameValidators) {
        this.poolsToSelectFrom = poolsToSelectFrom;
        this.nameValidators = nameValidators;
        if (poolsToSelectFrom != null && poolsToSelectFrom.length > 0 && this.parentPool == null) {
            this.parentPool = poolsToSelectFrom[0];
        }
    }

    public void setAllowFilterPoolSelection(ISystemFilterPoolWrapperInformation poolWrappersToSelectFrom, ISystemValidator[] nameValidators) {
        this.poolWrapperInformation = poolWrappersToSelectFrom;
        this.nameValidators = nameValidators;
        if (this.parentPool == null) {
            this.parentPool = poolWrappersToSelectFrom.getPreSelectWrapper().getSystemFilterPool();
        }
    }

    public void setFilterPoolSelectionValidator(ISystemFilterPoolSelectionValidator validator) {
        this.filterPoolSelectionValidator = validator;
    }

    public Control createContents(Composite parent) {
        int maxNameLength;
        String[] poolNames;
        int nbrColumns = 2;
        Composite composite_prompts = SystemWidgetHelpers.createComposite(parent, nbrColumns);
        SystemWidgetHelpers.createVerbiage(composite_prompts, this.configurator.getPage2NameVerbiage(), nbrColumns, false, 200);
        this.nameText = SystemWidgetHelpers.createLabeledTextField(composite_prompts, null, this.configurator.getPage2NamePromptLabel(), this.configurator.getPage2NamePromptTooltip());
        this.addSeparatorLine(composite_prompts, nbrColumns);
        this.addFillerLine(composite_prompts, nbrColumns);
        if (this.poolsToSelectFrom != null || this.poolWrapperInformation != null) {
            this.uniqueCB = SystemWidgetHelpers.createCheckBox(composite_prompts, nbrColumns, this.configurator.getPage2UniqueToConnectionLabel(), null);
            this.uniqueCB.setToolTipText(this.configurator.getPage2UniqueToConnectionToolTip());
            this.uniqueCB.addSelectionListener((SelectionListener)this);
        }
        this.addFillerLine(composite_prompts, nbrColumns);
        if (this.poolsToSelectFrom != null) {
            this.poolVerbiage = SystemWidgetHelpers.createVerbiage(composite_prompts, this.configurator.getPage2PoolVerbiage(), nbrColumns, false, 200);
            this.poolVerbiage.setToolTipText(this.configurator.getPage2PoolVerbiageTip());
            this.poolCombo = SystemWidgetHelpers.createLabeledReadonlyCombo(composite_prompts, null, this.configurator.getPage2PoolPromptLabel(), this.configurator.getPage2PoolPromptTooltip());
            this.poolComboLabel = SystemWidgetHelpers.getLastLabel();
            poolNames = new String[this.poolsToSelectFrom.length];
            int filterPoolSelectionIndex = 0;
            int idx = 0;
            while (idx < poolNames.length) {
                ISystemFilterPool pool = this.poolsToSelectFrom[idx];
                if (pool == this.parentPool) {
                    filterPoolSelectionIndex = idx;
                }
                poolNames[idx] = String.valueOf(pool.getSystemFilterPoolManager().getName()) + "." + pool.getName();
                ++idx;
            }
            if (this.nameValidator == null && this.nameValidators != null) {
                this.nameValidator = this.nameValidators[filterPoolSelectionIndex];
            }
            this.poolCombo.setItems(poolNames);
            this.poolCombo.select(filterPoolSelectionIndex);
            this.poolCombo.addSelectionListener((SelectionListener)this);
            if (this.uniqueCB != null && this.uniqueCB.getSelection()) {
                this.poolVerbiage.setEnabled(false);
                this.poolComboLabel.setEnabled(false);
                this.poolCombo.setEnabled(false);
            }
        } else if (this.poolWrapperInformation != null) {
            this.poolVerbiage = SystemWidgetHelpers.createVerbiage(composite_prompts, this.poolWrapperInformation.getVerbiageLabel(), nbrColumns, false, 200);
            this.poolWrapperCombo = SystemWidgetHelpers.createLabeledReadonlyCombo(composite_prompts, null, this.poolWrapperInformation.getPromptLabel(), this.poolWrapperInformation.getPromptTooltip());
            this.poolComboLabel = SystemWidgetHelpers.getLastLabel();
            this.poolWrappers = this.poolWrapperInformation.getWrappers();
            poolNames = new String[this.poolWrappers.length];
            int filterPoolSelectionIndex = 0;
            int idx = 0;
            while (idx < poolNames.length) {
                if (this.poolWrapperInformation.getPreSelectWrapper() == this.poolWrappers[idx]) {
                    filterPoolSelectionIndex = idx;
                }
                poolNames[idx] = this.poolWrappers[idx].getDisplayName();
                ++idx;
            }
            if (this.nameValidator == null && this.nameValidators != null) {
                this.nameValidator = this.nameValidators[filterPoolSelectionIndex];
            }
            this.poolWrapperCombo.setItems(poolNames);
            this.poolWrapperCombo.select(filterPoolSelectionIndex);
            this.poolWrapperCombo.addSelectionListener((SelectionListener)this);
            if (this.uniqueCB != null && this.uniqueCB.getSelection()) {
                this.poolVerbiage.setEnabled(false);
                this.poolComboLabel.setEnabled(false);
                this.poolWrapperCombo.setEnabled(false);
            }
        }
        if (this.nameValidator != null && (maxNameLength = this.nameValidator.getMaximumNameLength()) >= 0) {
            this.nameText.setTextLimit(maxNameLength);
        }
        if (this.inputFilterName != null) {
            this.nameText.setText(this.inputFilterName);
        }
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (SystemNewFilterWizardNamePage.this.ignoreChanges) {
                    return;
                }
                SystemNewFilterWizardNamePage.this.userEditedName = true;
                SystemNewFilterWizardNamePage.this.validateNameInput();
            }
        });
        this.setPageComplete();
        this.contentsCreated = true;
        return composite_prompts;
    }

    protected Control getInitialFocusControl() {
        return this.nameText;
    }

    public boolean performFinish() {
        if (!this.contentsCreated) {
            return true;
        }
        return this.verify() == null;
    }

    public boolean isPageComplete() {
        boolean pageComplete;
        boolean bl = pageComplete = this.errorMessage == null && this.nameText != null;
        if (pageComplete) {
            pageComplete = this.nameText.getText().trim().length() > 0;
        }
        return pageComplete;
    }

    public void setPageComplete() {
        this.setPageComplete(this.isPageComplete());
    }

    public void widgetSelected(SelectionEvent e) {
        Object src = e.getSource();
        if (src == this.poolCombo) {
            int selection = this.poolCombo.getSelectionIndex();
            if (selection >= 0 && this.nameValidators != null) {
                this.nameValidator = this.nameValidators[selection];
            }
        } else if (src == this.poolWrapperCombo) {
            int selection = this.poolWrapperCombo.getSelectionIndex();
            if (selection >= 0 && this.nameValidators != null) {
                this.nameValidator = this.nameValidators[selection];
            }
        } else if (src == this.uniqueCB) {
            boolean selected = this.uniqueCB.getSelection();
            if (this.poolVerbiage != null) {
                this.poolVerbiage.setEnabled(!selected);
            }
            if (this.poolCombo != null) {
                this.poolCombo.setEnabled(!selected);
            }
            if (this.poolWrapperCombo != null) {
                this.poolWrapperCombo.setEnabled(!selected);
            }
            if (this.poolComboLabel != null) {
                this.poolComboLabel.setEnabled(!selected);
            }
        }
        this.verify();
        this.setPageComplete();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public SystemMessage verify() {
        this.errorMessage = null;
        Combo controlInError = null;
        if (this.errorMessage == null && this.filterPoolSelectionValidator != null) {
            this.errorMessage = this.filterPoolSelectionValidator.validate(this.getParentSystemFilterPool());
            if (this.poolCombo != null) {
                controlInError = this.poolCombo;
            } else if (this.poolWrapperCombo != null) {
                controlInError = this.poolCombo;
            }
        }
        if (this.errorMessage == null && this.nameValidator != null) {
            this.errorMessage = this.nameValidator.validate(this.nameText.getText().trim());
            controlInError = this.nameText;
        }
        if (this.errorMessage != null) {
            if (controlInError != null) {
                controlInError.setFocus();
            }
            this.setErrorMessage(this.errorMessage);
        } else {
            this.clearErrorMessage();
        }
        return this.errorMessage;
    }

    protected SystemMessage validateNameInput() {
        this.errorMessage = null;
        if (this.nameValidator != null) {
            this.errorMessage = this.nameValidator.validate(this.nameText.getText().trim());
        }
        if (this.errorMessage == null && this.filterPoolSelectionValidator != null) {
            this.errorMessage = this.filterPoolSelectionValidator.validate(this.getParentSystemFilterPool());
        }
        this.setPageComplete();
        if (this.errorMessage != null) {
            this.setErrorMessage(this.errorMessage);
        } else {
            this.clearErrorMessage();
        }
        return this.errorMessage;
    }

    public String getFilterName() {
        if (this.nameText != null) {
            return this.nameText.getText().trim();
        }
        return this.inputFilterName;
    }

    public ISystemFilterPool getParentSystemFilterPool() {
        ISystemFilterPool pool = null;
        if (this.poolCombo != null) {
            int selection = this.poolCombo.getSelectionIndex();
            if (selection < 0) {
                selection = 0;
            }
            pool = this.poolsToSelectFrom[selection];
        } else if (this.poolWrapperCombo != null) {
            int selection = this.poolWrapperCombo.getSelectionIndex();
            if (selection < 0) {
                selection = 0;
            }
            pool = this.poolWrappers[selection].getSystemFilterPool();
        } else {
            pool = this.parentPool;
        }
        return pool;
    }

    public boolean getUniqueToThisConnection() {
        if (this.uniqueCB != null) {
            return this.uniqueCB.getSelection();
        }
        return false;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            String defaultName;
            if (!this.userEditedName && this.nameText != null && (defaultName = ((SystemNewFilterWizard)this.getWizard()).getDefaultFilterName()) != null) {
                this.ignoreChanges = true;
                this.nameText.setText(defaultName);
                this.ignoreChanges = false;
            }
            this.verify();
        }
    }
}

