/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.filters.dialogs;

import java.util.Vector;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.rse.core.filters.ISystemFilter;
import org.eclipse.rse.core.filters.ISystemFilterContainer;
import org.eclipse.rse.core.filters.ISystemFilterContainerReference;
import org.eclipse.rse.core.filters.ISystemFilterPool;
import org.eclipse.rse.core.filters.ISystemFilterPoolManager;
import org.eclipse.rse.core.filters.ISystemFilterPoolReference;
import org.eclipse.rse.core.filters.ISystemFilterPoolReferenceManager;
import org.eclipse.rse.core.filters.ISystemFilterPoolReferenceManagerProvider;
import org.eclipse.rse.core.filters.ISystemFilterPoolSelectionValidator;
import org.eclipse.rse.core.filters.ISystemFilterPoolWrapper;
import org.eclipse.rse.core.filters.ISystemFilterPoolWrapperInformation;
import org.eclipse.rse.core.filters.ISystemFilterReference;
import org.eclipse.rse.internal.ui.SystemResources;
import org.eclipse.rse.internal.ui.filters.dialogs.SystemNewFilterWizardNamePage;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.rse.ui.filters.SystemFilterStringEditPane;
import org.eclipse.rse.ui.filters.dialogs.ISystemNewFilterWizardConfigurator;
import org.eclipse.rse.ui.filters.dialogs.SystemNewFilterWizardConfigurator;
import org.eclipse.rse.ui.filters.dialogs.SystemNewFilterWizardInfoPage;
import org.eclipse.rse.ui.filters.dialogs.SystemNewFilterWizardMainPage;
import org.eclipse.rse.ui.messages.SystemMessageDialog;
import org.eclipse.rse.ui.validators.ISystemValidator;
import org.eclipse.rse.ui.validators.ValidatorFilterName;
import org.eclipse.rse.ui.wizards.AbstractSystemWizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class SystemNewFilterWizard
extends AbstractSystemWizard {
    protected SystemNewFilterWizardMainPage mainPage;
    protected SystemNewFilterWizardNamePage namePage;
    protected SystemNewFilterWizardInfoPage infoPage;
    protected ISystemFilterContainer filterContainer;
    protected ISystemFilterPool parentPool;
    protected ISystemFilterPool[] poolsToSelectFrom;
    protected String type;
    protected String[] defaultFilterStrings;
    protected boolean showFilterStrings = true;
    protected boolean showNamePrompt = true;
    protected boolean showInfoPage = true;
    protected boolean fromRSE = false;
    protected boolean page1DescriptionSet = false;
    protected ISystemFilter newFilter = null;
    protected SystemFilterStringEditPane editPane;
    protected ISystemFilterPoolReferenceManagerProvider provider;
    protected ISystemFilterPoolWrapperInformation poolWrapperInformation;
    protected ISystemFilterPoolSelectionValidator filterPoolSelectionValidator;
    protected ISystemNewFilterWizardConfigurator configurator;

    public SystemNewFilterWizard(String title, ImageDescriptor wizardImage, ISystemFilterPool parentPool) {
        this(new SystemNewFilterWizardConfigurator(title), wizardImage, parentPool);
    }

    public SystemNewFilterWizard(ISystemFilterPool parentPool) {
        this(new SystemNewFilterWizardConfigurator(), RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.newfilter_wizBannerIcon"), parentPool);
    }

    public SystemNewFilterWizard(ISystemNewFilterWizardConfigurator data, ImageDescriptor wizardImage, ISystemFilterPool parentPool) {
        super(SystemResources.RESID_NEWFILTER_TITLE, wizardImage);
        super.setWizardPageTitle(data.getPageTitle());
        super.setForcePreviousAndNextButtons(true);
        this.configurator = data;
        this.parentPool = parentPool;
        this.setOutputObject(null);
    }

    public void setAllowFilterPoolSelection(ISystemFilterPool[] poolsToSelectFrom) {
        this.poolsToSelectFrom = poolsToSelectFrom;
    }

    public void setAllowFilterPoolSelection(ISystemFilterPoolWrapperInformation poolsToSelectFrom) {
        this.poolWrapperInformation = poolsToSelectFrom;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void setShowFilterStrings(boolean show) {
        this.showFilterStrings = show;
    }

    public void setShowNamePrompt(boolean show) {
        this.showNamePrompt = show;
        if (!show) {
            this.setShowInfoPage(false);
        }
    }

    public void setNamePageHelp(String helpId) {
        if (this.configurator instanceof SystemNewFilterWizardConfigurator) {
            ((SystemNewFilterWizardConfigurator)this.configurator).setPage2HelpID(helpId);
        }
    }

    public void setShowInfoPage(boolean show) {
        this.showInfoPage = show;
    }

    public void setDefaultFilterStrings(String[] defaultFilterStrings) {
        this.defaultFilterStrings = defaultFilterStrings;
    }

    public void setFromRSE(boolean rse) {
        this.fromRSE = true;
    }

    public void setFilterPoolSelectionValidator(ISystemFilterPoolSelectionValidator validator) {
        this.filterPoolSelectionValidator = validator;
    }

    public void setSystemFilterPoolReferenceManagerProvider(ISystemFilterPoolReferenceManagerProvider provider) {
        this.provider = provider;
    }

    public void setVerbiage(String verbiage) {
        if (this.configurator instanceof SystemNewFilterWizardConfigurator) {
            ((SystemNewFilterWizardConfigurator)this.configurator).setPage3Tip1(verbiage);
        }
    }

    public void setWizardPageTitle(String pageTitle) {
        super.setWizardPageTitle(pageTitle);
        if (this.configurator instanceof SystemNewFilterWizardConfigurator) {
            ((SystemNewFilterWizardConfigurator)this.configurator).setPageTitle(pageTitle);
        }
    }

    public void setPage1Description(String description) {
        if (this.configurator instanceof SystemNewFilterWizardConfigurator) {
            ((SystemNewFilterWizardConfigurator)this.configurator).setPage1Description(description);
        }
        this.page1DescriptionSet = true;
    }

    public void setFilterStringEditPane(SystemFilterStringEditPane editPane) {
        this.editPane = editPane;
    }

    protected SystemNewFilterWizardMainPage createMainPage() {
        this.mainPage = null;
        this.mainPage = this.editPane == null ? new SystemNewFilterWizardMainPage(this, this.configurator) : new SystemNewFilterWizardMainPage(this, this.editPane, this.configurator);
        return this.mainPage;
    }

    protected SystemNewFilterWizardNamePage createNamePage() {
        this.namePage = new SystemNewFilterWizardNamePage(this, this.parentPool, this.configurator);
        return this.namePage;
    }

    protected SystemNewFilterWizardInfoPage createInfoPage() {
        boolean showFilterPoolsTip = this.poolsToSelectFrom != null || this.poolWrapperInformation != null;
        this.infoPage = new SystemNewFilterWizardInfoPage(this, showFilterPoolsTip, this.configurator);
        return this.infoPage;
    }

    public void addPages() {
    }

    public void createPageControls(Composite c) {
        try {
            this.mainPage = this.createMainPage();
            this.mainPage.setSystemFilterPoolReferenceManagerProvider(this.provider);
            this.mainPage.setType(this.type);
            if (this.defaultFilterStrings != null) {
                this.mainPage.setDefaultFilterStrings(this.defaultFilterStrings);
            }
            if (this.showFilterStrings) {
                this.addPage((IWizardPage)this.mainPage);
            }
            this.namePage = this.createNamePage();
            if (this.showNamePrompt && this.namePage != null) {
                if (this.filterPoolSelectionValidator != null) {
                    this.namePage.setFilterPoolSelectionValidator(this.filterPoolSelectionValidator);
                }
                if (this.poolsToSelectFrom != null) {
                    ISystemValidator[] validators = new ISystemValidator[this.poolsToSelectFrom.length];
                    int idx = 0;
                    while (idx < validators.length) {
                        validators[idx] = this.getFilterNameValidator((ISystemFilterContainer)this.poolsToSelectFrom[idx]);
                        ++idx;
                    }
                    this.namePage.setAllowFilterPoolSelection(this.poolsToSelectFrom, validators);
                } else if (this.poolWrapperInformation != null) {
                    ISystemFilterPoolWrapper[] wrappers = this.poolWrapperInformation.getWrappers();
                    ISystemValidator[] validators = new ISystemValidator[wrappers.length];
                    int idx = 0;
                    while (idx < validators.length) {
                        validators[idx] = this.getFilterNameValidator((ISystemFilterContainer)wrappers[idx].getSystemFilterPool());
                        ++idx;
                    }
                    this.namePage.setAllowFilterPoolSelection(this.poolWrapperInformation, validators);
                } else {
                    ISystemValidator validator = this.getFilterNameValidator(this.getFilterContainer());
                    this.namePage.setFilterNameValidator(validator);
                }
                if (!this.showFilterStrings && this.page1DescriptionSet) {
                    this.namePage.setDescription(this.configurator.getPage1Description());
                }
                this.addPage((IWizardPage)this.namePage);
            }
            if (this.showInfoPage) {
                this.infoPage = this.createInfoPage();
                if (this.infoPage != null) {
                    this.addPage((IWizardPage)this.infoPage);
                }
            }
        }
        catch (Exception exc) {
            SystemBasePlugin.logError("Error in createPageControls of SystemNewFilterWizard", exc);
        }
    }

    protected ISystemValidator getFilterNameValidator(ISystemFilterContainer container) {
        return SystemNewFilterWizard.getFilterNameValidator(container, null);
    }

    public static ISystemValidator getFilterNameValidator(ISystemFilterContainer container, ISystemFilter filter) {
        Vector v = container.getSystemFilterNames();
        if (filter != null) {
            v.removeElement(filter.getName());
        }
        ValidatorFilterName filterNameValidator = new ValidatorFilterName(v);
        return filterNameValidator;
    }

    public boolean areStringsCaseSensitive() {
        ISystemFilterContainer fc = this.getFilterContainer();
        if (fc != null) {
            return fc.areStringsCaseSensitive();
        }
        return false;
    }

    public boolean performFinish() {
        boolean ok = false;
        this.newFilter = null;
        this.setOutputObject(null);
        if (!this.mainPage.performFinish()) {
            this.setPageError((IWizardPage)this.mainPage);
        } else if (!this.namePage.performFinish()) {
            this.setPageError((IWizardPage)this.namePage);
        } else {
            Vector filterStrings = this.mainPage.getFilterStrings();
            String filterName = null;
            if (this.showNamePrompt) {
                ISystemFilterPool filterParent;
                block21: {
                    filterName = this.namePage.getFilterName();
                    filterParent = null;
                    if (this.poolsToSelectFrom != null || this.poolWrapperInformation != null) {
                        filterParent = this.namePage.getParentSystemFilterPool();
                        filterParent = this.namePage.getUniqueToThisConnection() ? this.provider.getUniqueOwningSystemFilterPool(true) : this.namePage.getParentSystemFilterPool();
                    } else {
                        filterParent = this.getFilterContainer();
                    }
                    String type = this.mainPage.getType();
                    try {
                        this.newFilter = this.createNewFilter(this.getShell(), (ISystemFilterContainer)filterParent, filterName, filterStrings, type);
                        if (this.newFilter != null) break block21;
                        return false;
                    }
                    catch (Exception exc) {
                        SystemMessage msg = RSEUIPlugin.getPluginMessage("RSEG1003");
                        msg.makeSubstitution((Object)exc);
                        SystemMessageDialog msgDlg = new SystemMessageDialog(this.getShell(), msg);
                        msgDlg.openWithDetails();
                        return false;
                    }
                }
                if (this.provider != null && filterParent instanceof ISystemFilterPool) {
                    ISystemFilterPool parentPool = filterParent;
                    if (this.provider.getSystemFilterPoolReferenceManager().getReferenceToSystemFilterPool(parentPool) == null) {
                        this.provider.getSystemFilterPoolReferenceManager().addReferenceToSystemFilterPool(parentPool);
                    }
                }
                this.setOutputObject(this.newFilter);
                if (this.newFilter != null && this.getInputObject() != null) {
                    Object selectedObject = this.getInputObject();
                    if (selectedObject instanceof ISystemFilterPoolReference || selectedObject instanceof ISystemFilterPoolReferenceManagerProvider) {
                        ISystemFilterPoolReferenceManagerProvider provider = null;
                        if (selectedObject instanceof ISystemFilterPoolReference) {
                            ISystemFilterPoolReferenceManager sfprm = ((ISystemFilterPoolReference)selectedObject).getFilterPoolReferenceManager();
                            if (sfprm != null) {
                                provider = sfprm.getProvider();
                            }
                        } else {
                            provider = (ISystemFilterPoolReferenceManagerProvider)selectedObject;
                        }
                        if (provider != null) {
                            provider.filterEventFilterCreated(selectedObject, this.newFilter);
                        }
                    } else if (selectedObject instanceof ISystemFilterReference) {
                        ISystemFilterReference ref = (ISystemFilterReference)selectedObject;
                        ISystemFilterPoolReferenceManagerProvider provider = ref.getProvider();
                        provider.filterEventFilterCreated(selectedObject, this.newFilter);
                    }
                }
                ok = this.newFilter != null;
            } else {
                ok = true;
                this.setOutputObject(filterStrings);
            }
            return ok;
        }
        return false;
    }

    protected Object getParent() {
        if (this.filterContainer != null) {
            return this.filterContainer;
        }
        return this.getInputObject();
    }

    protected ISystemFilterContainer getFilterContainer() {
        if (this.filterContainer == null) {
            Object input = this.getInputObject();
            if (input != null) {
                if (input instanceof ISystemFilter) {
                    return ((ISystemFilter)input).getParentFilterContainer();
                }
                if (input instanceof ISystemFilterReference) {
                    return ((ISystemFilterReference)input).getReferencedFilter().getParentFilterContainer();
                }
                if (input instanceof ISystemFilterContainer) {
                    return (ISystemFilterContainer)input;
                }
                if (input instanceof ISystemFilterContainerReference) {
                    return ((ISystemFilterContainerReference)input).getReferencedSystemFilterContainer();
                }
                if (input instanceof ISystemFilterPoolReference) {
                    return ((ISystemFilterPoolReference)input).getReferencedFilterPool();
                }
                if (this.parentPool != null) {
                    return this.parentPool;
                }
                if (this.poolsToSelectFrom != null && this.poolsToSelectFrom.length > 0) {
                    return this.poolsToSelectFrom[0];
                }
                if (this.poolWrapperInformation != null) {
                    return this.poolWrapperInformation.getPreSelectWrapper().getSystemFilterPool();
                }
                return null;
            }
            return null;
        }
        return this.filterContainer;
    }

    public void setFilterContainer(ISystemFilterContainer container) {
        this.filterContainer = container;
    }

    public void setFilterContainer(ISystemFilterContainerReference containerRef) {
        this.filterContainer = containerRef.getReferencedSystemFilterContainer();
    }

    public ISystemFilter createNewFilter(Shell shell, ISystemFilterContainer filterParent, String aliasName, Vector filterStrings, String type) throws Exception {
        ISystemFilter newFilter = null;
        ISystemFilterPoolManager fpMgr = filterParent.getSystemFilterPoolManager();
        newFilter = type == null ? fpMgr.createSystemFilter(filterParent, aliasName, filterStrings) : fpMgr.createSystemFilter(filterParent, aliasName, filterStrings, type);
        return newFilter;
    }

    protected boolean isFromRSE() {
        return this.fromRSE;
    }

    public String getDefaultFilterName() {
        return this.mainPage.getEditPane(null).getDefaultFilterName();
    }

    public ISystemFilter getSystemFilter() {
        return this.newFilter;
    }
}

