/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dstore.core.java;

public class ClassRequest {
    private boolean _requested;
    private boolean _loaded;
    private boolean _synchronous;
    private String _className;
    private Class _class = null;

    public ClassRequest(String className, boolean synchronous) {
        this._synchronous = synchronous;
        this._className = className;
        this._requested = false;
        this._loaded = false;
    }

    public synchronized void waitForResponse() {
        try {
            if (!this._loaded) {
                this.wait();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public synchronized void notifyResponse() {
        this.notifyAll();
    }

    public Class getLoadedClass() {
        return this._class;
    }

    public boolean isLoaded() {
        return this._loaded;
    }

    public String getClassName() {
        return this._className;
    }

    public boolean isRequested() {
        return this._requested;
    }

    public boolean isSynchronous() {
        return this._synchronous;
    }

    public void setRequested(boolean requested) {
        this._requested = requested;
    }

    public void setLoaded(boolean loaded) {
        this._loaded = loaded;
    }

    public synchronized void setLoadedClass(Class loadedClass) {
        this._class = loadedClass;
        this.setRequested(false);
        this.setLoaded(true);
        this.notifyAll();
    }
}

