/*
 * Decompiled with CFR 0.152.
 */
package samples.subsystems;

import java.lang.reflect.InvocationTargetException;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.SubSystem;
import org.eclipse.rse.services.clientserver.NamePatternMatcher;
import samples.model.DeveloperResource;
import samples.model.TeamResource;

public class DeveloperSubSystem
extends SubSystem {
    private TeamResource[] teams;
    private Vector devVector = new Vector();
    private static int employeeId = 123456;

    public DeveloperSubSystem(IHost host, IConnectorService connectorService) {
        super(host, connectorService);
    }

    public void initializeSubSystem(IProgressMonitor monitor) {
    }

    public void uninitializeSubSystem(IProgressMonitor monitor) {
    }

    public Object getObjectWithAbsoluteName(String key) throws Exception {
        block5: {
            block4: {
                if (!key.startsWith("Team_")) break block4;
                String teamName = key.substring(5);
                TeamResource[] allTeams = this.getAllTeams();
                int idx = 0;
                while (idx < allTeams.length) {
                    if (allTeams[idx].getName().equals(teamName)) {
                        return allTeams[idx];
                    }
                    ++idx;
                }
                break block5;
            }
            if (!key.startsWith("Devr_")) break block5;
            String devrId = key.substring(5);
            DeveloperResource[] devrs = this.getAllDevelopers();
            int idx = 0;
            while (idx < devrs.length) {
                if (devrs[idx].getId().equals(devrId)) {
                    return devrs[idx];
                }
                ++idx;
            }
        }
        return super.getObjectWithAbsoluteName(key);
    }

    protected Object[] internalResolveFilterString(String filterString, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        int slashIdx = filterString.indexOf(47);
        if (slashIdx < 0) {
            TeamResource[] allTeams = this.getAllTeams();
            NamePatternMatcher subsetter = new NamePatternMatcher(filterString);
            Vector<TeamResource> v = new Vector<TeamResource>();
            int idx = 0;
            while (idx < allTeams.length) {
                if (subsetter.matches(allTeams[idx].getName())) {
                    v.addElement(allTeams[idx]);
                }
                ++idx;
            }
            TeamResource[] teams = new TeamResource[v.size()];
            int idx2 = 0;
            while (idx2 < v.size()) {
                teams[idx2] = (TeamResource)((Object)v.elementAt(idx2));
                ++idx2;
            }
            return teams;
        }
        String teamName = filterString.substring(0, slashIdx);
        String devrName = filterString.substring(slashIdx + 1);
        TeamResource[] allTeams = this.getAllTeams();
        TeamResource match = null;
        int idx = 0;
        while (match == null && idx < allTeams.length) {
            if (allTeams[idx].getName().equals(teamName)) {
                match = allTeams[idx];
            }
            ++idx;
        }
        if (match != null) {
            DeveloperResource[] allDevrs = match.getDevelopers();
            NamePatternMatcher subsetter = new NamePatternMatcher(devrName);
            Vector<DeveloperResource> v = new Vector<DeveloperResource>();
            int idx3 = 0;
            while (idx3 < allDevrs.length) {
                if (subsetter.matches(allDevrs[idx3].getName())) {
                    v.addElement(allDevrs[idx3]);
                }
                ++idx3;
            }
            DeveloperResource[] devrs = new DeveloperResource[v.size()];
            int idx4 = 0;
            while (idx4 < v.size()) {
                devrs[idx4] = (DeveloperResource)((Object)v.elementAt(idx4));
                ++idx4;
            }
            return devrs;
        }
        return null;
    }

    protected Object[] internalResolveFilterString(Object parent, String filterString, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        TeamResource team = (TeamResource)((Object)parent);
        return team.getDevelopers();
    }

    public TeamResource[] getAllTeams() {
        if (this.teams == null) {
            this.teams = this.createTeams("Team ", 4);
        }
        return this.teams;
    }

    public DeveloperResource[] getAllDevelopers() {
        DeveloperResource[] allDevrs = new DeveloperResource[this.devVector.size()];
        int idx = 0;
        while (idx < allDevrs.length) {
            allDevrs[idx] = (DeveloperResource)((Object)this.devVector.elementAt(idx));
            ++idx;
        }
        return allDevrs;
    }

    private TeamResource[] createTeams(String prefix, int howMany) {
        TeamResource[] teams = new TeamResource[howMany];
        int idx = 0;
        while (idx < teams.length) {
            teams[idx] = new TeamResource((ISubSystem)this);
            teams[idx].setName(String.valueOf(prefix) + (idx + 1));
            teams[idx].setDevelopers(this.createDevelopers(String.valueOf(teams[idx].getName()) + " developer", idx + 1));
            ++idx;
        }
        return teams;
    }

    private DeveloperResource[] createDevelopers(String prefix, int nbr) {
        DeveloperResource[] devrs = new DeveloperResource[nbr];
        int idx = 0;
        while (idx < devrs.length) {
            devrs[idx] = new DeveloperResource((ISubSystem)this);
            devrs[idx].setName(String.valueOf(prefix) + (idx + 1));
            devrs[idx].setId(Integer.toString(employeeId++));
            devrs[idx].setDeptNbr(Integer.toString((idx + 1) * 100));
            this.devVector.add(devrs[idx]);
            ++idx;
        }
        return devrs;
    }
}

