/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.files.ui.propertypages;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.NumberFormat;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.events.ISystemResourceChangeEvent;
import org.eclipse.rse.core.events.SystemResourceChangeEvent;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.files.ui.resources.SystemEditableRemoteFile;
import org.eclipse.rse.internal.files.ui.FileResources;
import org.eclipse.rse.internal.subsystems.files.core.SystemFileResources;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.files.RemoteFileIOException;
import org.eclipse.rse.services.files.RemoteFileSecurityException;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IVirtualRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.RemoteFileEncodingManager;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.propertypages.SystemBasePropertyPage;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.ide.IDEEncoding;

public class SystemFilePropertyPage
extends SystemBasePropertyPage
implements SelectionListener {
    protected Label labelNamePrompt;
    protected Label labelTypePrompt;
    protected Label labelPathPrompt;
    protected Label labelSizePrompt;
    protected Label labelModifiedPrompt;
    protected Button cbReadonlyPrompt;
    protected Button cbHiddenPrompt;
    protected Label labelName;
    protected Label labelType;
    protected Label labelPath;
    protected Label labelSize;
    protected Label labelModified;
    protected Label labelReadable;
    protected Label labelWritable;
    protected Label labelHidden;
    protected Button defaultEncodingButton;
    protected Button otherEncodingButton;
    protected Combo otherEncodingCombo;
    protected String errorMessage;
    protected boolean initDone = false;
    protected boolean wasReadOnly = false;
    private boolean encodingFieldAdded = false;
    private String defaultEncoding = null;
    private boolean isValidBefore = true;

    protected Control createContentArea(Composite parent) {
        IRemoteFile file = this.getRemoteFile();
        int nbrColumns = 2;
        Composite composite_prompts = SystemWidgetHelpers.createComposite((Composite)parent, (int)nbrColumns);
        this.labelNamePrompt = SystemWidgetHelpers.createLabel((Composite)composite_prompts, (String)SystemFileResources.RESID_PP_FILE_NAME_LABEL, (String)SystemFileResources.RESID_PP_FILE_NAME_TOOLTIP);
        this.labelName = SystemWidgetHelpers.createLabel((Composite)composite_prompts, (String)"");
        this.labelName.setToolTipText(SystemFileResources.RESID_PP_FILE_NAME_TOOLTIP);
        this.labelTypePrompt = SystemWidgetHelpers.createLabel((Composite)composite_prompts, (String)SystemFileResources.RESID_PP_FILE_TYPE_LABEL, (String)SystemFileResources.RESID_PP_FILE_TYPE_TOOLTIP);
        this.labelType = SystemWidgetHelpers.createLabel((Composite)composite_prompts, (String)"");
        this.labelType.setToolTipText(SystemFileResources.RESID_PP_FILE_TYPE_TOOLTIP);
        if (!file.isRoot()) {
            this.labelPathPrompt = SystemWidgetHelpers.createLabel((Composite)composite_prompts, (String)SystemFileResources.RESID_PP_FILE_PATH_LABEL, (String)SystemFileResources.RESID_PP_FILE_PATH_TOOLTIP);
            this.labelPath = SystemWidgetHelpers.createLabel((Composite)composite_prompts, (String)"");
            this.labelPath.setToolTipText(SystemFileResources.RESID_PP_FILE_PATH_TOOLTIP);
        }
        if (!file.isDirectory()) {
            this.labelSizePrompt = SystemWidgetHelpers.createLabel((Composite)composite_prompts, (String)SystemFileResources.RESID_PP_FILE_SIZE_LABEL, (String)SystemFileResources.RESID_PP_FILE_SIZE_TOOLTIP);
            this.labelSize = SystemWidgetHelpers.createLabel((Composite)composite_prompts, (String)"");
            this.labelSize.setToolTipText(SystemFileResources.RESID_PP_FILE_SIZE_TOOLTIP);
        }
        if (!file.isRoot()) {
            this.labelModifiedPrompt = SystemWidgetHelpers.createLabel((Composite)composite_prompts, (String)SystemFileResources.RESID_PP_FILE_MODIFIED_LABEL, (String)SystemFileResources.RESID_PP_FILE_MODIFIED_TOOLTIP);
            this.labelModified = SystemWidgetHelpers.createLabel((Composite)composite_prompts, (String)"");
            this.labelModified.setToolTipText(SystemFileResources.RESID_PP_FILE_MODIFIED_TOOLTIP);
        }
        if (!file.isRoot() && file.showReadOnlyProperty()) {
            this.cbReadonlyPrompt = SystemWidgetHelpers.createCheckBox((Composite)composite_prompts, null, (String)SystemFileResources.RESID_PP_FILE_READONLY_LABEL, (String)SystemFileResources.RESID_PP_FILE_READONLY_TOOLTIP);
        }
        if (!file.isRoot()) {
            this.cbHiddenPrompt = SystemWidgetHelpers.createCheckBox((Composite)composite_prompts, null, (String)SystemFileResources.RESID_PP_FILE_HIDDEN_LABEL, (String)SystemFileResources.RESID_PP_FILE_HIDDEN_TOOLTIP);
        }
        if (file.getParentRemoteFileSubSystem().supportsEncoding()) {
            SystemWidgetHelpers.createLabel((Composite)composite_prompts, (String)"", (int)2);
            Group encodingGroup = SystemWidgetHelpers.createGroupComposite((Composite)composite_prompts, (int)2, (String)SystemFileResources.RESID_PP_FILE_ENCODING_GROUP_LABEL);
            GridData data = new GridData();
            data.horizontalSpan = 2;
            data.horizontalAlignment = 4;
            data.grabExcessHorizontalSpace = true;
            data.verticalAlignment = 1;
            data.grabExcessVerticalSpace = false;
            encodingGroup.setLayoutData((Object)data);
            SelectionAdapter defaultButtonSelectionListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SystemFilePropertyPage.this.updateEncodingGroupState(SystemFilePropertyPage.this.defaultEncodingButton.getSelection());
                    SystemFilePropertyPage.this.updateValidState();
                }
            };
            this.defaultEncoding = file.getParentRemoteFileSubSystem().getRemoteEncoding();
            String defaultEncodingLabel = SystemFileResources.RESID_PP_FILE_ENCODING_DEFAULT_LABEL;
            int idx = defaultEncodingLabel.indexOf(37);
            if (idx != -1) {
                defaultEncodingLabel = String.valueOf(defaultEncodingLabel.substring(0, idx)) + file.getParentRemoteFileSubSystem().getRemoteEncoding() + defaultEncodingLabel.substring(idx + 2);
            }
            this.defaultEncodingButton = SystemWidgetHelpers.createRadioButton((Composite)encodingGroup, null, (String)defaultEncodingLabel, (String)SystemFileResources.RESID_PP_FILE_ENCODING_DEFAULT_TOOLTIP);
            data = new GridData();
            data.horizontalSpan = 2;
            this.defaultEncodingButton.setLayoutData((Object)data);
            this.defaultEncodingButton.addSelectionListener((SelectionListener)defaultButtonSelectionListener);
            Composite otherComposite = new Composite((Composite)encodingGroup, 0);
            GridLayout otherLayout = new GridLayout();
            otherLayout.numColumns = 2;
            otherLayout.marginWidth = 0;
            otherLayout.marginHeight = 0;
            otherComposite.setLayout((Layout)otherLayout);
            otherComposite.setLayoutData((Object)new GridData(32));
            this.otherEncodingButton = SystemWidgetHelpers.createRadioButton((Composite)otherComposite, null, (String)SystemFileResources.RESID_PP_FILE_ENCODING_OTHER_LABEL, (String)SystemFileResources.RESID_PP_FILE_ENCODING_OTHER_TOOLTIP);
            SelectionAdapter otherButtonSelectionListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SystemFilePropertyPage.this.updateEncodingGroupState(!SystemFilePropertyPage.this.otherEncodingButton.getSelection());
                    SystemFilePropertyPage.this.updateValidState();
                }
            };
            this.otherEncodingButton.addSelectionListener((SelectionListener)otherButtonSelectionListener);
            this.otherEncodingCombo = SystemWidgetHelpers.createCombo((Composite)otherComposite, null, (String)SystemFileResources.RESID_PP_FILE_ENCODING_ENTER_TOOLTIP);
            data = new GridData();
            data.horizontalAlignment = 1;
            data.grabExcessHorizontalSpace = true;
            this.otherEncodingCombo.setLayoutData((Object)data);
            this.otherEncodingCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SystemFilePropertyPage.this.updateValidState();
                }
            });
            this.otherEncodingCombo.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    SystemFilePropertyPage.this.updateValidState();
                }
            });
            SystemWidgetHelpers.createLabel((Composite)encodingGroup, (String)"");
            SystemWidgetHelpers.createLabel((Composite)composite_prompts, (String)"", (int)2);
            this.encodingFieldAdded = true;
        } else {
            this.encodingFieldAdded = false;
        }
        if (!this.initDone) {
            this.doInitializeFields();
        }
        if (!file.isRoot() && file.showReadOnlyProperty()) {
            this.cbReadonlyPrompt.addSelectionListener((SelectionListener)this);
        }
        return composite_prompts;
    }

    private void updateEncodingGroupState(boolean useDefault) {
        this.defaultEncodingButton.setSelection(useDefault);
        this.otherEncodingButton.setSelection(!useDefault);
        if (useDefault) {
            this.otherEncodingCombo.setText(this.getDefaultEncoding());
        }
        this.otherEncodingCombo.setEnabled(!useDefault);
        this.updateValidState();
    }

    private void updateValidState() {
        boolean isValid = this.isEncodingValid();
        if (isValid != this.isValidBefore) {
            this.isValidBefore = isValid;
            if (this.isValidBefore) {
                this.clearErrorMessage();
            } else {
                this.setErrorMessage(FileResources.MESSAGE_ENCODING_NOT_SUPPORTED);
            }
        }
    }

    protected String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    protected String getSelectedEncoding() {
        if (this.defaultEncodingButton.getSelection()) {
            return this.defaultEncoding;
        }
        return this.otherEncodingCombo.getText();
    }

    private boolean isEncodingValid() {
        return this.defaultEncodingButton.getSelection() || this.isEncodingValid(this.otherEncodingCombo.getText());
    }

    private boolean isEncodingValid(String encoding) {
        try {
            return Charset.isSupported(encoding);
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            return false;
        }
    }

    protected IRemoteFile getRemoteFile() {
        IAdaptable element = this.getElement();
        return (IRemoteFile)element;
    }

    protected void doInitializeFields() {
        Date date;
        String path;
        this.initDone = true;
        IRemoteFile file = this.getRemoteFile();
        String name = file.getName();
        if (name.length() > 100) {
            String shortName = name.substring(0, 97).concat("...");
            this.labelName.setText(shortName);
        } else {
            this.labelName.setText(name);
        }
        if (file.isRoot()) {
            this.labelType.setText(SystemFileResources.RESID_PP_FILE_TYPE_ROOT_VALUE);
        } else if (file.isDirectory()) {
            this.labelType.setText(SystemFileResources.RESID_PP_FILE_TYPE_FOLDER_VALUE);
        } else {
            this.labelType.setText(SystemFileResources.RESID_PP_FILE_TYPE_FILE_VALUE);
        }
        if (this.labelPath != null && (path = file.getParentPath()) != null) {
            this.labelPath.setText(file.getParentPath());
        }
        if (this.labelSize != null) {
            NumberFormat fmt = NumberFormat.getIntegerInstance();
            String formattedNumber = fmt.format(file.getLength());
            this.labelSize.setText(formattedNumber);
        }
        if (this.labelModified != null && (date = file.getLastModifiedDate()) != null) {
            DateFormat datefmt = DateFormat.getDateTimeInstance((int)1, (int)0);
            String formattedDate = datefmt.format(date);
            this.labelModified.setText(formattedDate);
        }
        if (file.showReadOnlyProperty() && this.cbReadonlyPrompt != null) {
            this.cbReadonlyPrompt.setSelection(!file.canWrite());
            boolean bl = this.wasReadOnly = !file.canWrite();
            if (file instanceof IVirtualRemoteFile) {
                this.cbReadonlyPrompt.setEnabled(false);
            }
        }
        if (this.cbHiddenPrompt != null) {
            this.cbHiddenPrompt.setSelection(file.isHidden());
            this.cbHiddenPrompt.setEnabled(false);
        }
        if (this.encodingFieldAdded) {
            List encodings = IDEEncoding.getIDEEncodings();
            String[] encodingStrings = new String[encodings.size()];
            encodings.toArray(encodingStrings);
            this.otherEncodingCombo.setItems(encodingStrings);
            String encoding = file.getEncoding();
            if (encoding.equalsIgnoreCase(this.defaultEncoding)) {
                this.updateEncodingGroupState(true);
            } else {
                this.otherEncodingCombo.setText(encoding);
                this.updateEncodingGroupState(false);
            }
        }
    }

    public boolean performOk() {
        boolean readOnlySelected;
        boolean ok = super.performOk();
        boolean bl = readOnlySelected = this.cbReadonlyPrompt != null ? this.cbReadonlyPrompt.getSelection() : false;
        if (ok && this.cbReadonlyPrompt != null && (readOnlySelected && !this.wasReadOnly || !readOnlySelected && this.wasReadOnly)) {
            try {
                IRemoteFile remoteFile = this.getRemoteFile();
                boolean oldCanWrite = remoteFile.canWrite();
                remoteFile.getParentRemoteFileSubSystem().setReadOnly(remoteFile, readOnlySelected, (IProgressMonitor)new NullProgressMonitor());
                boolean updatedValue = remoteFile.canWrite();
                SystemEditableRemoteFile editable = new SystemEditableRemoteFile(remoteFile);
                if (editable.checkOpenInEditor() != -1) {
                    editable.setReadOnly(readOnlySelected);
                }
                ISystemRegistry sr = RSECorePlugin.getTheSystemRegistry();
                remoteFile.markStale(true);
                if (oldCanWrite == updatedValue) {
                    if (remoteFile.isDirectory()) {
                        sr.fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent((Object)remoteFile.getParentRemoteFile(), 85, null));
                    } else {
                        sr.fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent((Object)remoteFile, 85, null));
                    }
                } else {
                    sr.fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent((Object)remoteFile, 86, null));
                }
            }
            catch (RemoteFileIOException remoteFileIOException) {
                this.setMessage(RSEUIPlugin.getPluginMessage((String)"RSEF1002"));
            }
            catch (RemoteFileSecurityException remoteFileSecurityException) {
                this.setMessage(RSEUIPlugin.getPluginMessage((String)"RSEF1001"));
            }
            catch (SystemMessageException e) {
                this.setMessage(e.getSystemMessage());
            }
        }
        if (this.encodingFieldAdded) {
            RemoteFileEncodingManager.getInstance().setEncoding(this.getRemoteFile().getParentRemoteFileSubSystem().getHost().getHostName(), this.getRemoteFile().getAbsolutePath(), this.getSelectedEncoding());
        }
        return ok;
    }

    protected boolean verifyPageContents() {
        return true;
    }

    public void widgetDefaultSelected(SelectionEvent event) {
    }

    public void widgetSelected(SelectionEvent event) {
    }
}

