/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.importexport.files;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.rse.internal.importexport.RemoteImportExportPlugin;
import org.eclipse.rse.internal.importexport.SystemImportExportResources;
import org.eclipse.rse.internal.importexport.files.RemoteFileImportData;
import org.eclipse.rse.internal.importexport.files.RemoteImportWizardPage1;
import org.eclipse.rse.ui.wizards.AbstractSystemWizard;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

public class RemoteImportWizard
extends AbstractSystemWizard
implements IImportWizard {
    private IWorkbench workbench;
    private IStructuredSelection selection;
    private RemoteImportWizardPage1 mainPage;
    private RemoteFileImportData importData;
    private boolean initializeFromExportData;

    public RemoteImportWizard() {
        IDialogSettings workbenchSettings = RemoteImportExportPlugin.getDefault().getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection("RemoteImportWizard");
        if (section == null) {
            section = workbenchSettings.addNewSection("RemoteImportWizard");
        }
        this.setDialogSettings(section);
    }

    public void addPages() {
        this.mainPage = new RemoteImportWizardPage1(this.workbench, this.selection);
        this.addPage((IWizardPage)this.mainPage);
    }

    private ImageDescriptor getImageDescriptor(String key) {
        return RemoteImportExportPlugin.getDefault().getImageDescriptor(key);
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        this.workbench = workbench;
        this.selection = currentSelection;
        this.setWindowTitle(SystemImportExportResources.RESID_FILEIMPORT_TITLE);
        this.setDefaultPageImageDescriptor(this.getImageDescriptor("org.eclipse.rse.importexport.export_wizBannerIcon"));
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench workbench, RemoteFileImportData importData) {
        this.workbench = workbench;
        this.selection = new StructuredSelection(importData.getElements().toArray());
        this.importData = importData;
        this.setInitializeFromImportData(true);
        this.setWindowTitle(SystemImportExportResources.RESID_FILEIMPORT_TITLE);
        this.setDefaultPageImageDescriptor(this.getImageDescriptor("org.eclipse.rse.importexport.export_wizBannerIcon"));
        this.setNeedsProgressMonitor(true);
    }

    protected void setInitializeFromImportData(boolean init) {
        this.initializeFromExportData = init;
    }

    public boolean getInitializeFromImportData() {
        return this.initializeFromExportData;
    }

    public RemoteFileImportData getImportData() {
        return this.importData;
    }

    public boolean performFinish() {
        return this.mainPage.finish();
    }
}

