/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.services.processes;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.clientserver.processes.HostProcessFilterImpl;
import org.eclipse.rse.services.clientserver.processes.IHostProcess;
import org.eclipse.rse.services.clientserver.processes.IHostProcessFilter;
import org.eclipse.rse.services.processes.IProcessService;

public abstract class AbstractProcessService
implements IProcessService {
    public IHostProcess[] listAllProcesses(String exeNameFilter, String userNameFilter, String stateFilter, IProgressMonitor monitor) throws SystemMessageException {
        HostProcessFilterImpl rpfs = new HostProcessFilterImpl();
        rpfs.setName(exeNameFilter);
        rpfs.setUsername(userNameFilter);
        rpfs.setSpecificState(stateFilter);
        return this.listAllProcesses(rpfs, monitor);
    }

    public IHostProcess[] listAllProcesses(IProgressMonitor monitor) throws SystemMessageException {
        HostProcessFilterImpl rpfs = new HostProcessFilterImpl();
        return this.listAllProcesses(rpfs, monitor);
    }

    public IHostProcess[] listRootProcesses(IProgressMonitor monitor) throws SystemMessageException {
        IHostProcess[] roots = new IHostProcess[]{this.getProcess(1L, monitor)};
        return roots;
    }

    public IHostProcess[] listChildProcesses(long parentPID, IProgressMonitor monitor) throws SystemMessageException {
        String pPidString = "" + parentPID;
        HostProcessFilterImpl rpfs = new HostProcessFilterImpl();
        rpfs.setPpid(pPidString);
        return this.listAllProcesses(rpfs, monitor);
    }

    public IHostProcess[] listChildProcesses(long parentPID, IHostProcessFilter filter, IProgressMonitor monitor) throws SystemMessageException {
        String pPidString = "" + parentPID;
        filter.setPpid(pPidString);
        return this.listAllProcesses(filter, monitor);
    }

    public IHostProcess getParentProcess(long pid, IProgressMonitor monitor) throws SystemMessageException {
        return this.getProcess(this.getProcess(pid, monitor).getPPid(), monitor);
    }

    public IHostProcess getProcess(long pid, IProgressMonitor monitor) throws SystemMessageException {
        String pidString = "" + pid;
        HostProcessFilterImpl rpfs = new HostProcessFilterImpl();
        rpfs.setPid(pidString);
        IHostProcess[] results = this.listAllProcesses(rpfs, monitor);
        if (results == null || results.length == 0) {
            return null;
        }
        return results[0];
    }

    public SystemMessage getMessage(String messageID) {
        return null;
    }
}

