/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.subsystems.files.core.servicesubsystem;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemContentsType;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.IServiceSubSystemConfiguration;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.RemoteChildrenContentsType;
import org.eclipse.rse.services.clientserver.PathUtility;
import org.eclipse.rse.services.clientserver.SystemEncodingUtil;
import org.eclipse.rse.services.clientserver.SystemSearchString;
import org.eclipse.rse.services.clientserver.archiveutils.AbsoluteVirtualPath;
import org.eclipse.rse.services.clientserver.archiveutils.ArchiveHandlerManager;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.files.IFileService;
import org.eclipse.rse.services.files.IHostFile;
import org.eclipse.rse.services.search.IHostSearchResultConfiguration;
import org.eclipse.rse.services.search.IHostSearchResultSet;
import org.eclipse.rse.services.search.ISearchService;
import org.eclipse.rse.subsystems.files.core.ILanguageUtilityFactory;
import org.eclipse.rse.subsystems.files.core.model.SystemFileTransferModeRegistry;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.IFileServiceSubSystem;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.IFileServiceSubSystemConfiguration;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.SearchJob;
import org.eclipse.rse.subsystems.files.core.subsystems.IHostFileToRemoteFileAdapter;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileContext;
import org.eclipse.rse.subsystems.files.core.subsystems.RemoteFileSubSystem;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemBasePlugin;

public final class FileServiceSubSystem
extends RemoteFileSubSystem
implements IFileServiceSubSystem {
    protected ILanguageUtilityFactory _languageUtilityFactory;
    protected IFileService _hostFileService;
    protected ISearchService _hostSearchService;
    protected IHostFileToRemoteFileAdapter _hostFileToRemoteFileAdapter;
    protected IRemoteFile _userHome;
    static /* synthetic */ Class class$0;

    public FileServiceSubSystem(IHost host, IConnectorService connectorService, IFileService hostFileService, IHostFileToRemoteFileAdapter fileAdapter, ISearchService searchService) {
        super(host, connectorService);
        this._hostFileService = hostFileService;
        this._hostFileToRemoteFileAdapter = fileAdapter;
        this._hostSearchService = searchService;
    }

    public boolean isCaseSensitive() {
        return this.getFileService().isCaseSensitive();
    }

    public IRemoteFileContext getContextFor(IRemoteFile file) {
        return this.getContext(file);
    }

    public IRemoteFileContext getTheDefaultContext() {
        return this.getDefaultContextNoFilterString();
    }

    public IFileService getFileService() {
        return this._hostFileService;
    }

    public void setFileService(IFileService service) {
        this._hostFileService = service;
    }

    public ISearchService getSearchService() {
        return this._hostSearchService;
    }

    public void setSearchService(ISearchService service) {
        this._hostSearchService = service;
    }

    public IHostFileToRemoteFileAdapter getHostFileToRemoteFileAdapter() {
        return this._hostFileToRemoteFileAdapter;
    }

    public void setHostFileToRemoteFileAdapter(IHostFileToRemoteFileAdapter hostFileAdapter) {
        this._hostFileToRemoteFileAdapter = hostFileAdapter;
    }

    public IRemoteFile getRemoteFileObject(IRemoteFile parent, String folderOrFileName, IProgressMonitor monitor) throws SystemMessageException {
        String fullPath = String.valueOf(parent.getAbsolutePath()) + this.getSeparator() + folderOrFileName;
        IRemoteFile file = this.getCachedRemoteFile(fullPath);
        if (file != null && !file.isStale()) {
            return file;
        }
        IHostFile node = this.getFile(parent.getAbsolutePath(), folderOrFileName, monitor);
        return this.getHostFileToRemoteFileAdapter().convertToRemoteFile(this, this.getDefaultContext(), parent, node);
    }

    public IRemoteFile getRemoteFileObject(String folderOrFileName, IProgressMonitor monitor) throws SystemMessageException {
        int j;
        IRemoteFile file;
        String fofName = folderOrFileName;
        if (folderOrFileName.length() > 1) {
            fofName = ArchiveHandlerManager.cleanUpVirtualPath((String)folderOrFileName);
        }
        if ((file = this.getCachedRemoteFile(fofName)) != null && !file.isStale()) {
            return file;
        }
        if (fofName.endsWith("#virtual#/")) {
            fofName = fofName.substring(0, fofName.length() - "#virtual#/".length());
        }
        if ((j = fofName.indexOf("#virtual#/")) == -1) {
            if (fofName.equals("/")) {
                try {
                    return this.listRoots(null)[0];
                }
                catch (Exception exception) {}
            }
            if (fofName.equals(".")) {
                return this.getUserHome();
            }
            String sep = PathUtility.getSeparator((String)folderOrFileName);
            if (fofName.endsWith(sep)) {
                fofName = fofName.substring(0, fofName.length() - sep.length());
            }
            if (fofName.endsWith(":")) {
                try {
                    IHostFile[] roots = this.getRoots(null);
                    int i = 0;
                    while (i < roots.length) {
                        if (roots[i].getAbsolutePath().toLowerCase().startsWith(fofName.toLowerCase())) {
                            return this.getHostFileToRemoteFileAdapter().convertToRemoteFile(this, this.getDefaultContext(), null, roots[i]);
                        }
                        ++i;
                    }
                }
                catch (InterruptedException interruptedException) {}
                return null;
            }
            int lastSep = fofName.lastIndexOf(sep);
            if (lastSep > -1) {
                String name;
                IHostFile node;
                String parentPath = fofName.substring(0, lastSep);
                if (parentPath.length() == 0) {
                    parentPath = "/";
                }
                if ((node = this.getFile(parentPath, name = fofName.substring(lastSep + 1, fofName.length()), monitor)) != null) {
                    IRemoteFile parent = null;
                    node.isRoot();
                    return this.getHostFileToRemoteFileAdapter().convertToRemoteFile(this, this.getDefaultContext(), parent, node);
                }
            }
            return null;
        }
        AbsoluteVirtualPath avp = new AbsoluteVirtualPath(fofName);
        IHostFile node = this.getFile(avp.getPath(), avp.getName(), null);
        if (node != null) {
            return this.getHostFileToRemoteFileAdapter().convertToRemoteFile(this, this.getDefaultContext(), null, node);
        }
        return null;
    }

    protected IRemoteFile getUserHome() {
        if (this._userHome != null) {
            return this._userHome;
        }
        IRemoteFile root = this.getCachedRemoteFile(".");
        if (root != null && !root.isStale()) {
            return root;
        }
        IHostFile userHome = this.getFileService().getUserHome();
        IRemoteFile parent = null;
        if (!userHome.getParentPath().equals(".")) {
            // empty if block
        }
        root = this.getHostFileToRemoteFileAdapter().convertToRemoteFile(this, this.getDefaultContext(), parent, userHome);
        this.cacheRemoteFile(root, ".");
        this._userHome = root;
        return root;
    }

    protected IHostFile[] getFolders(String parentPath, String fileNameFilter, IProgressMonitor monitor) throws SystemMessageException {
        return this.getFileService().getFolders(parentPath, fileNameFilter, monitor);
    }

    protected IHostFile[] getFiles(String parentPath, String fileNameFilter, IProgressMonitor monitor) throws SystemMessageException {
        return this.getFileService().getFiles(parentPath, fileNameFilter, monitor);
    }

    protected IHostFile[] getFilesAndFolders(String parentPath, String fileNameFilter, IProgressMonitor monitor) throws SystemMessageException {
        return this.getFileService().getFilesAndFolders(parentPath, fileNameFilter, monitor);
    }

    protected IHostFile getFile(String parentPath, String fileName, IProgressMonitor monitor) throws SystemMessageException {
        return this.getFileService().getFile(parentPath, fileName, monitor);
    }

    protected IHostFile[] getRoots(IProgressMonitor monitor) throws InterruptedException, SystemMessageException {
        return this.getFileService().getRoots(monitor);
    }

    public IRemoteFile[] listFoldersAndFiles(IRemoteFile parent, String fileNameFilter, IRemoteFileContext context, IProgressMonitor monitor) throws SystemMessageException {
        String parentPath = null;
        parentPath = parent != null ? parent.getAbsolutePath() : "/";
        if (parent != null && !parent.canRead()) {
            SystemMessage msg = RSEUIPlugin.getPluginMessage((String)"RSEF5020").makeSubstitution((Object)parentPath);
            throw new SystemMessageException(msg);
        }
        IHostFile[] results = this.getFilesAndFolders(parentPath, fileNameFilter, monitor);
        Object[] farr = this.getHostFileToRemoteFileAdapter().convertToRemoteFiles(this, context, parent, results);
        if (parent != null) {
            parent.setContents((ISystemContentsType)RemoteChildrenContentsType.getInstance(), fileNameFilter, farr);
        }
        return farr;
    }

    public IRemoteFile[] listFiles(IRemoteFile parent, String fileNameFilter, IRemoteFileContext context, IProgressMonitor monitor) throws SystemMessageException {
        String parentPath = null;
        parentPath = parent != null ? parent.getAbsolutePath() : "/";
        if (parent != null && !parent.canRead()) {
            SystemMessage msg = RSEUIPlugin.getPluginMessage((String)"RSEF5020").makeSubstitution((Object)parentPath);
            throw new SystemMessageException(msg);
        }
        IHostFile[] results = null;
        try {
            results = this.getFiles(parentPath, fileNameFilter, monitor);
        }
        catch (SystemMessageException systemMessageException) {}
        Object[] farr = this.getHostFileToRemoteFileAdapter().convertToRemoteFiles(this, context, parent, results);
        if (parent != null) {
            parent.setContents((ISystemContentsType)RemoteChildrenContentsType.getInstance(), fileNameFilter, farr);
        }
        return farr;
    }

    public IRemoteFile[] listFolders(IRemoteFile parent, String fileNameFilter, IRemoteFileContext context, IProgressMonitor monitor) throws SystemMessageException {
        String parentPath = null;
        parentPath = parent != null ? parent.getAbsolutePath() : "/";
        if (parent != null && !parent.canRead()) {
            SystemMessage msg = RSEUIPlugin.getPluginMessage((String)"RSEF5020").makeSubstitution((Object)parentPath);
            throw new SystemMessageException(msg);
        }
        IHostFile[] results = null;
        try {
            results = this.getFolders(parentPath, fileNameFilter, monitor);
        }
        catch (SystemMessageException systemMessageException) {}
        Object[] farr = this.getHostFileToRemoteFileAdapter().convertToRemoteFiles(this, context, parent, results);
        if (parent != null) {
            parent.setContents((ISystemContentsType)RemoteChildrenContentsType.getInstance(), fileNameFilter, farr);
        }
        return farr;
    }

    public IRemoteFile[] listRoots(IRemoteFileContext context, IProgressMonitor monitor) throws InterruptedException {
        IHostFile[] roots = null;
        try {
            roots = this.getRoots(monitor);
        }
        catch (SystemMessageException systemMessageException) {}
        IRemoteFile[] results = this.getHostFileToRemoteFileAdapter().convertToRemoteFiles(this, context, null, roots);
        return results;
    }

    public void download(IRemoteFile file, String localpath, String encoding, IProgressMonitor monitor) throws SystemMessageException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        String parentPath = file.getParentPath();
        File localFile = new File(localpath);
        this.getFileService().download(parentPath, file.getName(), localFile, this.isBinary(file), file.getEncoding(), monitor);
        if (monitor.isCanceled()) {
            localFile.delete();
        }
    }

    protected boolean isBinary(String localEncoding, String hostEncoding, String remotePath) {
        boolean isText = !hostEncoding.equals(localEncoding) && SystemFileTransferModeRegistry.getInstance().isText(remotePath) && !SystemEncodingUtil.getInstance().isXML(remotePath);
        return !isText;
    }

    protected boolean isBinary(IRemoteFile source) {
        return source.isBinary() || SystemEncodingUtil.getInstance().isXML(source.getAbsolutePath());
    }

    public void upload(String source, String srcEncoding, String remotePath, String rmtEncoding, IProgressMonitor monitor) throws SystemMessageException {
        int slashIndex = remotePath.lastIndexOf(this.getSeparator());
        if (slashIndex > -1) {
            String remoteParentPath = remotePath.substring(0, slashIndex);
            String remoteFileName = remotePath.substring(slashIndex + 1, remotePath.length());
            boolean isBinary = this.isBinary(srcEncoding, rmtEncoding, remotePath);
            if (ArchiveHandlerManager.isVirtual((String)remotePath)) {
                AbsoluteVirtualPath avp = new AbsoluteVirtualPath(remotePath);
                remoteParentPath = avp.getPath();
                remoteFileName = avp.getName();
            }
            this.getFileService().upload(new File(source), remoteParentPath, remoteFileName, isBinary, srcEncoding, rmtEncoding, monitor);
        }
    }

    public void upload(String source, IRemoteFile destination, String encoding, IProgressMonitor monitor) throws SystemMessageException {
        String remoteParentPath = destination.getParentPath();
        String remoteFileName = destination.getName();
        String hostEncoding = destination.getEncoding();
        boolean isBinary = this.isBinary(encoding, hostEncoding, destination.getAbsolutePath());
        if (!destination.canWrite()) {
            SystemMessage msg = RSEUIPlugin.getPluginMessage((String)"RSEF5003").makeSubstitution((Object)remoteFileName, (Object)this.getHostName());
            throw new SystemMessageException(msg);
        }
        this.getFileService().upload(new File(source), remoteParentPath, remoteFileName, isBinary, encoding, hostEncoding, monitor);
    }

    public boolean copy(IRemoteFile sourceFolderOrFile, IRemoteFile targetFolder, String newName, IProgressMonitor monitor) throws SystemMessageException {
        IFileService service = this.getFileService();
        return service.copy(sourceFolderOrFile.getParentPath(), sourceFolderOrFile.getName(), targetFolder.getAbsolutePath(), newName, monitor);
    }

    public boolean copyBatch(IRemoteFile[] sourceFolderOrFiles, IRemoteFile targetFolder, IProgressMonitor monitor) throws SystemMessageException {
        IFileService service = this.getFileService();
        String[] sourceParents = new String[sourceFolderOrFiles.length];
        String[] sourceNames = new String[sourceFolderOrFiles.length];
        int i = 0;
        while (i < sourceFolderOrFiles.length) {
            sourceParents[i] = sourceFolderOrFiles[i].getParentPath();
            sourceNames[i] = sourceFolderOrFiles[i].getName();
            ++i;
        }
        return service.copyBatch(sourceParents, sourceNames, targetFolder.getAbsolutePath(), monitor);
    }

    public IRemoteFile getParentFolder(IRemoteFile folderOrFile, IProgressMonitor monitor) {
        try {
            return this.getRemoteFileObject(folderOrFile.getParentPath(), monitor);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public IRemoteFile createFile(IRemoteFile fileToCreate, IProgressMonitor monitor) throws SystemMessageException {
        IFileService service = this.getFileService();
        String parent = fileToCreate.getParentPath();
        String name = fileToCreate.getName();
        IHostFile newFile = service.createFile(parent, name, monitor);
        return this.getHostFileToRemoteFileAdapter().convertToRemoteFile(this, this.getDefaultContext(), fileToCreate.getParentRemoteFile(), newFile);
    }

    public IRemoteFile createFolder(IRemoteFile folderToCreate, IProgressMonitor monitor) throws SystemMessageException {
        IFileService service = this.getFileService();
        String parent = folderToCreate.getParentPath();
        String name = folderToCreate.getName();
        IHostFile newFolder = service.createFolder(parent, name, monitor);
        return this.getHostFileToRemoteFileAdapter().convertToRemoteFile(this, this.getDefaultContext(), folderToCreate.getParentRemoteFile(), newFolder);
    }

    public IRemoteFile createFolders(IRemoteFile folderToCreate, IProgressMonitor monitor) throws SystemMessageException {
        return this.createFolder(folderToCreate, monitor);
    }

    public boolean delete(IRemoteFile folderOrFile, IProgressMonitor monitor) throws SystemMessageException {
        IFileService service = this.getFileService();
        String parent = folderOrFile.getParentPath();
        String name = folderOrFile.getName();
        boolean result = service.delete(parent, name, monitor);
        folderOrFile.markStale(true);
        return result;
    }

    public boolean deleteBatch(IRemoteFile[] folderOrFiles, IProgressMonitor monitor) throws SystemMessageException {
        String[] parents = new String[folderOrFiles.length];
        String[] names = new String[folderOrFiles.length];
        int i = 0;
        while (i < folderOrFiles.length) {
            parents[i] = folderOrFiles[i].getParentPath();
            names[i] = folderOrFiles[i].getName();
            folderOrFiles[i].markStale(true);
            this.removeCachedRemoteFile(folderOrFiles[i]);
            ++i;
        }
        IFileService service = this.getFileService();
        return service.deleteBatch(parents, names, monitor);
    }

    public boolean rename(IRemoteFile folderOrFile, String newName, IProgressMonitor monitor) throws SystemMessageException {
        this.removeCachedRemoteFile(folderOrFile);
        IFileService service = this.getFileService();
        String srcParent = folderOrFile.getParentPath();
        String oldName = folderOrFile.getName();
        String newPath = String.valueOf(srcParent) + folderOrFile.getSeparator() + newName;
        boolean result = service.rename(srcParent, oldName, newName, monitor);
        folderOrFile.getHostFile().renameTo(newPath);
        return result;
    }

    public boolean move(IRemoteFile sourceFolderOrFile, IRemoteFile targetFolder, String newName, IProgressMonitor monitor) throws SystemMessageException {
        IFileService service = this.getFileService();
        String srcParent = sourceFolderOrFile.getParentPath();
        String srcName = sourceFolderOrFile.getName();
        String tgtParent = targetFolder.getAbsolutePath();
        this.removeCachedRemoteFile(sourceFolderOrFile);
        boolean result = service.move(srcParent, srcName, tgtParent, newName, monitor);
        sourceFolderOrFile.markStale(true);
        targetFolder.markStale(true);
        return result;
    }

    public boolean setLastModified(IRemoteFile folderOrFile, long newDate, IProgressMonitor monitor) throws SystemMessageException {
        String name = folderOrFile.getName();
        String parent = folderOrFile.getParentPath();
        return this._hostFileService.setLastModified(parent, name, newDate, monitor);
    }

    public boolean setReadOnly(IRemoteFile folderOrFile, boolean readOnly, IProgressMonitor monitor) throws SystemMessageException {
        String name = folderOrFile.getName();
        String parent = folderOrFile.getParentPath();
        return this._hostFileService.setReadOnly(parent, name, readOnly, monitor);
    }

    public ILanguageUtilityFactory getLanguageUtilityFactory() {
        if (this._languageUtilityFactory == null) {
            this._languageUtilityFactory = ((IFileServiceSubSystemConfiguration)this.getParentRemoteFileSubSystemConfiguration()).getLanguageUtilityFactory(this);
        }
        return this._languageUtilityFactory;
    }

    public void setLanguageUtilityFactory(ILanguageUtilityFactory factory) {
        this._languageUtilityFactory = factory;
    }

    public void search(IHostSearchResultConfiguration searchConfig) {
        ISearchService searchService = this.getSearchService();
        if (searchService != null) {
            SearchJob job = new SearchJob(searchConfig, searchService, this.getFileService());
            job.schedule();
        }
    }

    public void cancelSearch(IHostSearchResultConfiguration searchConfig) {
        ISearchService searchService = this.getSearchService();
        if (searchService != null) {
            searchService.cancelSearch(searchConfig, null);
        }
    }

    public IHostSearchResultConfiguration createSearchConfiguration(IHostSearchResultSet resultSet, Object searchTarget, SystemSearchString searchString) {
        IFileServiceSubSystemConfiguration factory;
        ISearchService searchService = this.getSearchService();
        if (searchService != null && (factory = (IFileServiceSubSystemConfiguration)this.getParentRemoteFileSubSystemConfiguration()) != null) {
            return factory.createSearchConfiguration(this.getHost(), resultSet, searchTarget, searchString);
        }
        return null;
    }

    public void switchServiceFactory(IServiceSubSystemConfiguration fact) {
        if (fact != this.getSubSystemConfiguration() && fact instanceof IFileServiceSubSystemConfiguration) {
            IFileServiceSubSystemConfiguration factory = (IFileServiceSubSystemConfiguration)fact;
            try {
                this._cachedRemoteFiles.clear();
                this.disconnect();
            }
            catch (Exception exception) {}
            this._languageUtilityFactory = null;
            IHost host = this.getHost();
            this.setSubSystemConfiguration(factory);
            IConnectorService oldConnectorService = this.getConnectorService();
            oldConnectorService.deregisterSubSystem((ISubSystem)this);
            IConnectorService newConnectorService = factory.getConnectorService(host);
            this.setConnectorService(newConnectorService);
            oldConnectorService.commit();
            newConnectorService.commit();
            this.setName(factory.getName());
            this.setFileService(factory.getFileService(host));
            this.setHostFileToRemoteFileAdapter(factory.getHostFileAdapter());
            this.setSearchService(factory.getSearchService(host));
        }
    }

    public Class getServiceType() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.services.files.IFileService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public void initializeSubSystem(IProgressMonitor monitor) {
        super.initializeSubSystem(monitor);
        this.getFileService().initService(monitor);
    }

    public void uninitializeSubSystem(IProgressMonitor monitor) {
        super.uninitializeSubSystem(monitor);
        this.getFileService().uninitService(monitor);
        this._userHome = null;
    }

    public String getRemoteEncoding() {
        try {
            IHost host = this.getHost();
            String encoding = host.getDefaultEncoding(false);
            if (encoding == null && (encoding = this.getFileService().getEncoding(null)) != null) {
                host.setDefaultEncoding(encoding, true);
            }
            if (encoding != null) {
                return encoding;
            }
            return super.getRemoteEncoding();
        }
        catch (SystemMessageException e) {
            SystemBasePlugin.logMessage((SystemMessage)e.getSystemMessage());
            return super.getRemoteEncoding();
        }
    }

    public InputStream getInputStream(String remoteParent, String remoteFile, boolean isBinary, IProgressMonitor monitor) throws SystemMessageException {
        return this.getFileService().getInputStream(remoteParent, remoteFile, isBinary, monitor);
    }

    public OutputStream getOutputStream(String remoteParent, String remoteFile, boolean isBinary, IProgressMonitor monitor) throws SystemMessageException {
        return this.getFileService().getOutputStream(remoteParent, remoteFile, isBinary, monitor);
    }
}

