/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.widgets.services;

import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.rse.internal.ui.SystemResources;
import org.eclipse.rse.internal.ui.view.SystemPropertySheetForm;
import org.eclipse.rse.ui.SystemBaseForm;
import org.eclipse.rse.ui.messages.ISystemMessageLine;
import org.eclipse.rse.ui.widgets.services.ServiceElement;
import org.eclipse.rse.ui.widgets.services.ServiceTableContentProvider;
import org.eclipse.rse.ui.widgets.services.ServiceTableLabelProvider;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;

public class ConnectorServicesForm
extends SystemBaseForm {
    private TreeViewer _serviceViewer;
    private SystemPropertySheetForm _propertiesViewer;
    private Text _descriptionVerbiage;
    private String _serviceTooltip = SystemResources.RESID_SERVICESFORM_CONNECTORSERVICES_TOOLTIP;
    private String _propertiesTooltip = SystemResources.RESID_SERVICESFORM_PROPERTIES_TOOLTIP;

    public ConnectorServicesForm(ISystemMessageLine msgLine) {
        super(null, msgLine);
    }

    public Control createContents(Composite parent) {
        SashForm sashComposite = new SashForm(parent, 512);
        GridData data = new GridData(4, 4, true, true);
        sashComposite.setLayoutData((Object)data);
        Composite serviceViewerComposite = new Composite((Composite)sashComposite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        serviceViewerComposite.setLayout((Layout)layout);
        serviceViewerComposite.setLayoutData((Object)new GridData(768));
        Label servicesLabel = new Label(serviceViewerComposite, 0);
        servicesLabel.setText(SystemResources.RESID_PROPERTIES_SERVICES_LABEL);
        this.createServiceViewer(serviceViewerComposite);
        Composite servicePropertiesComposite = new Composite((Composite)sashComposite, 0);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        servicePropertiesComposite.setLayout((Layout)layout);
        servicePropertiesComposite.setLayoutData((Object)new GridData(768));
        Label propertiesLabel = new Label(servicePropertiesComposite, 0);
        propertiesLabel.setText(SystemResources.RESID_PROPERTIES_PROPERTIES_LABEL);
        this.createPropertiesViewer(servicePropertiesComposite);
        Composite descriptionComposite = new Composite((Composite)sashComposite, 0);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        descriptionComposite.setLayout((Layout)layout);
        descriptionComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        Label descriptionLabel = new Label(descriptionComposite, 0);
        descriptionLabel.setText(SystemResources.RESID_PROPERTIES_DESCRIPTION_LABEL);
        this._descriptionVerbiage = new Text(descriptionComposite, 2120);
        this._descriptionVerbiage.setText(this.getCurrentVerbiage());
        this._descriptionVerbiage.setEditable(false);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.widthHint = 150;
        gridData.verticalAlignment = 1;
        this._descriptionVerbiage.setLayoutData((Object)data);
        sashComposite.setWeights(new int[]{20, 30, 10});
        this._serviceViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                ConnectorServicesForm.this._propertiesViewer.selectionChanged(selection);
                ConnectorServicesForm.this._descriptionVerbiage.setText(ConnectorServicesForm.this.getCurrentVerbiage());
            }
        });
        return this._serviceViewer.getControl();
    }

    private void createServiceViewer(Composite parent) {
        this._serviceViewer = new TreeViewer(parent, 2048);
        Tree tableTree = this._serviceViewer.getTree();
        tableTree.setLayout((Layout)new FillLayout());
        tableTree.setToolTipText(this._serviceTooltip);
        this._serviceViewer.setAutoExpandLevel(-1);
        this._serviceViewer.setContentProvider((IContentProvider)new ServiceTableContentProvider());
        this._serviceViewer.setLabelProvider((IBaseLabelProvider)new ServiceTableLabelProvider());
    }

    private void createPropertiesViewer(Composite parent) {
        this._propertiesViewer = new SystemPropertySheetForm(this.getShell(), parent, 2048, this.getMessageLine(), 1, 1);
        this._propertiesViewer.setToolTipText(this._propertiesTooltip);
    }

    public void init(ServiceElement root) {
        this._serviceViewer.setInput((Object)root);
    }

    public boolean performOk() {
        return true;
    }

    protected String getCurrentVerbiage() {
        if (this._serviceViewer == null) {
            return "";
        }
        IStructuredSelection serviceSelection = (IStructuredSelection)this._serviceViewer.getSelection();
        if (serviceSelection == null || serviceSelection.isEmpty()) {
            return "";
        }
        String description = ((ServiceElement)serviceSelection.getFirstElement()).getDescription();
        return description != null ? description : "";
    }
}

