/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.ui.view.scratchpad;

import java.util.Iterator;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.events.ISystemResourceChangeEvent;
import org.eclipse.rse.core.events.SystemResourceChangeEvent;
import org.eclipse.rse.internal.ui.SystemResources;
import org.eclipse.rse.internal.ui.view.scratchpad.BrowseAction;
import org.eclipse.rse.internal.ui.view.scratchpad.SystemScratchpadView;
import org.eclipse.rse.ui.RSEUIPlugin;

public class ClearSelectedAction
extends BrowseAction {
    public ClearSelectedAction(SystemScratchpadView view) {
        super(view, SystemResources.ACTION_CLEAR_SELECTED_LABEL, RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.clearselectedIcon"));
    }

    public void checkEnabledState() {
        StructuredSelection selection;
        if (this._scratchPad.hasChildren() && (selection = (StructuredSelection)this._view.getSelection()) != null) {
            Iterator iterator = selection.iterator();
            while (iterator.hasNext()) {
                TreeSelection treeSelection;
                TreePath[] paths;
                Object obj = iterator.next();
                if (!this._scratchPad.contains(obj)) {
                    this.setEnabled(false);
                    return;
                }
                if (!(selection instanceof TreeSelection) || (paths = (treeSelection = (TreeSelection)selection).getPathsFor(obj)).length <= 0 || paths[0].getSegmentCount() == 1) continue;
                this.setEnabled(false);
                return;
            }
            this.setEnabled(true);
            return;
        }
        this.setEnabled(false);
    }

    public void run() {
        this.clear();
    }

    private void clear() {
        StructuredSelection selection = (StructuredSelection)this._view.getSelection();
        if (selection != null) {
            Iterator iterator = selection.iterator();
            while (iterator.hasNext()) {
                this._scratchPad.removeChild(iterator.next());
            }
            RSECorePlugin.getTheSystemRegistry().fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent((Object)this._scratchPad, 82, (Object)this._scratchPad));
            this._view.setSelection(null);
        }
    }
}

