/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.serial;

import gnu.io.CommPortIdentifier;
import gnu.io.CommPortOwnershipListener;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.SerialPortEventListener;
import java.util.Arrays;
import java.util.Enumeration;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalControl;
import org.eclipse.tm.internal.terminal.provisional.api.Logger;
import org.eclipse.tm.internal.terminal.provisional.api.TerminalState;
import org.eclipse.tm.internal.terminal.serial.ISerialSettings;
import org.eclipse.tm.internal.terminal.serial.SerialConnector;
import org.eclipse.tm.internal.terminal.serial.SerialPortHandler;

public class SerialConnectWorker
extends Thread {
    private final ITerminalControl fControl;
    private final SerialConnector fConn;

    public SerialConnectWorker(SerialConnector conn, ITerminalControl control) {
        this.fControl = control;
        this.fConn = conn;
    }

    void addPort(String name) {
        String sep = System.getProperty("path.separator", ":");
        String names = System.getProperty("gnu.io.rxtx.SerialPorts");
        if (names == null) {
            StringBuffer buffer = new StringBuffer();
            boolean sepNeeded = false;
            Enumeration portIdEnum = CommPortIdentifier.getPortIdentifiers();
            while (portIdEnum.hasMoreElements()) {
                CommPortIdentifier identifier = (CommPortIdentifier)portIdEnum.nextElement();
                if (identifier.getPortType() != 1) continue;
                if (sepNeeded) {
                    buffer.append(sep);
                } else {
                    sepNeeded = true;
                }
                buffer.append(identifier.getName());
            }
            if (sepNeeded) {
                buffer.append(sep);
            }
            buffer.append(name);
            System.setProperty("gnu.io.rxtx.SerialPorts", buffer.toString());
        } else if (!Arrays.asList(names.split(sep)).contains(name)) {
            System.setProperty("gnu.io.rxtx.SerialPorts", String.valueOf(names) + sep + name);
        } else {
            return;
        }
        CommPortIdentifier.getPortIdentifiers();
    }

    /*
     * Loose catch block
     */
    public void run() {
        block16: {
            String portName = null;
            String strID = this.getClass().getPackage().getName();
            SerialPort serialPort = null;
            try {
                try {
                    this.fControl.setState(TerminalState.OPENED);
                    ISerialSettings s = this.fConn.getSerialSettings();
                    portName = s.getSerialPort();
                    try {
                        this.fConn.setSerialPortIdentifier(CommPortIdentifier.getPortIdentifier((String)portName));
                    }
                    catch (NoSuchPortException noSuchPortException) {
                        this.addPort(portName);
                        this.fConn.setSerialPortIdentifier(CommPortIdentifier.getPortIdentifier((String)portName));
                    }
                    this.fConn.setSerialPortHandler(new SerialPortHandler(this.fConn, this.fControl));
                    this.fConn.setSerialPortIdentifier(CommPortIdentifier.getPortIdentifier((String)portName));
                    int timeoutInMs = s.getTimeout() * 1000;
                    serialPort = (SerialPort)this.fConn.getSerialPortIdentifier().open(strID, timeoutInMs);
                    serialPort.setSerialPortParams(s.getBaudRate(), s.getDataBits(), s.getStopBits(), s.getParity());
                    serialPort.setFlowControlMode(s.getFlowControl());
                    serialPort.addEventListener((SerialPortEventListener)this.fConn.getSerialPortHandler());
                    serialPort.notifyOnDataAvailable(true);
                    this.fConn.getSerialPortIdentifier().addPortOwnershipListener((CommPortOwnershipListener)this.fConn.getSerialPortHandler());
                    this.fConn.setSerialPort(serialPort);
                    this.fControl.setState(TerminalState.CONNECTED);
                }
                catch (PortInUseException portInUseException) {
                    this.fControl.setState(TerminalState.CLOSED);
                    String theOwner = portInUseException.currentOwner;
                    if (strID.equals(theOwner)) {
                        theOwner = "another Terminal View";
                    }
                    this.fControl.displayTextInTerminal("Connection Error!\r\n" + portName + " is already in use by " + theOwner);
                    this.fConn.doneConnect();
                }
                catch (NoSuchPortException e) {
                    this.fControl.setState(TerminalState.CLOSED);
                    String msg = e.getMessage();
                    if (msg == null) {
                        msg = portName;
                    }
                    this.fControl.displayTextInTerminal("No such port: \"" + msg + "\"\r\n");
                    this.fConn.doneConnect();
                }
                catch (Exception exception) {
                    Logger.logException((Exception)exception);
                    if (serialPort != null) {
                        try {
                            serialPort.removeEventListener();
                            Thread.sleep(50L);
                        }
                        catch (Exception e) {
                            Logger.logException((Exception)e);
                        }
                        serialPort.close();
                        this.fConn.getSerialPortIdentifier().removePortOwnershipListener((CommPortOwnershipListener)this.fConn.getSerialPortHandler());
                    }
                    this.fControl.setState(TerminalState.CLOSED);
                    this.fConn.doneConnect();
                    break block16;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
            }
            finally {
                this.fConn.doneConnect();
            }
        }
    }
}

