/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.provisional.api;

import java.io.OutputStream;
import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.tm.internal.terminal.provisional.api.ISettingsPage;
import org.eclipse.tm.internal.terminal.provisional.api.ISettingsStore;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalConnector;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalConnectorInfo;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalControl;
import org.eclipse.tm.internal.terminal.provisional.api.Logger;

public class TerminalConnectorExtension {
    private static ITerminalConnector createConnector(IConfigurationElement config) throws Exception {
        return (ITerminalConnector)config.createExecutableExtension("class");
    }

    public static ITerminalConnectorInfo[] getTerminalConnectors() {
        IConfigurationElement[] config = RegistryFactory.getRegistry().getConfigurationElementsFor("org.eclipse.tm.terminal.terminalConnector");
        ArrayList<TerminalConnectorInfo> result = new ArrayList<TerminalConnectorInfo>();
        int i = 0;
        while (i < config.length) {
            result.add(new TerminalConnectorInfo(new TerminalConnectorProxy(config[i])));
            ++i;
        }
        return result.toArray(new ITerminalConnectorInfo[result.size()]);
    }

    private static class TerminalConnectorInfo
    implements ITerminalConnectorInfo {
        TerminalConnectorProxy fProxy;

        TerminalConnectorInfo(TerminalConnectorProxy proxy) {
            this.fProxy = proxy;
        }

        public ITerminalConnector getConnector() {
            return this.fProxy;
        }

        public String getId() {
            return this.fProxy.getId();
        }

        public String getName() {
            return this.fProxy.getName();
        }

        public String getInitializationErrorMessage() {
            return this.fProxy.getLocalizedErrorMessage();
        }

        public boolean isInitialized() {
            return this.fProxy.isInitialized();
        }
    }

    private static class TerminalConnectorProxy
    implements ITerminalConnector {
        private ITerminalConnector fConnector;
        private final IConfigurationElement fConfig;
        private Exception fException;
        private ISettingsStore fStore;

        TerminalConnectorProxy(IConfigurationElement config) {
            this.fConfig = config;
        }

        public String getLocalizedErrorMessage() {
            this.getConnector();
            if (this.fException != null) {
                return this.fException.getLocalizedMessage();
            }
            return null;
        }

        public String getId() {
            String id = this.fConfig.getAttribute("id");
            if (id == null || id.length() == 0) {
                id = this.fConfig.getAttribute("class");
            }
            return id;
        }

        public String getName() {
            String name = this.fConfig.getAttribute("name");
            if (name == null || name.length() == 0) {
                name = this.getId();
            }
            return name;
        }

        private ITerminalConnector getConnector() {
            if (!this.isInitialized()) {
                try {
                    this.fConnector = TerminalConnectorExtension.createConnector(this.fConfig);
                    this.fConnector.initialize();
                }
                catch (Exception e) {
                    this.fConnector = null;
                    this.fException = e;
                    Logger.logException(e);
                }
                if (this.fConnector != null && this.fStore != null) {
                    this.fConnector.load(this.fStore);
                }
            }
            return this.fConnector;
        }

        private boolean isInitialized() {
            return this.fConnector != null || this.fException != null;
        }

        public void connect(ITerminalControl control) {
            this.getConnector().connect(control);
        }

        public void disconnect() {
            this.getConnector().disconnect();
        }

        public OutputStream getOutputStream() {
            return this.getConnector().getOutputStream();
        }

        public String getSettingsSummary() {
            if (this.fConnector != null) {
                return this.getConnector().getSettingsSummary();
            }
            return "?";
        }

        public boolean isLocalEcho() {
            return this.getConnector().isLocalEcho();
        }

        public void load(ISettingsStore store) {
            if (this.fConnector == null) {
                this.fStore = store;
            } else {
                this.getConnector().load(store);
            }
        }

        public ISettingsPage makeSettingsPage() {
            return this.getConnector().makeSettingsPage();
        }

        public void save(ISettingsStore store) {
            if (this.fConnector != null) {
                this.getConnector().save(store);
            }
        }

        public void setTerminalSize(int newWidth, int newHeight) {
            if (this.fConnector != null) {
                this.fConnector.setTerminalSize(newWidth, newHeight);
            }
        }

        public void initialize() throws Exception {
            throw new IllegalStateException("Connector already initialized!");
        }
    }
}

