/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.textcanvas;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.tm.internal.terminal.textcanvas.VirtualCanvas;

public abstract class GridCanvas
extends VirtualCanvas {
    private int fCellWidth;
    private int fCellHeight;

    public GridCanvas(Composite parent, int style) {
        super(parent, style);
        this.addListener(37, new Listener(){

            public void handleEvent(Event event) {
                if (GridCanvas.this.getVerticalBar().isVisible()) {
                    int delta = -GridCanvas.this.fCellHeight;
                    if (event.count < 0) {
                        delta = -delta;
                    }
                    GridCanvas.this.scrollYDelta(delta);
                }
                event.doit = false;
            }
        });
    }

    protected void paint(GC gc) {
        int rowLast;
        Rectangle clipping = gc.getClipping();
        if (clipping.width == 0 || clipping.height == 0) {
            return;
        }
        Rectangle clientArea = this.getScreenRectInVirtualSpace();
        int xOffset = clientArea.x;
        int yOffset = clientArea.y;
        int colFirst = this.virtualXToCell(xOffset + clipping.x);
        if (colFirst > this.getCols()) {
            colFirst = this.getCols();
        }
        int rowFirst = this.virtualYToCell(yOffset + clipping.y);
        int colLast = this.virtualXToCell(xOffset + clipping.x + clipping.width + this.fCellWidth);
        if (colLast > this.getCols()) {
            colLast = this.getCols();
        }
        if ((rowLast = this.virtualYToCell(yOffset + clipping.y + clipping.height + this.fCellHeight)) > this.getRows()) {
            rowLast = this.getRows();
        }
        int row = rowFirst;
        while (row <= rowLast) {
            int cx = colFirst * this.fCellWidth - xOffset;
            int cy = row * this.fCellHeight - yOffset;
            this.drawLine(gc, row, cx, cy, colFirst, colLast);
            ++row;
        }
        this.paintUnoccupiedSpace(gc, clipping);
    }

    abstract void drawLine(GC var1, int var2, int var3, int var4, int var5, int var6);

    protected abstract int getRows();

    protected abstract int getCols();

    protected void setCellWidth(int cellWidth) {
        this.fCellWidth = cellWidth;
        this.getHorizontalBar().setIncrement(this.fCellWidth);
    }

    public int getCellWidth() {
        return this.fCellWidth;
    }

    protected void setCellHeight(int cellHeight) {
        this.fCellHeight = cellHeight;
        this.getVerticalBar().setIncrement(this.fCellHeight);
    }

    public int getCellHeight() {
        return this.fCellHeight;
    }

    int virtualXToCell(int x) {
        return x / this.fCellWidth;
    }

    int virtualYToCell(int y) {
        return y / this.fCellHeight;
    }

    protected Point screenPointToCell(int x, int y) {
        x = this.screenXtoVirtual(x) / this.fCellWidth;
        y = this.screenYtoVirtual(y) / this.fCellHeight;
        return new Point(x, y);
    }

    Point screenPointToCell(Point point) {
        return this.screenPointToCell(point.x, point.y);
    }

    protected Point cellToOriginOnScreen(int x, int y) {
        x = this.virtualXtoScreen(this.fCellWidth * x);
        y = this.virtualYtoScreen(this.fCellHeight * y);
        return new Point(x, y);
    }

    Point cellToOriginOnScreen(Point cell) {
        return this.cellToOriginOnScreen(cell.x, cell.y);
    }

    Rectangle getCellScreenRect(Point cell) {
        return this.getCellScreenRect(cell.x, cell.y);
    }

    Rectangle getCellScreenRect(int x, int y) {
        x = this.fCellWidth * this.virtualXtoScreen(x);
        y = this.fCellHeight * this.virtualYtoScreen(y);
        return new Rectangle(x, y, this.fCellWidth, this.fCellHeight);
    }

    protected Rectangle getCellVirtualRect(Point cell) {
        return this.getCellVirtualRect(cell.x, cell.y);
    }

    Rectangle getCellVirtualRect(int x, int y) {
        x = this.fCellWidth * x;
        y = this.fCellHeight * y;
        return new Rectangle(x, y, this.fCellWidth, this.fCellHeight);
    }

    protected void viewRectangleChanged(int x, int y, int width, int height) {
        int yE;
        int cellX = this.virtualXToCell(x);
        int cellY = this.virtualYToCell(y);
        int xE = this.virtualXToCell(x + this.fCellWidth + width - 1);
        if (xE > this.getCols()) {
            xE = this.getCols();
        }
        if ((yE = this.virtualYToCell(y + this.fCellHeight + height - 1)) > this.getRows()) {
            yE = this.getRows();
        }
        this.visibleCellRectangleChanged(cellX, cellY, xE - cellX, yE - cellY);
    }

    protected void visibleCellRectangleChanged(int x, int y, int width, int height) {
    }
}

