/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.core;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.rse.core.AbstractRSESystemType;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.SystemSignonInformation;
import org.eclipse.rse.internal.core.RSECoreMessages;

public class PasswordPersistenceManager {
    private static final String SERVER_URL = "file://rse";
    private static final String AUTH_SCHEME = "";
    public static final int RC_OK = 0;
    public static final int RC_ALREADY_EXISTS = 1;
    public static final int RC_ERROR = -1;
    public static final IRSESystemType DEFAULT_SYSTEM_TYPE = new DefaultSystemType();
    public static final String DEFAULT_USER_NAME = "DEFAULT_USER";
    private String newURL = null;
    private static PasswordPersistenceManager _instance;
    private RegisteredSystemType[] systemTypes;

    private PasswordPersistenceManager() {
        String userName = System.getProperty("user.name");
        if (userName == null) {
            userName = DEFAULT_USER_NAME;
        }
        this.newURL = SERVER_URL + userName;
    }

    public static final synchronized PasswordPersistenceManager getInstance() {
        if (_instance == null) {
            _instance = new PasswordPersistenceManager();
            _instance.initExtensions();
        }
        return _instance;
    }

    private void initExtensions() {
        IRSESystemType[] sysTypes = RSECorePlugin.getTheCoreRegistry().getSystemTypes();
        this.systemTypes = new RegisteredSystemType[sysTypes.length];
        int i = 0;
        while (i < sysTypes.length) {
            this.systemTypes[i] = new RegisteredSystemType(sysTypes[i], true);
            ++i;
        }
    }

    public void remove(SystemSignonInformation info) {
        this.remove(info.getSystemType(), info.getHostname(), info.getUserId());
    }

    public void remove(IRSESystemType systemtype, String hname, String userid) {
        Map passwords;
        String hostname = hname;
        if (!this.isUserIDCaseSensitive(systemtype)) {
            userid = userid.toUpperCase();
        }
        if ((passwords = this.getPasswordMap(systemtype)) != null) {
            if (this.removePassword(passwords, hostname, userid)) {
                this.savePasswordMap(systemtype.getId(), passwords);
            }
        } else if (!DEFAULT_SYSTEM_TYPE.equals(systemtype)) {
            this.remove(DEFAULT_SYSTEM_TYPE, hostname, userid);
        }
    }

    public boolean passwordExists(IRSESystemType systemtype, String hostname, String userid) {
        return this.passwordExists(systemtype, hostname, userid, true);
    }

    public boolean passwordExists(IRSESystemType systemtype, String hname, String userid, boolean checkDefault) {
        String hostname = hname;
        return this.find(systemtype, hostname, userid) != null;
    }

    public int add(SystemSignonInformation info, boolean overwrite) {
        return this.add(info, overwrite, false);
    }

    public int add(SystemSignonInformation info, boolean overwrite, boolean updateDefault) {
        IRSESystemType systemtype = info.getSystemType();
        if (!this.isUserIDCaseSensitive(systemtype)) {
            info.setUserId(info.getUserId().toUpperCase());
        }
        String hostname = info.getHostname();
        String userid = info.getUserId();
        Map<String, String> passwords = this.getPasswordMap(systemtype);
        String passwordKey = this.getPasswordKey(hostname, userid);
        if (passwords != null) {
            String defaultPassword;
            Map defaultPasswords;
            String password = this.getPassword(passwords, hostname, userid);
            if (password != null) {
                if (!overwrite) {
                    return 1;
                }
                this.removePassword(passwords, hostname, userid);
            } else if (updateDefault && (defaultPasswords = this.getPasswordMap(DEFAULT_SYSTEM_TYPE)) != null && (defaultPassword = (String)defaultPasswords.get(passwordKey)) != null) {
                if (!overwrite) {
                    return 1;
                }
                defaultPasswords.remove(passwordKey);
                passwords = defaultPasswords;
                systemtype = DEFAULT_SYSTEM_TYPE;
            }
        } else {
            passwords = new HashMap<String, String>(5);
        }
        passwords.put(passwordKey, info.getPassword());
        this.savePasswordMap(systemtype.getId(), passwords);
        return 0;
    }

    private Map getPasswordMap(IRSESystemType systemType) {
        Map passwords = null;
        String systemTypeId = systemType.getId();
        try {
            URL serverURL = new URL(this.newURL);
            passwords = Platform.getAuthorizationInfo((URL)serverURL, (String)systemTypeId, (String)AUTH_SCHEME);
            if (passwords == null) {
                URL oldServerURL1 = new URL(SERVER_URL + ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString());
                passwords = Platform.getAuthorizationInfo((URL)oldServerURL1, (String)systemTypeId, (String)AUTH_SCHEME);
                if (passwords != null) {
                    this.savePasswordMap(systemTypeId, passwords);
                } else {
                    URL oldServerURL2 = new URL(SERVER_URL);
                    passwords = Platform.getAuthorizationInfo((URL)oldServerURL2, (String)systemTypeId, (String)AUTH_SCHEME);
                    if (passwords != null) {
                        this.savePasswordMap(systemTypeId, passwords);
                    }
                }
            }
        }
        catch (MalformedURLException e) {
            RSECorePlugin.getDefault().getLogger().logError("PasswordPersistenceManager.getPasswordMap", e);
        }
        return passwords;
    }

    private void savePasswordMap(String systemTypeId, Map passwords) {
        try {
            URL serverURL = new URL(this.newURL);
            Platform.flushAuthorizationInfo((URL)serverURL, (String)systemTypeId, (String)AUTH_SCHEME);
            Platform.addAuthorizationInfo((URL)serverURL, (String)systemTypeId, (String)AUTH_SCHEME, (Map)passwords);
        }
        catch (MalformedURLException e) {
            RSECorePlugin.getDefault().getLogger().logError("PasswordPersistenceManager.savePasswordMap", e);
        }
        catch (CoreException e) {
            RSECorePlugin.getDefault().getLogger().logError("PasswordPersistenceManager.savePasswordMap", e);
        }
    }

    public SystemSignonInformation find(IRSESystemType systemtype, String hostname, String userid) {
        return this.find(systemtype, hostname, userid, true);
    }

    private boolean removePassword(Map passwords, String hostname, String userid) {
        boolean removed = false;
        String password = null;
        String passwordKey = this.getPasswordKey(hostname, userid);
        password = (String)passwords.get(passwordKey);
        if (password != null) {
            passwords.remove(passwordKey);
            removed = true;
        } else {
            String phostname = hostname.toUpperCase();
            Iterator keys = passwords.keySet().iterator();
            while (keys.hasNext() && password == null) {
                String key = (String)keys.next();
                if (key.equalsIgnoreCase(passwordKey)) {
                    password = (String)passwords.get(key);
                } else {
                    String qphost;
                    String qkhost;
                    String khostname = PasswordPersistenceManager.getHostnameFromPasswordKey(key).toUpperCase();
                    String kuid = PasswordPersistenceManager.getUserIdFromPasswordKey(key);
                    if (kuid.equalsIgnoreCase(userid) && (khostname.startsWith(phostname) || phostname.startsWith(khostname)) && (qkhost = RSECorePlugin.getQualifiedHostName(khostname)).equals(qphost = RSECorePlugin.getQualifiedHostName(phostname))) {
                        password = (String)passwords.get(key);
                    }
                }
                if (password == null) continue;
                passwords.remove(key);
                removed = true;
            }
        }
        return removed;
    }

    private String getPassword(Map passwords, String hostname, String userid) {
        String password = null;
        String passwordKey = this.getPasswordKey(hostname, userid);
        password = (String)passwords.get(passwordKey);
        if (password != null) {
            return password;
        }
        String phostname = hostname.toUpperCase();
        Iterator keys = passwords.keySet().iterator();
        while (keys.hasNext() && password == null) {
            String qphost;
            String qkhost;
            String key = (String)keys.next();
            if (key.equalsIgnoreCase(passwordKey)) {
                password = (String)passwords.get(key);
                continue;
            }
            String khostname = PasswordPersistenceManager.getHostnameFromPasswordKey(key).toUpperCase();
            String kuid = PasswordPersistenceManager.getUserIdFromPasswordKey(key);
            if (!kuid.equalsIgnoreCase(userid) || !khostname.startsWith(phostname) && !phostname.startsWith(khostname) || !(qkhost = RSECorePlugin.getQualifiedHostName(khostname)).equals(qphost = RSECorePlugin.getQualifiedHostName(phostname))) continue;
            password = (String)passwords.get(key);
        }
        return password;
    }

    public SystemSignonInformation find(IRSESystemType systemtype, String hname, String userid, boolean checkDefault) {
        String password;
        Map passwords;
        String hostname = hname;
        if (!this.isUserIDCaseSensitive(systemtype) && userid != null) {
            userid = userid.toUpperCase();
        }
        if ((passwords = this.getPasswordMap(systemtype)) != null && (password = this.getPassword(passwords, hostname, userid)) != null) {
            return new SystemSignonInformation(hostname, userid, password, systemtype);
        }
        if (checkDefault && !DEFAULT_SYSTEM_TYPE.equals(systemtype)) {
            return this.find(DEFAULT_SYSTEM_TYPE, hostname, userid, false);
        }
        return null;
    }

    private String getPasswordKey(String hname, String userid) {
        String hostname = hname;
        StringBuffer buffer = new StringBuffer(hostname);
        buffer.append("//");
        buffer.append(userid);
        return buffer.toString();
    }

    private static String getHostnameFromPasswordKey(String passwordKey) {
        int sepIndex = passwordKey.indexOf("//");
        return passwordKey.substring(0, sepIndex);
    }

    private static String getUserIdFromPasswordKey(String passwordKey) {
        int sepIndex = passwordKey.indexOf("//");
        return passwordKey.substring(sepIndex + 2, passwordKey.length());
    }

    public boolean isUserIDCaseSensitive(IRSESystemType systemType) {
        int i = 0;
        while (i < this.systemTypes.length) {
            if (this.systemTypes[i].getSystemType().equals(systemType)) {
                return this.systemTypes[i].isUserIDCaseSensitive();
            }
            ++i;
        }
        return true;
    }

    public IRSESystemType[] getRegisteredSystemTypes() {
        IRSESystemType[] types = new IRSESystemType[this.systemTypes.length + 1];
        types[0] = DEFAULT_SYSTEM_TYPE;
        int i = 0;
        while (i < this.systemTypes.length) {
            types[i + 1] = this.systemTypes[i].getSystemType();
            ++i;
        }
        return types;
    }

    public List getSavedUserIDs() {
        int separator;
        String key;
        Map passwords;
        ArrayList<SystemSignonInformation> savedUserIDs = new ArrayList<SystemSignonInformation>();
        int i = 0;
        while (i < this.systemTypes.length) {
            passwords = this.getPasswordMap(this.systemTypes[i].getSystemType());
            if (passwords != null) {
                Iterator keys = passwords.keySet().iterator();
                while (keys.hasNext()) {
                    key = (String)keys.next();
                    separator = key.indexOf("//");
                    savedUserIDs.add(new SystemSignonInformation(key.substring(0, separator), key.substring(separator + 2), this.systemTypes[i].getSystemType()));
                }
            }
            ++i;
        }
        passwords = this.getPasswordMap(DEFAULT_SYSTEM_TYPE);
        if (passwords != null) {
            Iterator keys = passwords.keySet().iterator();
            while (keys.hasNext()) {
                key = (String)keys.next();
                separator = key.indexOf("//");
                savedUserIDs.add(new SystemSignonInformation(key.substring(0, separator), key.substring(separator + 2), DEFAULT_SYSTEM_TYPE));
            }
        }
        return savedUserIDs;
    }

    private static class DefaultSystemType
    extends AbstractRSESystemType
    implements IRSESystemType {
        private static final String DEFAULT_ID = "DEFAULT";

        private DefaultSystemType() {
            super(DEFAULT_ID, DEFAULT_ID, RSECoreMessages.DefaultSystemType_Label, null, null);
        }

        public String getId() {
            return DEFAULT_ID;
        }

        public String[] getSubsystemConfigurationIds() {
            return null;
        }

        public Object getAdapter(Class adapter) {
            return null;
        }
    }

    private class RegisteredSystemType {
        private IRSESystemType _systemType;
        private boolean _userIDCaseSensitive;

        protected RegisteredSystemType(IRSESystemType systemType, boolean caseSensitive) {
            this._systemType = systemType;
            this._userIDCaseSensitive = caseSensitive;
        }

        public IRSESystemType getSystemType() {
            return this._systemType;
        }

        public boolean isUserIDCaseSensitive() {
            return this._userIDCaseSensitive;
        }
    }
}

