/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.references;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.rse.core.references.IRSEBasePersistableReferenceManager;
import org.eclipse.rse.core.references.IRSEBasePersistableReferencedObject;
import org.eclipse.rse.core.references.IRSEBasePersistableReferencingObject;

public class SystemPersistableReferenceManager
implements IRSEBasePersistableReferenceManager {
    protected static final String NAME_EDEFAULT = null;
    private IRSEBasePersistableReferencingObject[] listAsArray = null;
    public static boolean debug = true;
    public static HashMap EMPTY_MAP = new HashMap();
    protected String name = NAME_EDEFAULT;
    protected List referencingObjectList = null;

    protected SystemPersistableReferenceManager() {
    }

    protected List internalGetList() {
        return this.getReferencingObjectList();
    }

    protected void invalidateCache() {
        this.listAsArray = null;
    }

    public IRSEBasePersistableReferencingObject[] getReferencingObjects() {
        if (this.listAsArray == null || this.listAsArray.length != this.internalGetList().size()) {
            List list = this.internalGetList();
            this.listAsArray = new IRSEBasePersistableReferencingObject[list.size()];
            Iterator i = list.iterator();
            int idx = 0;
            while (i.hasNext()) {
                this.listAsArray[idx++] = (IRSEBasePersistableReferencingObject)i.next();
            }
        }
        return this.listAsArray;
    }

    public void setReferencingObjects(IRSEBasePersistableReferencingObject[] objects, boolean deReference) {
        this.listAsArray = objects;
        if (deReference) {
            this.removeAndDeReferenceAllReferencingObjects();
        } else {
            this.removeAllReferencingObjects();
        }
        List list = this.internalGetList();
        int idx = 0;
        while (idx < objects.length) {
            list.add(objects[idx]);
            ++idx;
        }
    }

    public int addReferencingObject(IRSEBasePersistableReferencingObject object) {
        List list = this.internalGetList();
        list.add(object);
        this.invalidateCache();
        return this.getReferencingObjectCount();
    }

    public int removeReferencingObject(IRSEBasePersistableReferencingObject object) {
        List list = this.internalGetList();
        list.remove(object);
        this.invalidateCache();
        return this.getReferencingObjectCount();
    }

    public int removeAndDeReferenceReferencingObject(IRSEBasePersistableReferencingObject object) {
        object.removeReference();
        return this.removeReferencingObject(object);
    }

    public void removeAllReferencingObjects() {
        this.internalGetList().clear();
    }

    public void removeAndDeReferenceAllReferencingObjects() {
        IRSEBasePersistableReferencingObject[] objs = this.getReferencingObjects();
        int idx = 0;
        while (idx < objs.length) {
            objs[idx].removeReference();
            ++idx;
        }
        this.removeAllReferencingObjects();
    }

    public int getReferencingObjectCount() {
        return this.internalGetList().size();
    }

    public int getReferencingObjectPosition(IRSEBasePersistableReferencingObject object) {
        List list = this.internalGetList();
        int position = -1;
        boolean match = false;
        Iterator i = list.iterator();
        int idx = 0;
        while (!match && i.hasNext()) {
            IRSEBasePersistableReferencingObject curr = (IRSEBasePersistableReferencingObject)i.next();
            if (curr == object) {
                match = true;
                position = idx;
                continue;
            }
            ++idx;
        }
        return position;
    }

    public void moveReferencingObjectPosition(int newPosition, IRSEBasePersistableReferencingObject object) {
    }

    public boolean isReferenced(IRSEBasePersistableReferencedObject object) {
        return this.getReferencedObject(object) != null;
    }

    public IRSEBasePersistableReferencingObject getReferencedObject(IRSEBasePersistableReferencedObject object) {
        List list = this.internalGetList();
        IRSEBasePersistableReferencingObject match = null;
        Iterator i = list.iterator();
        int idx = 0;
        while (match == null && i.hasNext()) {
            IRSEBasePersistableReferencingObject curr = (IRSEBasePersistableReferencingObject)i.next();
            if (curr.getReferencedObjectName().equals(object.getReferenceName())) {
                match = curr;
                continue;
            }
            ++idx;
        }
        return match;
    }

    public String toString() {
        return this.getName();
    }

    public boolean resolveReferencesAfterRestore() {
        return false;
    }

    public void save(IFolder folder, String fileName) throws Exception {
    }

    public static IRSEBasePersistableReferenceManager restore(IFolder folder, String fileName) throws Exception {
        SystemPersistableReferenceManager mgr = new SystemPersistableReferenceManager();
        return mgr;
    }

    public static String addPathTerminator(String path) {
        if (!path.endsWith(File.separator)) {
            path = String.valueOf(path) + File.separatorChar;
        }
        return path;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public List getReferencingObjectList() {
        if (this.referencingObjectList == null) {
            this.referencingObjectList = new ArrayList();
        }
        return this.referencingObjectList;
    }

    public String toStringGen() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (name: ");
        result.append(this.name);
        result.append(')');
        return result.toString();
    }
}

