/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.importexport.files;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.files.ui.actions.SystemSelectRemoteFolderAction;
import org.eclipse.rse.internal.importexport.RemoteImportExportResources;
import org.eclipse.rse.internal.importexport.RemoteImportExportUtil;
import org.eclipse.rse.internal.importexport.SystemImportExportResources;
import org.eclipse.rse.internal.importexport.files.RemoteExportWizard;
import org.eclipse.rse.internal.importexport.files.RemoteFileExportData;
import org.eclipse.rse.internal.importexport.files.RemoteFileExportOperation;
import org.eclipse.rse.internal.importexport.files.UniFilePlus;
import org.eclipse.rse.internal.importexport.files.Utilities;
import org.eclipse.rse.internal.synchronize.RSESyncUtils;
import org.eclipse.rse.internal.synchronize.SynchronizeData;
import org.eclipse.rse.internal.synchronize.provisional.SynchronizeOperation;
import org.eclipse.rse.internal.synchronize.provisional.Synchronizer;
import org.eclipse.rse.services.clientserver.messages.CommonMessages;
import org.eclipse.rse.services.clientserver.messages.SimpleSystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.messages.SystemMessageDialog;
import org.eclipse.rse.ui.messages.SystemMessageLine;
import org.eclipse.rse.ui.wizards.ISystemWizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.dialogs.WizardExportResourcesPage;

class RemoteExportWizardPage1
extends WizardExportResourcesPage
implements Listener,
ISystemWizardPage {
    private Object destinationFolder = null;
    private String helpId;
    private Composite parentComposite;
    private SystemMessageLine msgLine;
    private SystemMessage pendingMessage;
    private SystemMessage pendingErrorMessage;
    private Combo destinationNameField;
    private Button destinationBrowseButton;
    protected Button reviewSynchronizeCheckbox;
    protected Button overwriteExistingFilesCheckbox;
    protected Button createDirectoryStructureButton;
    protected Button createSelectionOnlyButton;
    protected Button saveSettingsButton;
    protected Label descFilePathLabel;
    protected Text descFilePathField;
    protected Button descFileBrowseButton;
    protected Object inputObject = null;
    private static final int MY_SIZING_TEXT_FIELD_WIDTH = 250;
    private static final String STORE_DESTINATION_NAMES_ID = "RemoteExportWizard.STORE_DESTINATION_NAMES_ID";
    private static final String STORE_REVIEW_SYNCHRONIZE_ID = "RemoteExportWizard.STORE_REVIEW_SYNCHRONIZE_ID";
    private static final String STORE_OVERWRITE_EXISTING_FILES_ID = "RemoteExportWizard.STORE_OVERWRITE_EXISTING_FILES_ID";
    private static final String STORE_CREATE_STRUCTURE_ID = "RemoteExportWizard.STORE_CREATE_STRUCTURE_ID";
    private static final String STORE_CREATE_DESCRIPTION_FILE_ID = "RemoteExportWizard.STORE_CREATE_DESCRIPTION_FILE_ID";
    private static final String STORE_DESCRIPTION_FILE_NAME_ID = "RemoteExportWizard.STORE_DESCRIPTION_FILE_NAME_ID";
    private static final SystemMessage DESTINATION_EMPTY_MESSAGE = new SimpleSystemMessage("org.eclipse.rse.importexport", "RSEF8069", 4, RemoteImportExportResources.FILEMSG_DESTINATION_EMPTY, RemoteImportExportResources.FILEMSG_DESTINATION_EMPTY_DETAILS);
    static /* synthetic */ Class class$0;

    protected RemoteExportWizardPage1(String name, IStructuredSelection selection) {
        super(name, selection);
        this.setInputObject(selection);
    }

    public RemoteExportWizardPage1(IStructuredSelection selection) {
        this("fileSystemExportPage1", selection);
        this.setTitle(SystemImportExportResources.RESID_FILEEXPORT_PAGE1_TITLE);
        this.setDescription(SystemImportExportResources.RESID_FILEEXPORT_PAGE1_DESCRIPTION);
    }

    protected void addDestinationItem(String value) {
        this.destinationNameField.add(value);
    }

    public void createControl(Composite parent) {
        this.parentComposite = new Composite(parent, 0);
        this.parentComposite.setLayout((Layout)new GridLayout(1, false));
        this.parentComposite.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        super.createControl(this.parentComposite);
        this.msgLine = new SystemMessageLine(this.parentComposite);
        this.msgLine.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        if (this.pendingMessage != null) {
            this.setMessage(this.pendingMessage);
        }
        if (this.pendingErrorMessage != null) {
            this.setErrorMessage(this.pendingErrorMessage);
        }
        this.giveFocusToDestination();
        SystemWidgetHelpers.setWizardPageMnemonics((Composite)this.parentComposite);
        if (this.helpId != null) {
            SystemWidgetHelpers.setHelp((Control)this.parentComposite, (String)this.helpId);
        } else {
            SystemWidgetHelpers.setHelp((Control)this.parentComposite, (String)"org.eclipse.rse.importexport.import_context");
        }
        this.setControl((Control)this.parentComposite);
    }

    protected void createDestinationGroup(Composite parent) {
        Composite destinationSelectionGroup = SystemWidgetHelpers.createComposite((Composite)parent, (int)3);
        ((GridData)destinationSelectionGroup.getLayoutData()).verticalAlignment = 4;
        this.destinationNameField = SystemWidgetHelpers.createLabeledReadonlyCombo((Composite)destinationSelectionGroup, null, (String)SystemImportExportResources.RESID_FILEEXPORT_DESTINATION_LABEL, (String)SystemImportExportResources.RESID_FILEEXPORT_DESTINATION_TOOLTIP);
        ((GridData)this.destinationNameField.getLayoutData()).widthHint = 250;
        ((GridData)this.destinationNameField.getLayoutData()).grabExcessHorizontalSpace = true;
        this.destinationNameField.addListener(24, (Listener)this);
        this.destinationNameField.addListener(13, (Listener)this);
        this.destinationBrowseButton = SystemWidgetHelpers.createPushButton((Composite)destinationSelectionGroup, null, (String)SystemImportExportResources.RESID_FILEEXPORT_DESTINATION_BROWSE_LABEL, (String)SystemImportExportResources.RESID_FILEEXPORT_DESTINATION_BROWSE_TOOLTIP);
        ((GridData)this.destinationBrowseButton.getLayoutData()).grabExcessHorizontalSpace = false;
        this.destinationBrowseButton.addListener(13, (Listener)this);
        new Label(parent, 0);
    }

    protected void createOptionsGroupButtons(Group optionsGroup) {
        this.reviewSynchronizeCheckbox = SystemWidgetHelpers.createCheckBox((Composite)optionsGroup, (int)1, null, (String)SystemImportExportResources.RESID_FILEEXPORT_REVIEW_LABEL, (String)SystemImportExportResources.RESID_FILEEXPORT_REVIEW_TOOLTIP);
        this.reviewSynchronizeCheckbox.addListener(13, (Listener)this);
        this.overwriteExistingFilesCheckbox = SystemWidgetHelpers.createCheckBox((Composite)optionsGroup, (int)1, null, (String)SystemImportExportResources.RESID_FILEEXPORT_OPTION_OVERWRITE_LABEL, (String)SystemImportExportResources.RESID_FILEEXPORT_OPTION_OVERWRITE_TOOLTIP);
        this.createDirectoryStructureButton = SystemWidgetHelpers.createRadioButton((Composite)optionsGroup, null, (String)SystemImportExportResources.RESID_FILEEXPORT_OPTION_CREATEALL_LABEL, (String)SystemImportExportResources.RESID_FILEEXPORT_OPTION_CREATEALL_TOOLTIP);
        this.createSelectionOnlyButton = SystemWidgetHelpers.createRadioButton((Composite)optionsGroup, null, (String)SystemImportExportResources.RESID_FILEEXPORT_OPTION_CREATESEL_LABEL, (String)SystemImportExportResources.RESID_FILEEXPORT_OPTION_CREATESEL_TOOLTIP);
        this.createSelectionOnlyButton.setSelection(true);
        Composite comp = SystemWidgetHelpers.createComposite((Composite)optionsGroup, (int)3);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginWidth = 0;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(768));
        this.saveSettingsButton = SystemWidgetHelpers.createCheckBox((Composite)comp, (int)3, null, (String)SystemImportExportResources.RESID_FILEEXPORT_OPTION_SETTINGS_LABEL, (String)SystemImportExportResources.RESID_FILEEXPORT_OPTION_SETTINGS_TOOLTIP);
        this.saveSettingsButton.addListener(13, (Listener)this);
        this.descFilePathLabel = new Label(comp, 0);
        this.descFilePathLabel.setText(SystemImportExportResources.RESID_FILEEXPORT_OPTION_SETTINGS_DESCFILE_LABEL);
        GridData data = new GridData();
        this.descFilePathLabel.setLayoutData((Object)data);
        this.descFilePathField = new Text(comp, 2052);
        this.descFilePathField.setToolTipText(SystemImportExportResources.RESID_FILEEXPORT_OPTION_SETTINGS_DESCFILE_PATH_TOOLTIP);
        data = new GridData();
        data.horizontalAlignment = 256;
        data.grabExcessHorizontalSpace = true;
        data.widthHint = this.convertWidthInCharsToPixels(80);
        this.descFilePathField.setLayoutData((Object)data);
        this.descFilePathField.addListener(24, (Listener)this);
        this.descFileBrowseButton = SystemWidgetHelpers.createPushButton((Composite)comp, null, (String)SystemImportExportResources.RESID_FILEEXPORT_OPTION_SETTINGS_DESCFILE_BROWSE_LABEL, (String)SystemImportExportResources.RESID_FILEEXPORT_OPTION_SETTINGS_DESCFILE_BROWSE_TOOLTIP);
        this.descFileBrowseButton.addListener(13, (Listener)this);
    }

    protected void setupBasedOnInitialSelections() {
        Object input = this.getInputObject();
        boolean allResource = true;
        if (input != null && input instanceof IStructuredSelection) {
            IStructuredSelection sel = (IStructuredSelection)input;
            if (sel.size() > 0) {
                Iterator z = sel.iterator();
                while (z.hasNext()) {
                    Object obj = z.next();
                    if (obj instanceof IResource) continue;
                    allResource = false;
                    break;
                }
            } else {
                allResource = false;
            }
        } else {
            allResource = false;
        }
        if (allResource) {
            super.setupBasedOnInitialSelections();
        }
    }

    protected void updateWidgetEnablements() {
        boolean isSaveSettings = this.isSaveSettings();
        this.descFilePathLabel.setEnabled(isSaveSettings);
        this.descFilePathField.setEnabled(isSaveSettings);
        this.descFileBrowseButton.setEnabled(isSaveSettings);
        if (this.reviewSynchronizeCheckbox != null) {
            boolean isReview = this.reviewSynchronizeCheckbox.getSelection();
            this.overwriteExistingFilesCheckbox.setEnabled(!isReview);
            this.createDirectoryStructureButton.setEnabled(!isReview);
            this.createSelectionOnlyButton.setEnabled(!isReview);
        }
    }

    protected boolean ensureDirectoryExists(File directory) {
        if (!directory.exists()) {
            String msgTxt = RemoteImportExportResources.FILEMSG_TARGET_EXISTS;
            String msgDetails = NLS.bind((String)RemoteImportExportResources.FILEMSG_TARGET_EXISTS_DETAILS, (Object)directory.getAbsolutePath());
            SimpleSystemMessage msg = new SimpleSystemMessage("org.eclipse.rse.importexport", "RSEF8060", 4, msgTxt, msgDetails);
            SystemMessageDialog dlg = new SystemMessageDialog(this.getContainer().getShell(), (SystemMessage)msg);
            if (!dlg.openQuestionNoException()) {
                return false;
            }
            if (!directory.mkdirs()) {
                msgTxt = RemoteImportExportResources.FILEMSG_CREATE_FOLDER_FAILED;
                msgDetails = NLS.bind((String)RemoteImportExportResources.FILEMSG_CREATE_FOLDER_FAILED_DETAILS, (Object)directory.getAbsolutePath());
                msg = new SimpleSystemMessage("org.eclipse.rse.importexport", "RSEF1304", 4, msgTxt, msgDetails);
                msg.makeSubstitution((Object)directory.getAbsolutePath());
                this.setErrorMessage((SystemMessage)msg);
                this.giveFocusToDestination();
                return false;
            }
        }
        return true;
    }

    protected boolean ensureTargetIsValid(File targetDirectory) {
        if (targetDirectory.exists() && !targetDirectory.isDirectory()) {
            String msgTxt = RemoteImportExportResources.FILEMSG_SOURCE_IS_FILE;
            String msgDetails = NLS.bind((String)RemoteImportExportResources.FILEMSG_SOURCE_IS_FILE_DETAILS, (Object)targetDirectory.getAbsolutePath());
            SimpleSystemMessage msg = new SimpleSystemMessage("org.eclipse.rse.importexport", "RSEF8063", 4, msgTxt, msgDetails);
            this.setErrorMessage((SystemMessage)msg);
            this.giveFocusToDestination();
            return false;
        }
        return this.ensureDirectoryExists(targetDirectory);
    }

    protected boolean executeExportOperation(RemoteFileExportOperation op) {
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.NullPointerException");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!clazz.isInstance(e.getTargetException())) {
                this.displayErrorDialog(e.getTargetException());
                return false;
            }
        }
        catch (Exception e) {
            this.displayErrorDialog(e.getMessage());
            return false;
        }
        IStatus status = op.getStatus();
        if (!status.isOK()) {
            String msgTxt = NLS.bind((String)RemoteImportExportResources.FILEMSG_EXPORT_FAILED, (Object)status);
            SimpleSystemMessage msg = new SimpleSystemMessage("org.eclipse.rse.importexport", "RSEF8067", 4, msgTxt);
            SystemMessageDialog dlg = new SystemMessageDialog(this.getContainer().getShell(), (SystemMessage)msg);
            dlg.openWithDetails();
            return false;
        }
        return true;
    }

    public boolean finish() {
        this.clearMessage();
        this.clearErrorMessage();
        boolean ret = false;
        this.setDestinationValue(this.destinationNameField.getText().trim());
        if (Utilities.isConnectionValid(this.destinationNameField.getText().trim(), this.getShell()) && this.isDestinationFolder()) {
            if (!this.ensureTargetIsValid((File)this.destinationFolder)) {
                return false;
            }
            List resourcesToExport = this.getWhiteCheckedResources();
            this.saveDirtyEditors();
            this.saveWidgetValues();
            if (resourcesToExport.size() > 0) {
                RemoteFileExportData data = new RemoteFileExportData();
                data.setContainerPath(null);
                data.setElements(resourcesToExport);
                data.setReviewSynchronize(this.reviewSynchronizeCheckbox.getSelection());
                data.setCreateDirectoryStructure(this.createDirectoryStructureButton.getSelection());
                data.setCreateSelectionOnly(this.createSelectionOnlyButton.getSelection());
                data.setOverWriteExistingFiles(this.overwriteExistingFilesCheckbox.getSelection());
                data.setSaveSettings(this.saveSettingsButton.getSelection());
                data.setDescriptionFilePath(this.getDescriptionLocation());
                data.setDestination(this.getDestinationValue());
                if (!this.reviewSynchronizeCheckbox.getSelection()) {
                    ret = this.executeExportOperation(new RemoteFileExportOperation(data, (IOverwriteQuery)this));
                } else {
                    SynchronizeData data2 = new SynchronizeData(data);
                    if (this.reviewSynchronizeCheckbox.getSelection()) {
                        data2.setSynchronizeType(5);
                    }
                    try {
                        ret = new Synchronizer(data2).run(new SynchronizeOperation());
                    }
                    catch (Exception e) {
                        ret = false;
                        e.printStackTrace();
                    }
                    try {
                        if (data.isSaveSettings()) {
                            RSESyncUtils.saveDescription(data);
                        }
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                return ret;
            }
            String msgTxt = RemoteImportExportResources.FILEMSG_EXPORT_NONE_SELECTED;
            String msgDetails = RemoteImportExportResources.FILEMSG_EXPORT_NONE_SELECTED_DETAILS;
            SimpleSystemMessage msg = new SimpleSystemMessage("org.eclipse.rse.importexport", "RSEF8068", 4, msgTxt, msgDetails);
            this.setErrorMessage((SystemMessage)msg);
            return false;
        }
        return false;
    }

    protected String getDestinationValue() {
        return this.destinationNameField.getText().trim();
    }

    protected String getDescriptionLocation() {
        return this.descFilePathField.getText().trim();
    }

    protected boolean isSaveSettings() {
        return this.saveSettingsButton.getSelection();
    }

    protected void giveFocusToDestination() {
        this.destinationNameField.setFocus();
    }

    protected void handleDestinationBrowseButtonPressed() {
        SystemSelectRemoteFolderAction action = new SystemSelectRemoteFolderAction(this.getShell());
        action.setShowNewConnectionPrompt(true);
        action.setFoldersOnly(true);
        action.setShowPropertySheet(true, false);
        String destValue = this.getDestinationValue();
        if (destValue != null) {
            IHost host = Utilities.parseForSystemConnection(destValue);
            IRemoteFile path = Utilities.parseForIRemoteFile(destValue);
            action.setDefaultConnection(host);
            action.setPreSelection(path);
        }
        action.run();
        IRemoteFile folder = action.getSelectedFolder();
        if (folder != null) {
            this.destinationFolder = new UniFilePlus(folder);
            destValue = Utilities.getAsString((UniFilePlus)this.destinationFolder);
            this.setDestinationValue(destValue);
        }
    }

    protected void handleDescriptionFileBrowseButtonPressed() {
        SaveAsDialog dialog = new SaveAsDialog(this.getContainer().getShell());
        dialog.create();
        dialog.getShell().setText(RemoteImportExportResources.IMPORT_EXPORT_DESCRIPTION_FILE_DIALOG_TITLE);
        dialog.setMessage(RemoteImportExportResources.IMPORT_EXPORT_DESCRIPTION_FILE_DIALOG_MESSAGE);
        dialog.setOriginalFile(this.createFileHandle((IPath)new Path(this.getDescriptionLocation())));
        if (dialog.open() == 0) {
            IPath path = dialog.getResult();
            path = path.removeFileExtension().addFileExtension("rexpfd");
            this.descFilePathField.setText(path.toString());
        }
    }

    protected IFile createFileHandle(IPath filePath) {
        if (filePath.isValidPath(filePath.toString()) && filePath.segmentCount() >= 2) {
            return SystemBasePlugin.getWorkspace().getRoot().getFile(filePath);
        }
        return null;
    }

    public void handleEvent(Event e) {
        Widget source = e.widget;
        if (source == this.destinationBrowseButton) {
            this.handleDestinationBrowseButtonPressed();
        } else if (source == this.descFileBrowseButton) {
            this.handleDescriptionFileBrowseButtonPressed();
        }
        this.updateWidgetEnablements();
        this.updatePageCompletion();
    }

    protected void internalSaveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] directoryNames = settings.getArray(STORE_DESTINATION_NAMES_ID);
            if (directoryNames == null) {
                directoryNames = new String[]{};
            }
            directoryNames = this.addToHistory(directoryNames, this.getDestinationValue());
            settings.put(STORE_DESTINATION_NAMES_ID, directoryNames);
            settings.put(STORE_REVIEW_SYNCHRONIZE_ID, this.reviewSynchronizeCheckbox.getSelection());
            settings.put(STORE_OVERWRITE_EXISTING_FILES_ID, this.overwriteExistingFilesCheckbox.getSelection());
            settings.put(STORE_CREATE_STRUCTURE_ID, this.createDirectoryStructureButton.getSelection());
            settings.put(STORE_CREATE_DESCRIPTION_FILE_ID, this.isSaveSettings());
            settings.put(STORE_DESCRIPTION_FILE_NAME_ID, this.getDescriptionLocation());
        }
    }

    protected boolean isDestinationFolder() {
        boolean ret;
        boolean bl = ret = this.destinationFolder != null;
        if (!ret) {
            String msgTxt = RemoteImportExportResources.MSG_IMPORT_EXPORT_UNABLE_TO_USE_CONNECTION;
            String msgDetails = RemoteImportExportResources.MSG_IMPORT_EXPORT_UNABLE_TO_USE_CONNECTION_DETAILS;
            SimpleSystemMessage msg = new SimpleSystemMessage("org.eclipse.rse.importexport", "RSEF5101", 4, msgTxt, msgDetails);
            SystemMessageDialog.show((Shell)this.getShell(), (SystemMessage)msg);
        }
        return ret;
    }

    protected void restoreWidgetValues() {
        IRemoteFile file;
        Object theSel;
        IStructuredSelection sel;
        Object initSelection;
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            RemoteExportWizard parentWizard;
            boolean isInitializingFromExportData;
            String lastDestination = null;
            String[] directoryNames = settings.getArray(STORE_DESTINATION_NAMES_ID);
            if (directoryNames != null) {
                int i = 0;
                while (i < directoryNames.length) {
                    if (i == 0) {
                        lastDestination = directoryNames[i];
                    }
                    this.addDestinationItem(directoryNames[i]);
                    ++i;
                }
            }
            if (!(isInitializingFromExportData = (parentWizard = (RemoteExportWizard)this.getWizard()).getInitializeFromExportData())) {
                this.reviewSynchronizeCheckbox.setSelection(settings.getBoolean(STORE_REVIEW_SYNCHRONIZE_ID));
                this.overwriteExistingFilesCheckbox.setSelection(settings.getBoolean(STORE_OVERWRITE_EXISTING_FILES_ID));
                boolean createDirectories = settings.getBoolean(STORE_CREATE_STRUCTURE_ID);
                this.createDirectoryStructureButton.setSelection(createDirectories);
                this.createSelectionOnlyButton.setSelection(!createDirectories);
                boolean saveSettings = settings.getBoolean(STORE_CREATE_DESCRIPTION_FILE_ID);
                this.saveSettingsButton.setSelection(saveSettings);
                String descFilePathStr = settings.get(STORE_DESCRIPTION_FILE_NAME_ID);
                if (descFilePathStr == null) {
                    descFilePathStr = "";
                }
                this.descFilePathField.setText(descFilePathStr);
                if (lastDestination != null) {
                    this.setDestinationValue(lastDestination);
                }
            } else {
                RemoteFileExportData data = parentWizard.getExportData();
                this.reviewSynchronizeCheckbox.setSelection(data.isReviewSynchronize());
                this.overwriteExistingFilesCheckbox.setSelection(data.isOverWriteExistingFiles());
                this.createDirectoryStructureButton.setSelection(data.isCreateDirectoryStructure());
                this.createSelectionOnlyButton.setSelection(data.isCreateSelectionOnly());
                this.saveSettingsButton.setSelection(data.isSaveSettings());
                String descFilePathStr = data.getDescriptionFilePath();
                if (descFilePathStr == null) {
                    descFilePathStr = "";
                }
                this.descFilePathField.setText(descFilePathStr);
                String destinationPath = data.getDestination();
                if (destinationPath != null) {
                    this.setDestinationValue(destinationPath);
                }
            }
        }
        if ((initSelection = this.getInputObject()) != null && initSelection instanceof IStructuredSelection && (sel = (IStructuredSelection)initSelection).size() == 1 && (theSel = sel.getFirstElement()) instanceof IRemoteFile && (file = (IRemoteFile)theSel).isDirectory()) {
            this.destinationFolder = new UniFilePlus(file);
            this.setDestinationValue(Utilities.getAsString((UniFilePlus)this.destinationFolder));
        }
    }

    protected void setDestinationValue(String path) {
        IRemoteFile rf;
        if (path.length() > 0) {
            String[] currentItems = this.destinationNameField.getItems();
            int selectionIndex = -1;
            int i = 0;
            while (i < currentItems.length && selectionIndex < 0) {
                if (currentItems[i].equals(path)) {
                    selectionIndex = i;
                }
                ++i;
            }
            if (selectionIndex < 0) {
                int oldLength = currentItems.length;
                String[] newItems = new String[oldLength + 1];
                System.arraycopy(currentItems, 0, newItems, 0, oldLength);
                newItems[oldLength] = path;
                this.destinationNameField.setText(path);
                this.destinationNameField.setItems(newItems);
                selectionIndex = oldLength;
            }
            this.destinationNameField.select(selectionIndex);
        }
        this.destinationFolder = null;
        IHost conn = Utilities.parseForSystemConnection(path);
        if (conn != null && (rf = Utilities.parseForIRemoteFile(path)) != null) {
            this.destinationFolder = new UniFilePlus(rf);
        }
    }

    protected boolean validateDestinationGroup() {
        String destinationValue = this.getDestinationValue();
        if (destinationValue.length() == 0) {
            this.setMessage(DESTINATION_EMPTY_MESSAGE);
            return false;
        }
        String conflictingContainer = this.getConflictingContainerNameFor(destinationValue);
        if (conflictingContainer != null) {
            String msgTxt = NLS.bind((String)RemoteImportExportResources.FILEMSG_DESTINATION_CONFLICTING, (Object)conflictingContainer);
            String msgDetails = RemoteImportExportResources.FILEMSG_DESTINATION_CONFLICTING_DETAILS;
            SimpleSystemMessage msg = new SimpleSystemMessage("org.eclipse.rse.importexport", "RSEF8062", 4, msgTxt, msgDetails);
            this.setErrorMessage((SystemMessage)msg);
            this.giveFocusToDestination();
            return false;
        }
        return true;
    }

    protected boolean validateOptionsGroup() {
        if (this.isSaveSettings()) {
            Path location = new Path(this.getDescriptionLocation());
            if (location.toString().length() == 0) {
                this.setErrorMessage((String)null);
                return false;
            }
            if (!location.toString().startsWith("/")) {
                this.setErrorMessage(RemoteImportExportResources.IMPORT_EXPORT_ERROR_DESCRIPTION_ABSOLUTE);
                return false;
            }
            IResource resource = this.findResource((IPath)location);
            if (resource != null && resource.getType() != 1) {
                this.setErrorMessage(RemoteImportExportResources.IMPORT_EXPORT_ERROR_DESCRIPTION_EXISTING_CONTAINER);
                return false;
            }
            resource = this.findResource(location.removeLastSegments(1));
            if (resource == null || resource.getType() == 1) {
                this.setErrorMessage(RemoteImportExportResources.IMPORT_EXPORT_ERROR_DESCRIPTION_NO_CONTAINER);
                return false;
            }
            String fileExtension = location.getFileExtension();
            if (fileExtension == null || !fileExtension.equals("rexpfd")) {
                this.setErrorMessage(NLS.bind((String)RemoteImportExportResources.IMPORT_EXPORT_ERROR_DESCRIPTION_INVALID_EXTENSION, (Object)"rexpfd"));
                return false;
            }
        }
        return true;
    }

    protected IResource findResource(IPath path) {
        IWorkspace workspace = SystemBasePlugin.getWorkspace();
        IStatus result = workspace.validatePath(path.toString(), 15);
        if (result.isOK()) {
            IWorkspaceRoot root = workspace.getRoot();
            if (root.exists(path)) {
                return root.findMember(path);
            }
            IResource variant = RemoteImportExportUtil.getInstance().findExistingResourceVariant(path);
            if (variant != null) {
                return variant;
            }
        }
        return null;
    }

    protected String getConflictingContainerNameFor(String targetDirectory) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        Path testPath = new Path(targetDirectory);
        if (root.getLocation().isPrefixOf((IPath)testPath)) {
            return "workspace root";
        }
        IProject[] projects = root.getProjects();
        int i = 0;
        while (i < projects.length) {
            IPath loc = projects[i].getLocation();
            if (loc != null && loc.isPrefixOf((IPath)testPath)) {
                return projects[i].getName();
            }
            ++i;
        }
        return null;
    }

    public void setInputObject(Object inputObject) {
        this.inputObject = inputObject;
    }

    public Object getInputObject() {
        return this.inputObject;
    }

    public boolean performFinish() {
        return this.finish();
    }

    public void setHelp(String id) {
        if (this.parentComposite != null) {
            SystemWidgetHelpers.setHelp((Control)this.parentComposite, (String)this.helpId);
        }
        this.helpId = id;
    }

    public String getHelpContextId() {
        return this.helpId;
    }

    public void clearErrorMessage() {
        if (this.msgLine != null) {
            this.msgLine.clearErrorMessage();
        } else {
            super.setErrorMessage(null);
        }
    }

    public void clearMessage() {
        if (this.msgLine != null) {
            this.msgLine.clearMessage();
        } else {
            super.setMessage(null);
        }
    }

    public SystemMessage getSystemErrorMessage() {
        if (this.msgLine != null) {
            return this.msgLine.getSystemErrorMessage();
        }
        return null;
    }

    public void setErrorMessage(SystemMessage message) {
        if (this.msgLine != null) {
            if (message != null) {
                this.msgLine.setErrorMessage(message);
            } else {
                this.msgLine.clearErrorMessage();
            }
        } else {
            this.pendingErrorMessage = message;
            super.setErrorMessage(message.getLevelOneText());
        }
    }

    public void setErrorMessage(Throwable exc) {
        if (this.msgLine != null) {
            this.msgLine.setErrorMessage(exc);
        } else {
            String msgTxt = CommonMessages.MSG_ERROR_UNEXPECTED;
            SimpleSystemMessage msg = new SimpleSystemMessage("org.eclipse.rse.importexport", "RSEG8002", 4, msgTxt, exc);
            this.pendingErrorMessage = msg;
            super.setErrorMessage(msg.getLevelOneText());
        }
    }

    public void setErrorMessage(String message) {
        if (this.msgLine != null) {
            this.msgLine.setErrorMessage(message);
        }
    }

    public void setMessage(SystemMessage message) {
        if (this.msgLine != null) {
            this.msgLine.setMessage(message);
        } else {
            this.pendingMessage = message;
            super.setMessage(message.getLevelOneText());
        }
    }

    public void setMessage(String message) {
        if (this.msgLine != null) {
            this.msgLine.setMessage(message);
        }
    }
}

