/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.services.clientserver.java;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.rse.services.clientserver.java.BasicClassFileParser;

public class ClassFileUtil {
    private static ClassFileUtil instance;

    private ClassFileUtil() {
    }

    public static final ClassFileUtil getInstance() {
        if (instance == null) {
            instance = new ClassFileUtil();
        }
        return instance;
    }

    public boolean isRunnable(String classFilePath) throws IOException {
        File classFile = new File(classFilePath);
        return this.isRunnable(classFile);
    }

    public boolean isRunnable(File classFile) throws IOException {
        FileInputStream stream = new FileInputStream(classFile);
        return this.isRunnable(stream);
    }

    public boolean isRunnable(InputStream stream) throws IOException {
        BasicClassFileParser parser = new BasicClassFileParser(stream);
        parser.parse();
        return parser.isExecutable();
    }

    public String getQualifiedClassName(String classFilePath) throws IOException {
        File classFile = new File(classFilePath);
        return this.getQualifiedClassName(classFile);
    }

    public String getQualifiedClassName(File classFile) throws IOException {
        FileInputStream stream = new FileInputStream(classFile);
        return this.getQualifiedClassName(stream);
    }

    public String getQualifiedClassName(InputStream stream) throws IOException {
        BasicClassFileParser parser = new BasicClassFileParser(stream);
        parser.parse();
        return parser.getQualifiedClassName();
    }
}

