/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.rapi;

import org.eclipse.tm.rapi.IRapiSession;
import org.eclipse.tm.rapi.ProcessInformation;
import org.eclipse.tm.rapi.RapiException;
import org.eclipse.tm.rapi.RapiFindData;

public class RapiSession
extends IRapiSession {
    private RapiFindData[] EMPTY_FIND_DATA_ARR = new RapiFindData[0];

    public RapiSession(int addr) {
        super(addr);
    }

    private int getError() {
        int err = this.CeRapiGetError(this.addr);
        if (err >= 0) {
            err = this.CeGetLastError(this.addr);
        }
        return err;
    }

    public void init() throws RapiException {
        int rc = this.CeRapiInit(this.addr);
        if (rc != 0) {
            throw new RapiException("CeRapiInit failed", rc);
        }
    }

    public void uninit() throws RapiException {
        int rc = this.CeRapiUninit(this.addr);
        if (rc != 0) {
            throw new RapiException("CeRapiUninit failed", rc);
        }
    }

    public int createFile(String fileName, int desiredAccess, int shareMode, int creationDisposition, int flagsAndAttributes) throws RapiException {
        int handle = this.CeCreateFile(this.addr, fileName, desiredAccess, shareMode, creationDisposition, flagsAndAttributes);
        if (handle == -1) {
            throw new RapiException("CeCreateFile failed", this.getError());
        }
        return handle;
    }

    public int readFile(int handle, byte[] b) throws RapiException {
        if (b.length == 0) {
            return 0;
        }
        int[] bytesRead = new int[1];
        boolean res = this.CeReadFile(this.addr, handle, b, b.length, bytesRead);
        if (!res) {
            throw new RapiException("CeReadFile failed", this.getError());
        }
        return bytesRead[0] > 0 ? bytesRead[0] : -1;
    }

    public int readFile(int handle, byte[] b, int off, int len) throws RapiException {
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException("Incorrect offset/length");
        }
        if (len == 0) {
            return 0;
        }
        byte[] tmp = new byte[len];
        int[] bytesRead = new int[1];
        boolean res = this.CeReadFile(this.addr, handle, tmp, tmp.length, bytesRead);
        if (!res) {
            throw new RapiException("CeReadFile failed", this.getError());
        }
        System.arraycopy(tmp, 0, b, off, len);
        return bytesRead[0] > 0 ? bytesRead[0] : -1;
    }

    public void writeFile(int handle, byte[] b) throws RapiException {
        int[] bytesWritten = new int[1];
        boolean res = this.CeWriteFile(this.addr, handle, b, b.length, bytesWritten);
        if (!res) {
            throw new RapiException("CeWriteFile failed", this.getError());
        }
    }

    public void writeFile(int handle, byte[] b, int off, int len) throws RapiException {
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException("Incorrect offset/length");
        }
        byte[] tmp = new byte[len];
        System.arraycopy(b, off, tmp, 0, len);
        int[] bytesWritten = new int[1];
        boolean res = this.CeWriteFile(this.addr, handle, tmp, tmp.length, bytesWritten);
        if (!res) {
            throw new RapiException("CeWriteFile failed", this.getError());
        }
    }

    public void closeHandle(int handle) throws RapiException {
        boolean res = this.CeCloseHandle(this.addr, handle);
        if (!res) {
            throw new RapiException("CeCloseHandle failed", this.getError());
        }
    }

    public void copyFile(String existingFile, String newFile) throws RapiException {
        boolean res = this.CeCopyFile(this.addr, existingFile, newFile, false);
        if (!res) {
            throw new RapiException("CeCopyFile failed", this.getError());
        }
    }

    public void deleteFile(String fileName) throws RapiException {
        boolean res = this.CeDeleteFile(this.addr, fileName);
        if (!res) {
            throw new RapiException("CeDeleteFile failed", this.getError());
        }
    }

    public void moveFile(String existingFileName, String newFileName) throws RapiException {
        boolean res = this.CeMoveFile(this.addr, existingFileName, newFileName);
        if (!res) {
            throw new RapiException("CeMoveFile failed", this.getError());
        }
    }

    public void createDirectory(String pathName) throws RapiException {
        boolean res = this.CeCreateDirectory(this.addr, pathName);
        if (!res) {
            throw new RapiException("CeCreateDirectory failed", this.getError());
        }
    }

    public void removeDirectory(String pathName) throws RapiException {
        boolean res = this.CeRemoveDirectory(this.addr, pathName);
        if (!res) {
            throw new RapiException("CeRemoveDirectory failed", this.getError());
        }
    }

    public int findFirstFile(String fileName, RapiFindData findData) throws RapiException {
        int handle = this.CeFindFirstFile(this.addr, fileName, findData);
        if (handle == -1) {
            throw new RapiException("CeFindFirstFile failed", this.getError());
        }
        return handle;
    }

    public RapiFindData findNextFile(int handle) {
        RapiFindData findData = new RapiFindData();
        boolean res = this.CeFindNextFile(this.addr, handle, findData);
        return res ? findData : null;
    }

    public void findClose(int handle) throws RapiException {
        boolean res = this.CeFindClose(this.addr, handle);
        if (!res) {
            throw new RapiException("CeFindClose failed", this.getError());
        }
    }

    public RapiFindData[] findAllFiles(String path, int flags) throws RapiException {
        int[] foundCount = new int[1];
        int[] dataArr = new int[1];
        boolean res = this.CeFindAllFiles(this.addr, path, flags, foundCount, dataArr);
        int count = foundCount[0];
        if (!res || count == 0) {
            return this.EMPTY_FIND_DATA_ARR;
        }
        RapiFindData[] findDataArr = new RapiFindData[count];
        int i = 0;
        while (i < count) {
            findDataArr[i] = new RapiFindData();
            ++i;
        }
        int hRes = this.CeFindAllFilesEx(this.addr, count, dataArr[0], findDataArr);
        if (hRes != 0) {
            throw new RapiException("CeFindAllFilesEx failed", hRes);
        }
        return findDataArr;
    }

    public int getFileAttributes(String fileName) {
        int attributes = this.CeGetFileAttributes(this.addr, fileName);
        return attributes;
    }

    public long getFileSize(int handle) {
        int[] sizeHigh = new int[]{1};
        int sizeLow = this.CeGetFileSize(this.addr, handle, sizeHigh);
        return (long)sizeHigh[0] << 32 | (long)(sizeLow & 0xFFFFFFFF);
    }

    public long getFileCreationTime(int handle) throws RapiException {
        long[] crTime = new long[1];
        long[] laTime = new long[1];
        long[] lwTime = new long[1];
        boolean res = this.CeGetFileTime(this.addr, handle, crTime, laTime, lwTime);
        if (!res) {
            throw new RapiException("CeGetFileTime failed", this.getError());
        }
        return crTime[0] / 10000L - 11644473600000L;
    }

    public long getFileLastAccessTime(int handle) throws RapiException {
        long[] crTime = new long[1];
        long[] laTime = new long[1];
        long[] lwTime = new long[1];
        boolean res = this.CeGetFileTime(this.addr, handle, crTime, laTime, lwTime);
        if (!res) {
            throw new RapiException("CeGetFileTime failed", this.getError());
        }
        return laTime[0] / 10000L - 11644473600000L;
    }

    public long getFileLastWriteTime(int handle) throws RapiException {
        long[] crTime = new long[1];
        long[] laTime = new long[1];
        long[] lwTime = new long[1];
        boolean res = this.CeGetFileTime(this.addr, handle, crTime, laTime, lwTime);
        if (!res) {
            throw new RapiException("CeGetFileTime failed", this.getError());
        }
        return lwTime[0] / 10000L - 11644473600000L;
    }

    public void setFileAttributes(String fileName, int fileAttributes) throws RapiException {
        boolean res = this.CeSetFileAttributes(this.addr, fileName, fileAttributes);
        if (!res) {
            throw new RapiException("CeSetFileAttributes failed", this.getError());
        }
    }

    public void setFileLastWriteTime(int handle, long lastWriteTime) throws RapiException {
        if (lastWriteTime < 0L) {
            throw new IllegalArgumentException("Time cannot be negative");
        }
        long[] lwTime = new long[]{(lastWriteTime + 11644473600000L) * 10000L};
        boolean res = this.CeSetFileTime(this.addr, handle, null, null, lwTime);
        if (!res) {
            throw new RapiException("CeSetFileTime failed", this.getError());
        }
    }

    public ProcessInformation createProcess(String appName, String commandLine, int creationFlags) throws RapiException {
        ProcessInformation pi = new ProcessInformation();
        if (!this.CeCreateProcess(this.addr, appName, commandLine, creationFlags, pi)) {
            throw new RapiException("CeCreateProcess failed", this.getError());
        }
        return pi;
    }

    public String toString() {
        return "[RapiSession] addr: " + Integer.toHexString(this.addr);
    }

    private final native int CeRapiInit(int var1);

    private final native int CeRapiUninit(int var1);

    private final native int CeRapiGetError(int var1);

    private final native int CeGetLastError(int var1);

    private final native int CeCreateFile(int var1, String var2, int var3, int var4, int var5, int var6);

    private final native boolean CeReadFile(int var1, int var2, byte[] var3, int var4, int[] var5);

    private final native boolean CeWriteFile(int var1, int var2, byte[] var3, int var4, int[] var5);

    private final native boolean CeCloseHandle(int var1, int var2);

    private final native boolean CeCopyFile(int var1, String var2, String var3, boolean var4);

    private final native boolean CeDeleteFile(int var1, String var2);

    private final native boolean CeMoveFile(int var1, String var2, String var3);

    private final native boolean CeCreateDirectory(int var1, String var2);

    private final native boolean CeRemoveDirectory(int var1, String var2);

    private final native int CeFindFirstFile(int var1, String var2, RapiFindData var3);

    private final native boolean CeFindNextFile(int var1, int var2, RapiFindData var3);

    private final native boolean CeFindClose(int var1, int var2);

    private final native boolean CeFindAllFiles(int var1, String var2, int var3, int[] var4, int[] var5);

    private final native int CeFindAllFilesEx(int var1, int var2, int var3, RapiFindData[] var4);

    private final native int CeGetFileAttributes(int var1, String var2);

    private final native int CeGetFileSize(int var1, int var2, int[] var3);

    private final native boolean CeGetFileTime(int var1, int var2, long[] var3, long[] var4, long[] var5);

    private final native boolean CeSetFileAttributes(int var1, String var2, int var3);

    private final native boolean CeSetFileTime(int var1, int var2, long[] var3, long[] var4, long[] var5);

    private final native boolean CeCreateProcess(int var1, String var2, String var3, int var4, ProcessInformation var5);
}

