/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.core.subsystems;

import java.util.ArrayList;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.PasswordPersistenceManager;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.model.SystemSignonInformation;
import org.eclipse.rse.core.subsystems.AbstractConnectorService;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.ICredentials;
import org.eclipse.rse.core.subsystems.ICredentialsProvider;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;

public abstract class AuthenticatingConnectorService
extends AbstractConnectorService {
    protected ICredentialsProvider credentialsProvider = null;

    public AuthenticatingConnectorService(String name, String description, IHost host, int port) {
        super(name, description, host, port);
    }

    public final String getUserId() {
        return this.credentialsProvider.getUserId();
    }

    public final void setUserId(String newId) {
        String oldUserId = this.credentialsProvider.getUserId();
        if (oldUserId == null || !oldUserId.equals(newId)) {
            this.credentialsProvider.setUserId(newId);
            this.saveUserId();
        }
    }

    public final void saveUserId() {
        String userId = this.credentialsProvider.getUserId();
        this.updateDefaultUserId(this.getPrimarySubSystem(), userId);
    }

    public final void removeUserId() {
        this.updateDefaultUserId(this.getPrimarySubSystem(), null);
    }

    public final void clearPassword(boolean persist, boolean propagate) {
        this.credentialsProvider.clearPassword();
        if (persist) {
            this.removePassword();
        }
        if (this.sharesCredentials() && propagate) {
            String userId = this.credentialsProvider.getUserId();
            this.clearPasswordForOtherSystemsInConnection(userId, false);
        }
    }

    public final boolean hasPassword(boolean onDisk) {
        boolean cached;
        ICredentials credentials = this.credentialsProvider.getCredentials();
        boolean bl = cached = credentials != null && credentials.getPassword() != null;
        if (!cached && onDisk) {
            IRSESystemType systemType = this.getHost().getSystemType();
            String hostName = this.getHostName();
            String userId = this.getUserId();
            if (userId != null) {
                return PasswordPersistenceManager.getInstance().passwordExists(systemType, hostName, this.getUserId());
            }
        }
        return cached;
    }

    public final void setPassword(String userId, String password, boolean persist, boolean propagate) {
        if (this.getPrimarySubSystem().forceUserIdToUpperCase()) {
            userId = userId.toUpperCase();
        }
        String myUserId = this.credentialsProvider.getUserId();
        IHost host = this.getHost();
        if (host.compareUserIds(userId, myUserId)) {
            this.credentialsProvider.setPassword(password);
        }
        if (this.sharesCredentials() && propagate) {
            this.updatePasswordForOtherSystemsInConnection(userId, password, persist);
        }
        if (persist) {
            this.savePassword();
        } else {
            this.removePassword();
        }
    }

    public final void savePassword() {
        ICredentials credentials = this.credentialsProvider.getCredentials();
        if (credentials instanceof SystemSignonInformation) {
            SystemSignonInformation signonInformation = (SystemSignonInformation)credentials;
            PasswordPersistenceManager.getInstance().add(signonInformation, true, false);
        }
    }

    public final void removePassword() {
        IRSESystemType systemType = this.getHost().getSystemType();
        String hostName = this.getHostName();
        String userId = this.credentialsProvider.getUserId();
        PasswordPersistenceManager.getInstance().remove(systemType, hostName, userId);
    }

    protected final void postDisconnect() {
        this.clearPassword(false, true);
    }

    public final boolean isSuppressed() {
        return this.credentialsProvider.isSuppressed();
    }

    public final void setSuppressed(boolean suppressed) {
        this.credentialsProvider.setSuppressed(suppressed);
    }

    public final void acquireCredentials(boolean reacquire) throws OperationCanceledException {
        this.credentialsProvider.acquireCredentials(reacquire);
    }

    public final void clearCredentials() {
        this.credentialsProvider.clearCredentials();
        this.setDirty(true);
    }

    private void updatePasswordForOtherSystemsInConnection(String uid, String password, boolean persist) {
        IHost connection = this.getPrimarySubSystem().getHost();
        ISystemRegistry registry = RSECorePlugin.getTheSystemRegistry();
        ISubSystem[] subsystems = registry.getSubSystems(connection);
        ArrayList<IConnectorService> uniqueSystems = new ArrayList<IConnectorService>();
        int i = 0;
        while (i < subsystems.length) {
            IConnectorService cs = subsystems[i].getConnectorService();
            if (cs != this && cs.inheritsCredentials() && !uniqueSystems.contains(cs)) {
                uniqueSystems.add(cs);
            }
            ++i;
        }
        int s = 0;
        while (s < uniqueSystems.size()) {
            IConnectorService system = (IConnectorService)uniqueSystems.get(s);
            if (!system.isConnected() && !system.hasPassword(false)) {
                if (system.getPrimarySubSystem().forceUserIdToUpperCase()) {
                    uid = uid.toUpperCase();
                    password = password.toUpperCase();
                }
                system.setPassword(uid, password, false, false);
            }
            ++s;
        }
    }

    private void clearPasswordForOtherSystemsInConnection(String uid, boolean persist) {
        if (uid != null) {
            IConnectorService system;
            IHost connection = this.getHost();
            ISystemRegistry registry = RSECorePlugin.getTheSystemRegistry();
            ISubSystem[] subsystems = registry.getSubSystems(connection);
            ArrayList<IConnectorService> uniqueSystems = new ArrayList<IConnectorService>();
            int i = 0;
            while (i < subsystems.length) {
                system = subsystems[i].getConnectorService();
                if (system != this && system.inheritsCredentials() && !uniqueSystems.contains(system)) {
                    uniqueSystems.add(system);
                }
                ++i;
            }
            int s = 0;
            while (s < uniqueSystems.size()) {
                system = (IConnectorService)uniqueSystems.get(s);
                if (system.hasPassword(persist)) {
                    system.clearPassword(persist, false);
                }
                ++s;
            }
        }
    }

    private void updateDefaultUserId(ISubSystem subsystem, String userId) {
        String ssLocalUserId = subsystem.getLocalUserId();
        if (ssLocalUserId != null) {
            ISubSystemConfiguration ssc = subsystem.getSubSystemConfiguration();
            ssc.updateSubSystem(subsystem, true, userId, false, 0);
        } else {
            int whereToUpdate = 2;
            IHost host = subsystem.getHost();
            ISystemRegistry sr = RSECorePlugin.getTheSystemRegistry();
            sr.updateHost(host, host.getSystemType(), host.getAliasName(), host.getHostName(), host.getDescription(), userId, whereToUpdate);
        }
    }

    public boolean sharesCredentials() {
        return true;
    }

    public boolean inheritsCredentials() {
        return true;
    }

    protected final void setCredentialsProvider(ICredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    protected final ICredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }
}

