/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.connectorservice.dstore.ui.propertypages;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.rse.internal.connectorservice.dstore.DStoreResources;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class DStorePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
Listener {
    private Text _connectionTimeout;
    private Button _doKeepaliveButton;
    private Text _keepaliveResponseTimeout;
    private Text _socketReadTimeout;
    private Button _showMismatchedServerWarningButton;

    protected Control createContents(Composite gparent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.rse.ui.DStorePreferencePage");
        Composite parent = SystemWidgetHelpers.createComposite((Composite)gparent, (int)2);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        parent.setLayout((Layout)layout);
        parent.setLayoutData((Object)new GridData(32));
        Composite connectComposite = SystemWidgetHelpers.createComposite((Composite)parent, (int)2);
        SystemWidgetHelpers.createLabel((Composite)connectComposite, (String)DStoreResources.RESID_PREFERENCE_CONNECTION_TIMEOUT_LABEL);
        this._connectionTimeout = new Text(connectComposite, 2048);
        GridData gd = new GridData(32);
        gd.widthHint = 75;
        gd.horizontalSpan = 1;
        this._connectionTimeout.setLayoutData((Object)gd);
        this._connectionTimeout.setTextLimit(10);
        this._connectionTimeout.setToolTipText(DStoreResources.RESID_PREFERENCE_CONNECTION_TIMEOUT_TOOLTIP);
        this._connectionTimeout.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = true;
                int loop = 0;
                while (loop < e.text.length()) {
                    if (!Character.isDigit(e.text.charAt(loop))) {
                        e.doit = false;
                    }
                    ++loop;
                }
            }
        });
        this._showMismatchedServerWarningButton = SystemWidgetHelpers.createCheckBox((Composite)parent, (String)DStoreResources.RESID_PREFERENCE_SHOW_MISMATCHED_SERVER_LABEL, (Listener)this);
        this._showMismatchedServerWarningButton.setToolTipText(DStoreResources.RESID_PREFERENCE_SHOW_MISMATCHED_SERVER_TOOLTIP);
        this._showMismatchedServerWarningButton.setLayoutData((Object)new GridData(1, 1, true, false));
        ((GridData)this._showMismatchedServerWarningButton.getLayoutData()).horizontalSpan = 2;
        Group keepaliveGroup = SystemWidgetHelpers.createGroupComposite((Composite)parent, (int)2, (String)DStoreResources.RESID_PREFERENCE_KEEPALIVE_LABEL);
        layout = new GridLayout();
        layout.numColumns = 2;
        keepaliveGroup.setLayout((Layout)layout);
        GridData data = new GridData(768);
        keepaliveGroup.setLayoutData((Object)data);
        this._doKeepaliveButton = SystemWidgetHelpers.createCheckBox((Composite)keepaliveGroup, (String)DStoreResources.RESID_PREFERENCE_DO_KEEPALIVE_LABEL, (Listener)this);
        this._doKeepaliveButton.setToolTipText(DStoreResources.RESID_PREFERENCE_DO_KEEPALIVE_TOOLTIP);
        this._doKeepaliveButton.setLayoutData((Object)new GridData(1, 1, true, false));
        ((GridData)this._doKeepaliveButton.getLayoutData()).horizontalSpan = 2;
        SystemWidgetHelpers.createLabel((Composite)keepaliveGroup, (String)DStoreResources.RESID_PREFERENCE_KEEPALIVE_SOCKET_READ_TIMEOUT_LABEL);
        this._socketReadTimeout = new Text((Composite)keepaliveGroup, 2048);
        gd = new GridData(1, 0x1000000, false, false);
        gd.widthHint = 75;
        gd.horizontalSpan = 1;
        this._socketReadTimeout.setLayoutData((Object)gd);
        this._socketReadTimeout.setTextLimit(10);
        this._socketReadTimeout.setToolTipText(DStoreResources.RESID_PREFERENCE_KEEPALIVE_SOCKET_READ_TIMEOUT_TOOLTIP);
        this._socketReadTimeout.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = true;
                int loop = 0;
                while (loop < e.text.length()) {
                    if (!Character.isDigit(e.text.charAt(loop))) {
                        e.doit = false;
                    }
                    ++loop;
                }
            }
        });
        SystemWidgetHelpers.createLabel((Composite)keepaliveGroup, (String)DStoreResources.RESID_PREFERENCE_KEEPALIVE_RESPONSE_TIMEOUT_LABEL);
        this._keepaliveResponseTimeout = new Text((Composite)keepaliveGroup, 2048);
        gd = new GridData(1, 0x1000000, false, false);
        gd.widthHint = 75;
        gd.horizontalSpan = 1;
        this._keepaliveResponseTimeout.setLayoutData((Object)gd);
        this._keepaliveResponseTimeout.setTextLimit(10);
        this._keepaliveResponseTimeout.setToolTipText(DStoreResources.RESID_PREFERENCE_KEEPALIVE_RESPONSE_TIMEOUT_TOOLTIP);
        this._keepaliveResponseTimeout.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = true;
                int loop = 0;
                while (loop < e.text.length()) {
                    if (!Character.isDigit(e.text.charAt(loop))) {
                        e.doit = false;
                    }
                    ++loop;
                }
            }
        });
        this.initControls();
        return parent;
    }

    private void initControls() {
        IPreferenceStore store = RSEUIPlugin.getDefault().getPreferenceStore();
        int timeout = 0;
        if (store.contains("org.eclipse.rse.connectorservice.dstore.ui.preferences.sockettimeout")) {
            timeout = store.getInt("org.eclipse.rse.connectorservice.dstore.ui.preferences.sockettimeout");
        } else {
            timeout = store.getDefaultInt("org.eclipse.rse.connectorservice.dstore.ui.preferences.sockettimeout");
            store.setDefault("org.eclipse.rse.connectorservice.dstore.ui.preferences.sockettimeout", timeout);
        }
        this._connectionTimeout.setText("" + timeout);
        boolean cacheRemoteClasses = false;
        if (store.contains("org.eclipse.rse.connectorservice.dstore.ui.preferences.cacheremoteclasses")) {
            cacheRemoteClasses = store.getBoolean("org.eclipse.rse.connectorservice.dstore.ui.preferences.cacheremoteclasses");
        } else {
            cacheRemoteClasses = store.getDefaultBoolean("org.eclipse.rse.connectorservice.dstore.ui.preferences.cacheremoteclasses");
            store.setDefault("org.eclipse.rse.connectorservice.dstore.ui.preferences.cacheremoteclasses", cacheRemoteClasses);
        }
        boolean doKeepalive = false;
        doKeepalive = store.contains("org.eclipse.rse.connectorservice.dstore.ui.preferences.dokeepalive") ? store.getBoolean("org.eclipse.rse.connectorservice.dstore.ui.preferences.dokeepalive") : store.getDefaultBoolean("org.eclipse.rse.connectorservice.dstore.ui.preferences.dokeepalive");
        this._doKeepaliveButton.setSelection(doKeepalive);
        int socketTimeout = 0;
        socketTimeout = store.contains("org.eclipse.rse.connectorservice.dstore.ui.preferences.socketreadtimeout") ? store.getInt("org.eclipse.rse.connectorservice.dstore.ui.preferences.socketreadtimeout") : store.getDefaultInt("org.eclipse.rse.connectorservice.dstore.ui.preferences.socketreadtimeout");
        this._socketReadTimeout.setText("" + socketTimeout);
        this._socketReadTimeout.setEnabled(doKeepalive);
        int keepaliveTimeout = 0;
        keepaliveTimeout = store.contains("org.eclipse.rse.connectorservice.dstore.ui.preferences.keepalivetimeout") ? store.getInt("org.eclipse.rse.connectorservice.dstore.ui.preferences.keepalivetimeout") : store.getDefaultInt("org.eclipse.rse.connectorservice.dstore.ui.preferences.keepalivetimeout");
        this._keepaliveResponseTimeout.setText("" + keepaliveTimeout);
        this._keepaliveResponseTimeout.setEnabled(doKeepalive);
        boolean showMismatchedWarning = false;
        showMismatchedWarning = store.contains("org.eclipse.rse.connectorservice.dstore.ui.alert.mismatched.server") ? store.getBoolean("org.eclipse.rse.connectorservice.dstore.ui.alert.mismatched.server") : store.getDefaultBoolean("org.eclipse.rse.connectorservice.dstore.ui.alert.mismatched.server");
        this._showMismatchedServerWarningButton.setSelection(showMismatchedWarning);
    }

    protected void performApply() {
        super.performApply();
        this.applyValues();
    }

    protected void performDefaults() {
        super.performDefaults();
        IPreferenceStore store = RSEUIPlugin.getDefault().getPreferenceStore();
        int timeout = store.getDefaultInt("org.eclipse.rse.connectorservice.dstore.ui.preferences.sockettimeout");
        this._connectionTimeout.setText("" + timeout);
        boolean doKeepalive = store.getDefaultBoolean("org.eclipse.rse.connectorservice.dstore.ui.preferences.dokeepalive");
        this._doKeepaliveButton.setSelection(doKeepalive);
        int socketTimeout = store.getDefaultInt("org.eclipse.rse.connectorservice.dstore.ui.preferences.socketreadtimeout");
        this._socketReadTimeout.setText("" + socketTimeout);
        this._socketReadTimeout.setEnabled(doKeepalive);
        int keepaliveTimeout = store.getDefaultInt("org.eclipse.rse.connectorservice.dstore.ui.preferences.keepalivetimeout");
        this._keepaliveResponseTimeout.setText("" + keepaliveTimeout);
        this._keepaliveResponseTimeout.setEnabled(doKeepalive);
        boolean showMismatchedWarning = store.getDefaultBoolean("org.eclipse.rse.connectorservice.dstore.ui.alert.mismatched.server");
        this._showMismatchedServerWarningButton.setSelection(showMismatchedWarning);
    }

    public void init(IWorkbench workbench) {
    }

    public void handleEvent(Event event) {
        if (event.widget == this._doKeepaliveButton) {
            boolean isEnabled = this._doKeepaliveButton.getSelection();
            this._socketReadTimeout.setEnabled(isEnabled);
            this._keepaliveResponseTimeout.setEnabled(isEnabled);
        }
    }

    private void applyValues() {
        IPreferenceStore store = RSEUIPlugin.getDefault().getPreferenceStore();
        String timeoutStr = this._connectionTimeout.getText();
        int timeout = Integer.parseInt(timeoutStr);
        store.setValue("org.eclipse.rse.connectorservice.dstore.ui.preferences.sockettimeout", timeout);
        boolean doKeepalive = this._doKeepaliveButton.getSelection();
        store.setValue("org.eclipse.rse.connectorservice.dstore.ui.preferences.dokeepalive", doKeepalive);
        String socketTimeoutStr = this._socketReadTimeout.getText();
        int socketTimeout = Integer.parseInt(socketTimeoutStr);
        store.setValue("org.eclipse.rse.connectorservice.dstore.ui.preferences.socketreadtimeout", socketTimeout);
        String keepaliveTimeoutStr = this._keepaliveResponseTimeout.getText();
        int keepaliveTimeout = Integer.parseInt(keepaliveTimeoutStr);
        store.setValue("org.eclipse.rse.connectorservice.dstore.ui.preferences.keepalivetimeout", keepaliveTimeout);
        boolean showMismatchedWarning = this._showMismatchedServerWarningButton.getSelection();
        store.setValue("org.eclipse.rse.connectorservice.dstore.ui.alert.mismatched.server", showMismatchedWarning);
    }

    public boolean performOk() {
        this.applyValues();
        return super.performOk();
    }
}

